

package gov.va.med.cds.clinicaldata.vhim400;


import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.List;

import junit.framework.Assert;


@RunWith( SuiteAwareRunner.class )
public class ConfigurablePathwaysDataResponseTest
{

    @Test
    @Suite( groups = { "checkintest" } )
    public void testBuildEmptyPathwaysDataDocumentWithoutPatient( )
    {
        ConfigurablePathwaysDataResponse dataResponse = new ConfigurablePathwaysDataResponse( "patients/patient", "patients/patient",
                        "PathwaysResponse400", "examsdata", "Examsdata", "RequestsAndExamsData" );
        Document document = dataResponse.buildEmptyPathwaysDocumentWithoutPatient( "templatId1", "requestId1" );
        assertNotNull( document );
        assertFalse( document.asXML().contains( "patient" ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testBuildEmptyPathwaysDataDocumentWithPatient( )
    {
        ConfigurablePathwaysDataResponse dataResponse = new ConfigurablePathwaysDataResponse( "patients/patient", "patients/patient",
                        "PathwaysResponse400", "examsdata", "Examsdata", "RequestsAndExamsData" );
        Document document = dataResponse.buildEmptyPathwaysDocumentWithPatient( "templatId1", "requestId1" );

        Element patientElement = dataResponse.getChildElement( document, "patients/patient" );
        Element clinicalRootElement = dataResponse.getChildElement( document, "patients/patient" );

        Assert.assertNotNull( patientElement );
        Assert.assertNotNull( clinicalRootElement );

        Assert.assertEquals( "/examsdata:RequestsAndExamsData/patients/patient", patientElement.getPath() );
        Assert.assertEquals( "/examsdata:RequestsAndExamsData/patients/patient", clinicalRootElement.getPath() );
    }
}
