

package gov.va.med.cds.audit.persistence.jms;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import gov.va.med.cds.audit.AbstractAuditLog;
import gov.va.med.cds.audit.VhimReadPathwaysResponseAuditLog;
import gov.va.med.cds.audit.VhimReadResponseAuditLog;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;


/**
 * JmsAuditLogPersistenceManagerTest tests JmsAuditLogPersistenceManager functionality of sending JMS Messages containing 
 * audit info to ReadAuditQueue
 */
@RunWith( SuiteAwareRunner.class )
public class JmsAuditLogPersistenceManagerTest
{
    private JmsAuditLogPersistenceManager auditLogPersistenceManager;
    private JmsTemplate readMessagesAuditJmsTemplate;
    private JmsTemplate readRpcMessagesAuditJmsTemplate;


    public JmsAuditLogPersistenceManagerTest( )
    {
        // load up the application context and set the members because we can't
        // use the test harness Abstract test classes because of a circular
        // dependency issue
        ConfigurableApplicationContext appCtxt = new ClassPathXmlApplicationContext(
                        new String[] { "gov/va/med/cds/audit/persistence/jms/nonWeblogicJmsAuditLogContext.xml" } );
        appCtxt.getBeanFactory().autowireBeanProperties( this, AutowireCapableBeanFactory.AUTOWIRE_BY_NAME, true );
    }


    /***
     * storeAuditLogTest uses activemq to test send receive functionality
     */
    @Test
    @Suite( groups = "checkintest" )
    public void storeAuditLogTest( )
    {
        boolean messageThrewException = false;
        AbstractAuditLog receivedAuditLogMessage = null;

        AbstractAuditLog auditLog = new VhimReadResponseAuditLog();
        auditLog.setRequestId( "TESTID" );

        try
        {
            auditLogPersistenceManager.storeAuditLog( auditLog );

        }
        catch ( Exception e )

        {
            messageThrewException = true;
        }

        // there should also be a message in the ADT waiting to be processed.
        receivedAuditLogMessage = ( AbstractAuditLog )readMessagesAuditJmsTemplate.receiveAndConvert();

        assertEquals( receivedAuditLogMessage.getRequestId(), auditLog.getRequestId() );

        assertFalse( "JMSMessageQueue Exception", messageThrewException );
    }
    
    
    /***
     * storeAuditLogTest uses activemq to test send receive functionality
     */
    @Test
    @Suite( groups = "checkintest" )
    public void storeAuditLogTestPathways( )
    {
        boolean messageThrewException = false;
        AbstractAuditLog receivedAuditLogMessage = null;

        VhimReadPathwaysResponseAuditLog auditLog = new VhimReadPathwaysResponseAuditLog();
        auditLog.setRequestId( "TESTID" );

        try
        {
            auditLogPersistenceManager.storeAuditLog( auditLog );

        }
        catch ( Exception e )

        {
            messageThrewException = true;
        }

        // there should also be a message in the ADT waiting to be processed.
        receivedAuditLogMessage = ( AbstractAuditLog )readRpcMessagesAuditJmsTemplate.receiveAndConvert();

        assertEquals( receivedAuditLogMessage.getRequestId(), auditLog.getRequestId() );

        assertFalse( "JMSMessageQueue Exception", messageThrewException );

    }

    
    @Resource
    public void setAuditLogPersistenceManager( JmsAuditLogPersistenceManager auditLogPersistenceManager )
    {
        this.auditLogPersistenceManager = auditLogPersistenceManager;
    }


    @Resource
    public void setReadMessagesAuditJmsTemplate( JmsTemplate readMessagesAuditJmsTemplate )
    {
        this.readMessagesAuditJmsTemplate = readMessagesAuditJmsTemplate;
    }


    @Resource
    public void setReadRpcMessagesAuditJmsTemplate( JmsTemplate readRpcMessagesAuditJmsTemplate )
    {
        this.readRpcMessagesAuditJmsTemplate = readRpcMessagesAuditJmsTemplate;
    }
}
