/**
 * 
 */


package gov.va.med.cds.audit;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.util.StreamUtil;

import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

/**
 * @author vhaislegberb
 *
 */
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class VhimReadResponseAuditLogTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testVhimResponseSizeAndLength( )
        throws IOException
    {
        Resource resource = new ClassPathResource( "gov/va/med/cds/audit/vhimResponse.xml" );
        Resource filterResource = new ClassPathResource( "gov/va/med/cds/audit/vitalsFilter.xml");
        String response = StreamUtil.resourceToString( resource );
        String filter = StreamUtil.resourceToString(filterResource);

        VhimReadResponseAuditLog auditLog = new VhimReadResponseAuditLog();
        auditLog.setEndTime( 12345L );
        auditLog.setLocalTime( new Date( 55555L ) );
        auditLog.setIsoLocalTime( "20081021125959.999-600" );
        auditLog.setFilterRequest(filter);
        auditLog.setRequestId( "REQUEST_ID" );
        auditLog.setResponse( response );
        auditLog.setSendingApplication( "SENDING_APPLICATION" );
        auditLog.setStartTime( 12335L );
        auditLog.setClientId( "CLIENT_ID" );
        auditLog.setClientRequestInitiationTime( "2001-12-17T09:30:47.0Z" );

        StringBuilder sbDebugInfo = new StringBuilder();
        sbDebugInfo.append( "Server CDS v3.x ==> Audit detail: \n" );
        sbDebugInfo.append( "\tdomain => CDS v3.x\n" );
        sbDebugInfo.append( "\tstart_milliseconds => 12335\n" );
        sbDebugInfo.append( "\tmilliseconds => 10\n" );
        sbDebugInfo.append( "\tISO_localtime => " ).append( auditLog.getIsoLocalTime() ).append( "\n" );
        sbDebugInfo.append( "\tlog_information => \n" );
        sbDebugInfo.append( "\t\tstartTime -> 12335\n" );
        sbDebugInfo.append( "\t\tsendingApplication -> SENDING_APPLICATION\n" );
        sbDebugInfo.append( "\t\toriginalMessageControlId -> REQUEST_ID\n" );
        sbDebugInfo.append( "\t\trequesterString -> \n" );
        sbDebugInfo.append( "\t\trequestMsg -> " ).append(filter).append( "\n" );
        sbDebugInfo.append( "\t\treceivingApplication -> CDS v3.x\n" );
        sbDebugInfo.append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime() );

        assertEquals( auditLog.getDebugInfo(), sbDebugInfo.toString() );
    }
    
    
    @Test
    @Suite( groups = "checkintest" )
    public void testTiuVhimResponseSizeAndLength( )
        throws IOException
    {
        Resource resource = new ClassPathResource( "gov/va/med/cds/audit/TiuDetailedReadResult.xml" );
        Resource filterResource = new ClassPathResource( "gov/va/med/cds/audit/vitalsFilter.xml");
        String response = StreamUtil.resourceToString( resource );
        String filter = StreamUtil.resourceToString(filterResource);

        VhimReadResponseAuditLog auditLog = new VhimReadResponseAuditLog();
        auditLog.setEndTime( 12345L );
        auditLog.setFacility( "FACILITY" );
        auditLog.setIsoLocalTime( "20081021125959.999-600" );
        auditLog.setFilterRequest(filter );
        auditLog.setRequestId( "REQUEST_ID" );
        auditLog.setResponse( response );
        auditLog.setSendingApplication( "SENDING_APPLICATION" );
        auditLog.setStartTime( 12335L );
        auditLog.setClientId( "CLIENT_ID" );
        auditLog.setClientRequestInitiationTime( "2001-12-17T09:30:47.0Z" );
        
        StringBuilder sbDebugInfo = new StringBuilder();
//        sbDebugInfo.append( "Server CDS v3.x ==> Audit detail: \n" ).append( "\tsessionId => TEMPLATE_ID[FACILITYREQUEST_ID]\n" )
//                        .append( "\tdomain => CDS v3.x\n" ).append( "\tstart_milliseconds => 12335\n" ).append( "\tmilliseconds => 10\n" )
//                        .append( "\tISO_localtime => " ).append( auditLog.getIsoLocalTime() ).append( "\n" ).append( "\tlog_point => \n" )
//                        .append( "\tthreadId => \n" ).append( "\tpurpose => TEMPLATE_ID\n" ).append( "\tfacility => FACILITY\n" )
//                        .append( "\ttemplateId => TEMPLATE_ID\n" ).append( "\tclientIdentifier => CLIENT_ID\n" )
//                        .append( "\tclientRequestInitiationTime => " ).append( auditLog.getClientRequestInitiationTime() ).append( "\n" )
//                        .append( "\tlog_information => \n" ).append( "\t\tstartTime -> 12335\n" ).append( "\t\tpurpose -> TEMPLATE_ID\n" )
//                        .append( "\t\tsendingApplication -> SENDING_APPLICATION\n" ).append( "\t\toriginalMessageControlId -> REQUEST_ID\n" )
//                        .append( "\t\tmachine -> " ).append( "localhost:PORT" ).append( "\n" ).append( "\t\trequesterString -> \n" )
//                        .append( "\t\tsendingFacility -> FACILITY\n" ).append( "\t\tresponseSize -> " ).append( response.length() ).append( "\n" )
//                        .append( "\t\trequestMsg -> REQUEST\n" ).append( "\t\treceivingApplication -> CDS v3.x\n" )
//                        .append( "\t\tresponseLength -> 1\n" ).append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime() );
        
        sbDebugInfo.append( "Server CDS v3.x ==> Audit detail: \n" );
        sbDebugInfo.append( "\tdomain => CDS v3.x\n" );
        sbDebugInfo.append( "\tstart_milliseconds => 12335\n" );
        sbDebugInfo.append( "\tmilliseconds => 10\n" );
        sbDebugInfo.append( "\tISO_localtime => " ).append( auditLog.getIsoLocalTime() ).append( "\n" );
        sbDebugInfo.append( "\tlog_information => \n" );
        sbDebugInfo.append( "\t\tstartTime -> 12335\n" );
        sbDebugInfo.append( "\t\tsendingApplication -> SENDING_APPLICATION\n" );
        sbDebugInfo.append( "\t\toriginalMessageControlId -> REQUEST_ID\n" );
        sbDebugInfo.append( "\t\trequesterString -> \n" );
        sbDebugInfo.append( "\t\trequestMsg -> " ).append(filter).append( "\n" );
        sbDebugInfo.append( "\t\treceivingApplication -> CDS v3.x\n" );
        sbDebugInfo.append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime() );
        
        String di = auditLog.getDebugInfo();
        

        assertEquals( auditLog.getDebugInfo(), sbDebugInfo.toString() );

        resource = new ClassPathResource( "gov/va/med/cds/audit/TiuListReadResult.xml" );
        response = StreamUtil.resourceToString( resource );

        auditLog.setResponse( response );

        sbDebugInfo = new StringBuilder();
//        sbDebugInfo.append( "Server CDS v3.x ==> Audit detail: \n" ).append( "\tsessionId => TEMPLATE_ID[FACILITYREQUEST_ID]\n" )
//                        .append( "\tdomain => CDS v3.x\n" ).append( "\tstart_milliseconds => 12335\n" ).append( "\tmilliseconds => 10\n" )
//                        .append( "\tISO_localtime => " ).append( auditLog.getIsoLocalTime() ).append( "\n" ).append( "\tlog_point => \n" )
//                        .append( "\tthreadId => \n" ).append( "\tpurpose => TEMPLATE_ID\n" ).append( "\tfacility => FACILITY\n" )
//                        .append( "\ttemplateId => TEMPLATE_ID\n" ).append( "\tclientIdentifier => CLIENT_ID\n" )
//                        .append( "\tclientRequestInitiationTime => " ).append( auditLog.getClientRequestInitiationTime() ).append( "\n" )
//                        .append( "\tlog_information => \n" ).append( "\t\tstartTime -> 12335\n" ).append( "\t\tpurpose -> TEMPLATE_ID\n" )
//                        .append( "\t\tsendingApplication -> SENDING_APPLICATION\n" ).append( "\t\toriginalMessageControlId -> REQUEST_ID\n" )
//                        .append( "\t\tmachine -> " ).append( "localhost:PORT" ).append( "\n" ).append( "\t\trequesterString -> \n" )
//                        .append( "\t\tsendingFacility -> FACILITY\n" ).append( "\t\tresponseSize -> " ).append( response.length() ).append( "\n" )
//                        .append( "\t\trequestMsg -> REQUEST\n" ).append( "\t\treceivingApplication -> CDS v3.x\n" )
//                        .append( "\t\tresponseLength -> 14\n" ).append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime() );

        sbDebugInfo.append( "Server CDS v3.x ==> Audit detail: \n" );
        sbDebugInfo.append( "\tdomain => CDS v3.x\n" );
        sbDebugInfo.append( "\tstart_milliseconds => 12335\n" );
        sbDebugInfo.append( "\tmilliseconds => 10\n" );
        sbDebugInfo.append( "\tISO_localtime => " ).append( auditLog.getIsoLocalTime() ).append( "\n" );
        sbDebugInfo.append( "\tlog_information => \n" );
        sbDebugInfo.append( "\t\tstartTime -> 12335\n" );
        sbDebugInfo.append( "\t\tsendingApplication -> SENDING_APPLICATION\n" );
        sbDebugInfo.append( "\t\toriginalMessageControlId -> REQUEST_ID\n" );
        sbDebugInfo.append( "\t\trequesterString -> \n" );
        sbDebugInfo.append( "\t\trequestMsg -> " ).append(filter).append( "\n" );
        sbDebugInfo.append( "\t\treceivingApplication -> CDS v3.x\n" );
        sbDebugInfo.append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime() );
        
        assertEquals( auditLog.getDebugInfo(), sbDebugInfo.toString() );
    }


    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = "Ignore" )
    public void testVhimResponseSizeAndLengthWithErrorResponse( )
        throws IOException
    {
        VhimReadResponseAuditLog auditLog = new VhimReadResponseAuditLog();
        auditLog.setEndTime( 12345L );
        auditLog.setLocalTime( new Date( 55555L ) );
        auditLog.setIsoLocalTime( "20081021125959.999-600" );
        auditLog.setFilterRequest( "REQUEST" );
        auditLog.setRequestId( "REQUEST_ID" );
        auditLog.setResponse( "<InvalidResponse>" );
        auditLog.setSendingApplication( "SENDING_APPLICATION" );
        auditLog.setStartTime( 12335L );

        auditLog.getDebugInfo();
        auditLog.getResponseLength();
    }
}
