

package gov.va.med.cds.util;


import org.springframework.core.io.Resource;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;


/**
 * Utility that provides helpers for resources and streams
 */
public class StreamUtil
{
    /**
     * Gets the string content of a resource
     * 
     * @param resource Resource containing the string
     * @return the string content of the resource
     * @throws IOException
     */
    public static String resourceToString( Resource resource )
        throws IOException
    {
        return streamToString( resource.getInputStream() );
    }

    /**
     * Gets the byte[] content of a resource
     * 
     * @param resource Resource containing the binary content
     * @return byte[] bytes available in resource
     * @throws IOException 
     */
    public static byte[] resourceToBytes( Resource resource) throws IOException
    {
    	InputStream is = resource.getInputStream();
    	byte[] bytes = new byte[is.available()];
    	is.read(bytes);
    	is.close();    	
    	return bytes;
    }
    

    /**
     * Gets the string content of a stream
     * 
     * @param input input stream
     * @return the string content of the stream
     * @throws IOException
     */
    public static String streamToString( InputStream input )
        throws IOException

    {
        StringBuilder buffer = new StringBuilder();
        BufferedReader inputBufferedReader = new BufferedReader( new InputStreamReader( input ) );

        char[] buff = new char[1024];
        int count = 0;

        while ( ( count = inputBufferedReader.read( buff ) ) != -1 )
        {
            buffer.append( buff, 0, count );
        }

        inputBufferedReader.close();

        return buffer.toString();
    }


    /**
     * Read a string from a text file
     * 
     * @param in
     * @return
     * @throws IOException
     */
    public static String streamAsString( Reader in )
        throws IOException
    {
        StringBuilder buf = new StringBuilder();
        char[] chars = new char[1024];
        int read;
        while ( ( read = in.read( chars ) ) > 0 )
        {
            buf.append( chars, 0, read );
        }
        try
        {
            in.close();
        }
        catch ( IOException ignore )
        {
        }

        return buf.toString();
    }


    public static void putToFile( String outStr, String fileName )
        throws IOException
    {
        FileWriter writer = new FileWriter( fileName );
        writer.write( outStr );
        writer.flush();
        writer.close();
    }
    
    public static void putToFile( byte[] bytes, String filename)
    {
    	try
    	{
    		FileOutputStream fos = new FileOutputStream(filename);
    		fos.write(bytes);
    		fos.flush();
    		fos.close();    		
    	}
    	catch ( Exception e)
    	{
    		e.printStackTrace();
    	}
    }
    
    
}
