

package gov.va.med.cds.util;


/**
 * Utility that concatenates the logger message with ClinialDomain, RequestId and ApplicationName
 */
public class LogMessageUtil
{
    private static final String MESSAGE_DELIMETER = "#";
    private static final String EMPTY_STRING = "";


    /**
     * Returns concatenated ClinialDomain, RequestId, ErrorMessage and ApplicationName
     *
     * @param clinicalDomain Name of the ClinicalDomain
     * @param requestId Values of RequestId
     * @param appName Name of the Application
     * @param errorMessage error message to be parsed
     * @return the concatenated error message
     */
    public static String buildMessage( String clinicalDomain, String requestId, String appName, String errorMessage )
    {
        if ( clinicalDomain == null )
        {
            clinicalDomain = EMPTY_STRING;
        }
        if ( requestId == null )
        {
            requestId = EMPTY_STRING;
        }
        if ( appName == null )
        {
            appName = EMPTY_STRING;
        }
        if ( errorMessage == null )
        {
            errorMessage = EMPTY_STRING;
        }

        StringBuilder message = new StringBuilder();

        message.append( MESSAGE_DELIMETER );
        message.append( clinicalDomain ).append( MESSAGE_DELIMETER );
        message.append( requestId ).append( MESSAGE_DELIMETER );
        message.append( appName ).append( MESSAGE_DELIMETER );
        message.append( errorMessage );

        return quotedString( message.toString() );
    }


    /**
     * Creates a SQL-quoted string. Any single-quotes ['] are doubled [''] in order to make the string "SQL compatible".
     *
     * @param source Description of Parameter
     * @return "SQL Compatible" string, after replacing single-quotes ['] with double quotes ['']
     */
    private static String quotedString( String source )
    {
        if ( source == null )
        {
            return EMPTY_STRING;
        }
        else
        {
            // ???? why isn't this using the " char?  I would think two singles would be screwey-er. SJB
            source = replace( source, "'", "''" );
        }

        return source;
    }


    /**
     * String-replacer
     *
     * @param source Description of Parameter
     * @param find Description of Parameter
     * @param replacement Description of Parameter
     * @return Description of the Returned Value
     */
    public static String replace( String source, String find, String replacement )
    {
        int i = 0;
        int j;
        int k = find.length();
        int m = replacement.length();

        while ( i < source.length() )
        {
            j = source.indexOf( find, i );

            if ( j == -1 )
            {
                break;
            }

            source = replace( source, j, j + k, replacement );

            i = j + m;
        }

        return source;
    }


    /**
     * String-replacer
     *
     * @param source Description of Parameter
     * @param start Description of Parameter
     * @param end Description of Parameter
     * @param replacement Description of Parameter
     * @return String after replacing provided character set
     */
    public static String replace( String source, int start, int end, String replacement )
    {
        if ( start == 0 )
        {
            source = replacement + source.substring( end );
        }
        else if ( end == source.length() )
        {
            source = source.substring( 0, start ) + replacement;
        }
        else
        {
            source = source.substring( 0, start ) + replacement + source.substring( end );
        }

        return source;
    }


    /**
     * int-replacer
     *
     * @param source Description of Parameter
     * @param find Description of Parameter
     * @param replacement Description of Parameter
     * @return String after replacing provided character set
     */
    public static String replace( String source, String find, int replacement )
    {
        String sReplacement = Integer.toString( replacement );

        return replace( source, find, sReplacement );
    }
}
