

package gov.va.med.cds.util;


import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;


public class DateTimeUtil
{

    public final static String FORMAT_FULL = "yyyyMMddHHmmss.SSS";
    public final static String FORMAT_PARTIAL = "yyyMddHHmm";
    public final static String FORMAT_DATE_TIME = "yyyyMMdd.HHmmss";
    public final static String FORMAT_TZ = "Z";


    /**
     * 
     * This method converts the given time from milliseconds to ISO format string.
     * 
     * @param milliseconds the time, in milliseconds
     * @param timezone if null, use default.
     * @return String. This is the ISO date format that corresponds to the
     * 
     * given date in milliseconds.
     * 
     * @since jdk1.2
     * 
     */

    public static String getISOTime( long milliseconds, TimeZone timezone )

    {
        final String format = FORMAT_FULL + FORMAT_TZ;
        DateFormat df = new SimpleDateFormat( format );

        if ( null != timezone )
        {
            df.setTimeZone( timezone );
        }
        return df.format( new Date( milliseconds ) );
    }


    public static String getPartialISOTime( long milliseconds, TimeZone timezone )

    {
        final String format = FORMAT_PARTIAL;
        DateFormat df = new SimpleDateFormat( format );

        if ( null != timezone )
        {
            df.setTimeZone( timezone );
        }
        return df.format( new Date( milliseconds ) );
    }


    public static String getDateTimeDotSeparated( long milliseconds, TimeZone timezone )
    {
        final String format = FORMAT_DATE_TIME;
        DateFormat df = new SimpleDateFormat( format );

        if ( null != timezone )
        {
            df.setTimeZone( timezone );
        }
        return df.format( new Date( milliseconds ) );
    }


    public static String stripTimeZoneOffset( String timeStamp )
    {
        return timeStamp.substring( 0, timeStamp.indexOf( "." ) );
    }
}
