

package gov.va.med.cds.properties;


import java.io.IOException;
import java.util.Properties;

import javax.crypto.spec.SecretKeySpec;


public class PropertiesUtil 
{
    public static final String PROPERTIES_KEYSTORE_FILE_PATH_PROPERTY = "cds.keystore.properties.path";
    private PropertiesManager propertiesManager = null;
    
    public PropertiesUtil( )
    {
        if ( getPropertiesManager() == null )
            propertiesManager = new PropertiesManager();
    };
    
    /*
     * Loads Properties from the properties file and, based on the encryption flag,
     * will encrypt the plain text passwords and override the existing file with encrypted passwords.
     * Encrypted passwords stored in properties file and will be decrypted before used by application.  
     */
    public void loadSystemRunProperties( )
        throws IOException
    {
        String propertiesFilePath = propertiesManager.getPropertiesFilePathFromSystemProperties();
        
        if ( propertiesFilePath != null )
        {
            //switch system property that indicates whether a property file must be encrypted or not
            String encrypt = propertiesManager.getEncryptSwitchFromSystemProperties();
            
            //password system property that protects KeyStore access
            String keyStorePassword = propertiesManager.getKeyStorePasswordFromSystemProperties();

            Properties fileProps = propertiesManager.loadPropertiesFromPropertiesFile( propertiesFilePath );

            SecretKeySpec savedKey = null;
            //the KeyStore file path is expected  to be inside the property file when encryption is expected
            String keyStoreFileLocation = fileProps.getProperty( PROPERTIES_KEYSTORE_FILE_PATH_PROPERTY );

            //encrypt property file
            if ( encrypt != null && encrypt.equalsIgnoreCase( "true" ) )
            {
                savedKey = propertiesManager.configureKeyStore( keyStoreFileLocation, keyStorePassword );
                encryptProperties( propertiesFilePath, fileProps, savedKey );
            }

            //attempt to decrypt fileProps - this may not be necessary as fileProps may not be encrypted
            //so an error will thrown only if keystore information is missing 
            //and an encrypted property is discovered in fileProps
            fileProps = propertiesManager.decryptProperties( savedKey, keyStoreFileLocation, keyStorePassword, fileProps );

            //now load all properties (some may have been decrypted) into system
            propertiesManager.updateSystemProperties( fileProps );
        }
    }

    protected void encryptProperties( String propertiesFilePath, Properties fileProps, SecretKeySpec savedKey )
        throws IOException
    {
        propertiesManager.encryptProperties( savedKey, propertiesFilePath, ( Properties )fileProps.clone() );
    }

    /**
     * Getters and setters
     */
    PropertiesManager getPropertiesManager( )
    {
        return propertiesManager;
    }

    void setPropertiesManager( PropertiesManager propertiesManager )
    {
        this.propertiesManager = propertiesManager;
    }


}
