

package gov.va.med.cds.exceptionframework;


import java.util.List;


/**
 *
 * Used for logging the exception to different loggers (Default ), its message and error id.
 *
 */

public interface ExceptionLoggerInterface
{

    /**
     * Logs the exception message to the specified loggers.
     *
     * @param exception Thrown exception.
     * @param loggingSeverity Severity level of the exception.
     * @param entryPoint entry point
     * @param requestId client provided unique request ID
     * @param applicationName The application name.
     * @return True if logging is successful.
     */
    boolean log( List<ExceptionInfo> exceptionInfos, LoggingSeverity loggingSeverity, String entryPoint, String requestId, String applicationName );
    
//    boolean log( Exception exception, LoggingSeverity loggingSeverity, String message, String entryPoint, String requestId, String applicationName );
  
    /**
     * Embeds the exception message with user defined message and logs to the specified loggers.
     *
     * @param exception Thrown exception.
     * @param message Additional information to be appended to the exception message.
     * @param entryPoint entry point
     * @param requestId client provided unique request ID
     * @return True if logging is successful.
     */
    boolean log( ExceptionInfo exceptionInfo, String message, String entryPoint, String requestId, String applicationName );
    
//    boolean log( Exception exception, String message, String entryPoint, String requestId, String applicationName );
  
}
