

package gov.va.med.cds.exception;


/**
 * Handles exceptions thrown by AuditLogPersistenceManager.
 * 
 */
public class CdsAuditLogException
    extends
        AbstractCdsBaseException
{

    private static final long serialVersionUID = 4783429399489832692L;


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     */
    public CdsAuditLogException( ErrorCodeEnum errorCodeName )
    {
        super( errorCodeName );
    }


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     * @param messages - list of messages to be integrated into exception message.
     */
    public CdsAuditLogException( ErrorCodeEnum errorCodeName, String... messages )
    {
        super( errorCodeName, messages );
    }


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     * @param customMsg - list of messages to be integrated into exception message.
     */
    public CdsAuditLogException( ErrorCodeEnum errorCode, Throwable cause, String... customMsg )
    {
        super( errorCode, cause, customMsg );
    }
}
