

package gov.va.med.cds.clinicaldata.vhim400;


import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.springframework.util.StringUtils;


public class ConfigurablePathwaysDataResponse
    extends
        ConfigurableClinicalDataResponse
    implements
        PathwaysDataResponseInterface

{
    private String schemaNamespacePrefix;
    private String schemaNamespaceUri;
    private String schemaLocalName;
    private static String SCHEMA_NAMESPACE_PREFIX = "pathwaysdata";
    private static String SCHEMA_NAMESPACE_URI = "Pathwaysdata";
    private static String SCHEMA_LOCAL_NAME = "PathwaysData";


    public ConfigurablePathwaysDataResponse( String patientElementPath, String clinicalRootPath, String errorResponseTemplateId )
    {
        super( patientElementPath, clinicalRootPath, errorResponseTemplateId );
    }


    public ConfigurablePathwaysDataResponse( String patientElementPath, String clinicalRootPath, String errorResponseTemplateId,
                    String schemaNamespacePrefix, String schemaNamespaceUri, String schemaLocalName )
    {
        super( patientElementPath, clinicalRootPath, errorResponseTemplateId );
        this.schemaNamespacePrefix = schemaNamespacePrefix;
        this.schemaNamespaceUri = schemaNamespaceUri;
        this.schemaLocalName = schemaLocalName;
    }


    public Document buildEmptyPathwaysDocumentWithPatient( String templateId, String requestId )
    {
        return buildPathwaysDocument( templateId, requestId, true );
    }


    public Document buildEmptyPathwaysDocumentWithoutPatient( String templateId, String requestId )
    {
        return buildPathwaysDocument( templateId, requestId, false );
    }


    private Document buildPathwaysDocument( String templateId, String requestId, boolean addPatient )
    {
        if ( !StringUtils.hasText( schemaNamespacePrefix ) )
        {
            schemaNamespacePrefix = SCHEMA_NAMESPACE_PREFIX;
        }
        if ( !StringUtils.hasText( schemaNamespaceUri ) )
        {
            schemaNamespaceUri = SCHEMA_NAMESPACE_URI;
        }
        if ( !StringUtils.hasText( schemaLocalName ) )
        {
            schemaLocalName = SCHEMA_LOCAL_NAME;
        }

        Namespace pathwaysDataNamespace = DocumentHelper.createNamespace( schemaNamespacePrefix, schemaNamespaceUri );
        Element pathwaysDataElement = DocumentHelper.createElement( DocumentHelper.createQName( schemaLocalName, pathwaysDataNamespace ) );

        if ( templateId != null )
        {

            getChildElement( pathwaysDataElement, templateIdElementName, true ).addText( templateId );
        }

        if ( requestId != null )
        {
            getChildElement( pathwaysDataElement, requestIdElementName, true ).addText( requestId );
        }

        if ( addPatient )
        {
            getChildElement( pathwaysDataElement, this.patientElementPath, true );
        }

        return DocumentHelper.createDocument( pathwaysDataElement );
    }

}
