package gov.va.med.cds.clinicaldata.vhim400;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.Element;

public interface ClinicalDataResponseInterface
{

    Document buildEmptyClinicalDocument();
    
    Document buildEmptyClinicalDocument(String templateId, String requestId);
    
    Document buildEmptyClinicalDocument(String templateId, String requestId, String clientName);
    
    Document buildEmptyClinicalDocument( String templateId, String requestId, boolean addPatient );
    
    Document buildEmptyClinicalDocumentWithPatient();
        
    Document buildEmptyClinicalDocumentWithPatient(String templateId, String requestId);
    
    Document buildEmptyClinicalDocumentWithoutPatient(String templateId, String requestId);
    
    Document buildClinicalDocumentWithCreatedIdentifiers( String templateId, String requestId, List<Element> createdIdentifiers );
    
    Document buildClinicalDocumentWithCreatedIdentifiers( String templateId, String requestId, List<Element> createdIdentifiers, boolean addPatient );
    
    Element buildRecordIdentifierElement( String recordIdentifier, Element clinicalData );
    
    Element getClinicalRoot( Document document );
    
    Element getPatientElement( Document document );
    
    Element getErrorSectionRoot( Document document );
    
    Element getTemplateId( Document document );
    
    Element setTemplateIdText( Document document, String templateIdText );
    
    Element getRequestId( Document document );
    
    Element getRequestedNationalId( Document document );
    
    Element getChildElement(Document document, String name);
    
    Element getChildElement( Document document, String name, boolean create );
    
    String getErrorResponseTemplateId();
    
    Document addRequestedNationalId( Document document, String nationalId );
    
    Element getResultantIdentifiers(Document document);
    
    Element getRequestedResolvedIdentifiers(Document document);
    
    Element getRequestedEdipi(Document document);
    
    Element getRequestedExcludedIdentifiers(Document document);
    
    Document buildErrorResponse( String templateId, String requestId, Document writeResultDocument, Document clinicalDataDocument );
}
