/**
 * 
 */


package gov.va.med.cds.clinicaldata;


import org.dom4j.Element;

import java.util.List;


/**
 * @author vhaislecclej
 * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
 */
public enum DomainEntryPoint
{
    ADLSurveyResponse( "ADLSurveyResponse", "SURVEY", "adlSurveyResponse" ), 
    PSSurveyResponse( "PSSurveyResponse", "SURVEY", "psSurveyResponse" ), 
    DMPSurveyResponse( "DMPSurveyResponse", "SURVEY", "dmpSurveyResponse" ), 
    CensusSurveyResponse( "CensusSurveyResponse", "SURVEY", "censusSurveyResponse" ),
    VitalSignObservationEvent( "VitalSignObservationEvent", "VITAL", "vitalSignObservationEvents" ), 
    IntoleranceCondition( "IntoleranceCondition", "ALLERGY", "intoleranceConditions" ), 
    AllergyAssessment( "AllergyAssessment", "ALLERGY", "allergyAssessments" ), 
    OutpatientMedicationPromise( "OutpatientMedicationPromise", "PHARMACY", "outpatientMedicationPromises" ), 
    LabTestPromise( "LabTestPromise", "LAB", "labTestPromises" ), 
    NonVaMedicationEvent( "NonVaMedicationEvent", "NONVAMED", "nonVaMedicationEvent" ), 
    ClinicalDocumentEvent( "ClinicalDocumentEvent", "TIU", "clinicalDocumentEvents" ), 
    ImmunizationEvent( "ImmunizationEvent", "IMMUNIZATION", "immunizationEvents" ), 
    SkinTestProcedure( "SkinTestProcedure", "SKINTEST", "skinTestProcedures" ), 
    HealthConcern( "HealthConcern", "PROBLEMLIST", "healthConcern" ), 
    ExamRequest2507( "ExamRequest2507", "EXAMREQUEST", "examRequests" ), 
    Exam2507( "Exam2507", "EXAM", "exams" ), 
    Appointment( "Appointment", "Appointment", "appointments" ), 
    PatientEnteredVitalSign( "PatientEnteredVitalSign", "VITAL", "patientEnteredVitalSigns", "patientEnteredVitalSign" ), 
    PatientEnteredExerciseJournalEntry( "PatientEnteredExerciseJournalEntry", "EXCERCISEJOURNAL", "patientJournalEntries", "patientEnteredExerciseJournalEntry" ), 
    PatientEnteredDietJournalEntry( "PatientEnteredDietJournalEntry", "DIETJOURNAL", "patientJournalEntries", "patientEnteredDietJournalEntry" ), 
    PatientEnteredContactLogJournalEntry( "PatientEnteredContactLogJournalEntry", "CONTACTLOGJOURNAL", "patientJournalEntries", "patientEnteredContactLogJournalEntry" ), 
    PatientEnteredDailyEventJournalEntry( "PatientEnteredDailyEventJournalEntry", "DAILYEVENTJOURNAL", "patientJournalEntries", "patientEnteredDailyEventJournalEntry" ), 
    PatientEnteredMoodJournalEntry( "PatientEnteredMoodJournalEntry", "MOODJOURNAL", "patientJournalEntries", "patientEnteredMoodJournalEntry" ), 
    CalendarEvent( "CalendarEvent", "CALENDAREVENT", "calendarEvents", "calendarEvent" ), 
    QuestionnaireResult( "QuestionnaireResult", "QUESTIONNAIRERESULT", "questionnaireResults", "questionnaireResult" ),
    GoalTracking("GoalTracking", "GOALTRACKING", "goalsTracking","goalTracking"),
    SkillTracking("SkillTracking","SKILLTRACKING", "skillsTracking", "skillTracking"),
    PainEvent("PainEvent","PAINEVENT","painEvents","painEvent"),
    PainReassessment("PainReassessment","PAINREASSESMENT","painReassessments","painReassessment"),
    PainAssessment("PainAssessment", "PAINASSESSMENT","painAssessments", "painAssessment"),
    AssessmentDocument("AssessmentDocument","ASSESSMENTDOCUMENT","assessmentDocuments","assessmentDocument"),
    SmartFormDocument( "SmartFormDocument", "SMARTFORMDOCUMENT", "smartFormDocuments", "smartFormDocument" ),
    GenericObservation( "GenericObservation", "GENERICOBSERVATION", "genericObservations", "genericObservation"),
    PatientGeneratedDataEvent( "PatientGeneratedDataEvent", "PGD", "patientGeneratedDataEvents", "patientGeneratedDataEvent");
    
    private String name;
    private String domain;
    private String entityName;
    private String clinicalDataElement;


    DomainEntryPoint( String aName, String aDomain, String entityName )
    {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
    }


    DomainEntryPoint( String aName, String aDomain, String entityName, String clinicalDataElement )
    {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
        this.clinicalDataElement = clinicalDataElement;
    }


    public String getName( )
    {
        return name;
    }


    public void setName( String aName )
    {
        name = aName;
    }


    public String getDomain( )
    {
        return domain;
    }


    public void setDomain( String domain )
    {
        this.domain = domain;
    }


    public String getEntityName( )
    {
        return entityName;
    }


    public void setEntityName( String entityName )
    {
        this.entityName = entityName;
    }


    public String getClinicalDataElement( )
    {
        return clinicalDataElement;
    }


    public void setClinicalDataElement( String clinicalDataElement )
    {
        this.clinicalDataElement = clinicalDataElement;
    }


    @SuppressWarnings( "unchecked" )
    public List<Element> getClinicalRecords( Element rootElement )
    {
        List<Element> clinicalRecords = null;

        if ( this.clinicalDataElement != null )
        {
            // CDS 3.x creates
            Element wrapperElement = rootElement.element( this.entityName );
            clinicalRecords = ( wrapperElement != null ) ? wrapperElement.elements( this.clinicalDataElement ) : null;
        }
        else
        {
            // CDS 2.x create templates with only plural clinicalDataElement
            clinicalRecords = rootElement.elements( this.entityName );
        }

        return clinicalRecords;
    }

    public static final String DOMAIN_ENTRY_POINT_PROPERTY_NAME = "DomainEntryPoints";
}
