package gov.va.med.cds.clinicaldata;

import java.util.Map;

import org.dom4j.Element;


/**
 * Interface defines the service used to locate a clinical record's recordIdentifier.identity element value as well
 * as any child element or elements' recordIdentifier.identity values.
 * 
 * This service provides a necessary work-around to the Hibernate framework's limitations in mapping the <id> element to our <recordIdentifier.identity> element.
 * When performing an update using the dynamic model, Hibernate requires the <id> to be present in the xml in order to pre-select and locate the record.
 * 
 * This service will locate through dom4j api calls the owning parent and if configured its child elements' recordIdentifier.identity and insert an <id> with the identity value
 * into the XML before forwarding an UPDATE to the Hibernate framework.
 * 
 * @author vhaisltalbom
 *
 */
public interface DomainClinicalRecordElementHelperInterface
{
    public static final String DEFAULT_DOMAIN_OWNER = "defaultDomainOwner";
          
    public void setDomainIdentityOwner( String domainIdentityOwner );
  
    public Map<String, String> getChildCollectionsAndIdentityOwners( );
  
    public void setChildCollectionsAndIdentityOwners( Map<String, String> childCollectionsAndIdentityOwners );
        
    public void setFacilityOwner( String facilityOwner );
        
    public void setAuthorityOwner( String authorityOwner );
    
    public String addIdToClinicalRecordElement(Element clinicalRecordElement);
   
    public String addIdToParentAndChildElements(Element parentElement);
    
    public String getAssigningFacilityValue(Element clinicalRecord);
    
    public String getAssigningAuthorityValue(Element clinicalRecord);
    

}
