/**
 * 
 */


package gov.va.med.cds.audit;


import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;


/**
 * @author vhaislegberb
 *
 */
public class VhimReadResponseAuditLog
    extends
        AbstractAuditLog
{
    private static final long serialVersionUID = 1L;


    /* (non-Javadoc)
     * @see gov.va.med.cds.audit.AbstractAuditLog#getResponseLength(java.lang.String)
     */
    @SuppressWarnings( "rawtypes" )
    @Override
    protected int getResponseLength( String response )
    {

        int responseLength = 0;
        if ( response == null )
        {
            return responseLength;
        }

        try
        {
            Document document = DocumentHelper.parseText( response );
            Element rootElement = document.getRootElement();

            for ( Iterator patientIterator = rootElement.elementIterator( "patient" ); patientIterator.hasNext(); )
            {
                Element patientElement = ( Element )patientIterator.next();
                responseLength += patientElement.elements( "allergyAssessments" ).size();
                responseLength += patientElement.elements( "intoleranceConditions" ).size();
                responseLength += patientElement.elements( "vitalSignObservationEvents" ).size();
                responseLength += patientElement.elements( "outpatientMedicationPromises" ).size();
                responseLength += patientElement.elements( "labTestPromises" ).size();
            }

            if ( rootElement.element( "patients" ) != null )
            {
                Map<String, String> namespaceUris = new HashMap<String, String>();
                namespaceUris.put( "patientjournaling", "PatientJournaling" );
                
                for ( Iterator patientIterator = rootElement.element( "patients" ).elementIterator( "patient" ); patientIterator.hasNext(); )
                {
                    Element patientElement = ( Element )patientIterator.next();
                    responseLength += patientElement.selectNodes( "clinicalDocumentEvents/clinicalDocumentEvent" ).size();
                    responseLength += patientElement.selectNodes( "nonVaMedicationEvents/nonVaMedicationEvent" ).size();
                    responseLength += patientElement.selectNodes( "skinTestProcedures/skinTestProcedure" ).size();
                    responseLength += patientElement.selectNodes( "immunizationEvents/immunizationEvent" ).size();
                    responseLength += patientElement.selectNodes( "healthConcerns/healthConcern" ).size();
                    responseLength += patientElement.selectNodes( "outpatientMedicationPromises/outpatientMedicationPromise" ).size();
                    responseLength += patientElement.selectNodes( "labTestPromises/labTestPromise" ).size();
                    responseLength += patientElement.selectNodes( "patientEnteredVitalSigns/patientEnteredVitalSign" ).size();
                    responseLength += patientElement.selectNodes( "calendarEvents/calendarEvent" ).size();
                    responseLength += patientElement.selectNodes( "skillsTracking/skillTracking" ).size();
                    responseLength += patientElement.selectNodes( "goalsTracking/goalTracking" ).size();
                    responseLength += patientElement.selectNodes( "painEvents/painEvent" ).size();
                    responseLength += patientElement.selectNodes( "painReassessments/painReassessment" ).size();
                    responseLength += patientElement.selectNodes( "painAssessments/painAssessment" ).size();
                    responseLength += patientElement.selectNodes( "assessmentDocuments/assessmentDocument" ).size();
                    responseLength += patientElement.selectNodes( "questionnaireResults/questionnaireResult" ).size();
                    responseLength += patientElement.selectNodes( "smartFormDocuments/smartFormDocument" ).size();
                    

                    // Need to handle namespace in selection of HA journal entry domains
                    XPath xpathDiet = DocumentHelper.createXPath( "patientJournalEntries/patientjournaling:patientEnteredDietJournalEntry" );
                    xpathDiet.setNamespaceURIs( namespaceUris );
                    responseLength += xpathDiet.selectNodes( patientElement ).size();
                    
                    XPath xpathMood = DocumentHelper.createXPath( "patientJournalEntries/patientjournaling:patientEnteredMoodJournalEntry" );
                    xpathMood.setNamespaceURIs( namespaceUris );
                    responseLength += xpathMood.selectNodes( patientElement ).size();
                    
                    XPath xpathContactLog = DocumentHelper.createXPath( "patientJournalEntries/patientjournaling:patientEnteredContactLogJournalEntry" );
                    xpathContactLog.setNamespaceURIs( namespaceUris );
                    responseLength += xpathContactLog.selectNodes( patientElement ).size();

                    XPath xpathExercise = DocumentHelper.createXPath( "patientJournalEntries/patientjournaling:patientEnteredExerciseJournalEntry" );
                    xpathExercise.setNamespaceURIs( namespaceUris );
                    responseLength += xpathExercise.selectNodes( patientElement ).size();
                    
                    XPath xpathDailyEvent = DocumentHelper.createXPath( "patientJournalEntries/patientjournaling:patientEnteredDailyEventJournalEntry" );
                    xpathDailyEvent.setNamespaceURIs( namespaceUris );
                    responseLength += xpathDailyEvent.selectNodes( patientElement ).size();
                   
                }
            }

        }
        catch ( DocumentException e )
        {
            throw new IllegalArgumentException( "Invalid document string passed in.", e );
        }

        return responseLength;
    }

}
