package gov.va.med.cds.audit;

import java.util.HashMap;
import java.util.Map;

public class ReadAuditFactory implements ReadAuditFactoryInteface
{
    private Map<String, ReadAuditFactoryInteface> filterToReadAuditFactoryMap = new HashMap<String, ReadAuditFactoryInteface>();
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.audit.ReadAuditFactoryInteface#createAuditLog(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, long, java.lang.String)
     */
    @Override
    public AbstractAuditLog createAuditLog( String clientId, String templateId, String filterRequest, String filterId, String requestId,
                    long startTime, String response )
    {
        ReadAuditFactoryInteface readAuditFactory = this.filterToReadAuditFactoryMap.get( filterId );
        
        if(readAuditFactory == null)
        {
            throw new IllegalArgumentException( String.format("Unexpected client and template combination: Client ID: %s, Template ID: %s", clientId, templateId) );
        }
        
        return readAuditFactory.createAuditLog( clientId, templateId, filterRequest, filterId, requestId, startTime, response );
    }
    
    public void setFilterToReadAuditFactoryMap( Map<String, ReadAuditFactoryInteface> filterToReadAuditFactoryMap )
    {
        this.filterToReadAuditFactoryMap = filterToReadAuditFactoryMap;
    }

}
