DECLARE
   random_num                   NUMBER          := 0;
   start_date                   NUMBER;
   literal_date                 VARCHAR2(50);
   onset_start_date             NUMBER;
   onset_literal_date           VARCHAR2(50);
   h_onset_start_date           NUMBER;
   h_onset_literal_date         VARCHAR2(50);
   end_date                     NUMBER;
   patient_vpid                 VARCHAR2(50);
   pract_vpid                   VARCHAR2(30);
   obs_char1_d                  VARCHAR2(100);
   obs_char1_v                  VARCHAR2(20);
   obs_char2_d                  VARCHAR2(100);
   obs_char2_v                  VARCHAR2(20);
   obs_char3_d                  VARCHAR2(100);
   obs_char3_v                  VARCHAR2(20);
   v_type                       varchar2(20);
   obs_int                      number;
   obs_code_v                   varchar2(20);
   obs_code_d                   VARCHAR2(100);
   obs_rn                       number;
   obs_dn                       number;
   obs_pv1                      varchar2(20);
   obs_pcd1                     varchar2(20);
   obs_pcv1                     varchar2(20);
   obs_pv2                      varchar2(20);
   obs_pcd2                     varchar2(20);
   obs_pcv2                     varchar2(20);
   body_site_d                  VARCHAR2 (100);
   body_site_v                  VARCHAR2 (20);
   pract_part_seq_id_val        NUMBER;
   vital_seq_id_val             NUMBER;
   OBS_METHOD_D                 VARCHAR2(100);
   OBS_METHOD_V                 VARCHAR2(20);
   starting_patient_vpid        NUMBER;
   status_code_d                VARCHAR2 (100);
   status_code_v                VARCHAR2 (20);
   service_delivery             VARCHAR2 (50);
   ref_date			DATE;
   num_vitals			NUMBER		:= 10;
   num_vpatients		NUMBER		:= 10;
   num_vdataEnterers		NUMBER		:= 1;
   num_nullifiers		NUMBER		:= 1;
   num_bodysite			NUMBER		:= 2;
   num_obsmethod		NUMBER		:= 2;
   num_patstate			NUMBER		:= 2;
   num_device			NUMBER		:= 1;
   starting_vvpid		NUMBER		:= 1;
BEGIN
   DBMS_RANDOM.SEED(42); -- add seeding for same random numbers.
   DBMS_OUTPUT.put_line (   'Vitals Start Time := '|| TO_CHAR (SYSDATE, 'MM/DD/YY hh:mi:ss'));
   
-- Set up a fixed reference date
   ref_date := to_date('01/01/2007','mm/dd/yyyy');

-- Set starting_patient_vpid
   IF starting_vvpid <= 0 
   THEN
       starting_patient_vpid :=1;
   ELSE
       starting_patient_vpid := starting_vvpid - 1;
   END IF;


-- Loop thru how many Vitals you want per patient
   FOR z IN 1 .. num_vitals
   LOOP
       -- Loop thru how many patients to assign Vitals to
       FOR jj in 1 .. num_vpatients
       LOOP

         -- Set Observered Characteristic information
         random_num := round(DBMS_RANDOM.VALUE (1, 4));
         CASE random_num
            WHEN '1' THEN
             v_type      := 'PHYSICAL';
             obs_char1_d := 'WEIGHT';
             obs_char1_v := 30000;
             obs_int     := null;
             obs_code_v  := null;
             obs_code_d  := null;
             obs_rn      := null;
             obs_dn      := null;
             obs_pv1     := round(dbms_random.value(85,350),1);
             obs_pcd1    := null;
             obs_pcv1    := null;
             obs_pv2     := null;
             obs_pcd2    := null;
             obs_pcv2    := null;
            WHEN '2' THEN
             v_type      := 'PHYSICAL';
             obs_char1_d := 'TEMPERATURE';
             obs_char1_v := 30001;
             obs_int     := null;
             obs_code_v  := null;
             obs_code_d  := null;
             obs_rn      := null;
             obs_dn      := null;
             obs_pv1     := round(dbms_random.value(95,107),1);
             obs_pcd1    := null;
             obs_pcv1    := null;
             obs_pv2     := null;
             obs_pcd2    := null;
             obs_pcv2    := null;
            WHEN '3' THEN
             v_type      := 'RATIO';
             obs_char1_d := 'BLOOD PRESSURE';
             obs_char1_v := 30002;
             obs_int     := null;
             obs_code_v  := null;
             obs_code_d  := null;
             obs_rn      := round(dbms_random.value(80,150),0);
             obs_dn      := round(dbms_random.value(55,110),0);
             obs_pv1     := null;
             obs_pcd1    := null;
             obs_pcv1    := null;
             obs_pv2     := null;
             obs_pcd2    := null;
             obs_pcv2    := null;
            ELSE
             v_type      := 'INTEGER';
             obs_char1_d := 'PULSE';
             obs_char1_v := 30003;
             obs_int     := round(dbms_random.value(40,160),0);
             obs_code_v  := null;
             obs_code_d  := null;
             obs_rn      := null;
             obs_dn      := null;
             obs_pv1     := null;
             obs_pcd1    := null;
             obs_pcv1    := null;
             obs_pv2     := null;
             obs_pcd2    := null;
             obs_pcv2    := null;
         END CASE;
         
         -- Set status_code_displayname
         random_num := round(DBMS_RANDOM.VALUE (1, 3));

         CASE random_num
            WHEN '1' THEN
               status_code_d := 'ACTIVE';
               status_code_v := '25';
            WHEN '2' THEN
               status_code_d := 'OPEN';
               status_code_v := '11';
            ELSE
               status_code_d := 'WAIT';
               status_code_v := '37';
         END CASE;

         service_delivery := 'test_vlid_' || ROUND (DBMS_RANDOM.VALUE (1, 2001));
         random_num := DBMS_RANDOM.VALUE (-20, -30);

         SELECT TO_CHAR (ref_date + random_num, 'fmMonth ddth, YYYY  fmhh:mi:ss AM' ),
                TO_NUMBER (TO_CHAR (ref_date + random_num, 'yyyymmddhh24miss'))
           INTO literal_date,
                start_date
           FROM DUAL;

-- set patient vpid
         IF (starting_patient_vpid + jj) > 000000
         THEN
             patient_vpid := 'test_vpid_' || (jj + starting_patient_vpid - 000000);
         ELSE
             patient_vpid := 'test_vpid_' || (jj + starting_patient_vpid);
         END IF; 
--dbms_output.put_line('what is patient_vpid?  ' || patient_vpid);         

         INSERT INTO vital
                     (     VITAL_ID
                         , VPID
                         , VLID
                         , VITAL_EXTVALUE
                         , VITAL_NAMESPACE
                         , VITAL_ROOTVALUE
                         , OBSERVATION_DT_LITERAL
                         , OBSERVATION_DT_VALUE
                         , OBSERVED_CHARACTER1_CODESET
                         , OBSERVED_CHARACTER1_VUID
                         , OBSERVED_CHARACTER1_DSPLYNM
                         , OBSERVED_CHARACTER2_CODESET
                         , OBSERVED_CHARACTER2_VUID
                         , OBSERVED_CHARACTER2_DSPLYNM
                         , OBSERVED_CHARACTER3_CODESET
                         , OBSERVED_CHARACTER3_VUID
                         , OBSERVED_CHARACTER3_DSPLYNM
                         , STATUS_CODE_CODESET 
                         , STATUS_CODE_VUID
                         , STATUS_CODE_DSPLYNM
                         , VITAL_SIGN_TYPE 
                         , VITAL_SIGN_CODED_CODESET 
                         , VITAL_SIGN_CODED_VUID
                         , VITAL_SIGN_CODED_DSPLYNM
                         , VITAL_SIGN_INTEGER_VALUE
                         , VITAL_SIGN_PHYS1_VALUE
                         , VITAL_SIGN_PHYS1_UOFM_CODESET
                         , VITAL_SIGN_PHYS1_UOFM_VUID
                         , VITAL_SIGN_PHYS1_UOFM_DSPLYNM
                         , VITAL_SIGN_PHYS2_VALUE 
                         , VITAL_SIGN_PHYS2_UOFM_CODESET 
                         , VITAL_SIGN_PHYS2_UOFM_VUID 
                         , VITAL_SIGN_PHYS2_UOFM_DSPLYNM 
                         , VITAL_SIGN_RATIO_NUMERATOR
                         , VITAL_SIGN_RATIO_DENOMINATOR
                         , last_updated_dttz
                     )
              VALUES (  vital_seq_id.NEXTVAL                                                    -- VITAL_ID
                      , patient_vpid                                                            -- VPID
                      , service_delivery                                                        -- VLID
                      , NULL                                                                    -- VITAL_EXTVALUE
                      , NULL                                                                    -- VITAL_ASSIGNAUTHNM
                      , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id.currval -- VITAL_ROOTVALUE
                      , literal_date                                                            -- OBSERVATION_DT_LITERAL
                      , start_date                                                              -- OBSERVATION_DT_VALUE
                      , null                                                                    -- OBSERVED_CHARACTER1_CODESET
                      , obs_char1_v                                                             -- OBSERVED_CHARACTER1_VUID
                      , obs_char1_d                                                             -- OBSERVED_CHARACTER1_DSPLYNM
                      , null                                                                    -- OBSERVED_CHARACTER2_CODESET
                      , obs_char2_v                                                             -- OBSERVED_CHARACTER2_VUID
                      , obs_char2_d                                                             -- OBSERVED_CHARACTER2_DSPLYNM
                      , null                                                                    -- OBSERVED_CHARACTER3_CODESET
                      , obs_char3_v                                                             -- OBSERVED_CHARACTER3_VUID
                      , obs_char3_d                                                             -- OBSERVED_CHARACTER3_DSPLYNM
                      , null                                                                    -- STATUS_CODE_CODESET
                      , status_code_v                                                           -- STATUS_CODE_VUID
                      , status_code_d                                                           -- STATUS_CODE_DSPLYNM
                      , v_type                                                                  -- VITAL_SIGN_TYPE 
                      , null                                                                    -- VITAL_SIGN_CODED_CODESET 
                      , obs_code_v                                                              -- VITAL_SIGN_CODED_VUID
                      , obs_code_d                                                              -- VITAL_SIGN_CODED_DSPLYNM
                      , obs_int                                                                 -- VITAL_SIGN_INTEGER_VALUE
                      , obs_pv1                                                                 -- VITAL_SIGN_PHYS1_VALUE
                      , null                                                                    -- VITAL_SIGN_PHYS1_UOFM_CODESET
                      , obs_pcv1                                                                -- VITAL_SIGN_PHYS1_UOFM_VUID
                      , obs_pcd1                                                                -- VITAL_SIGN_PHYS1_UOFM_DSPLYNM
                      , obs_pv2                                                                 -- VITAL_SIGN_PHYS2_VALUE 
                      , null                                                                    -- VITAL_SIGN_PHYS2_UOFM_CODESET 
                      , obs_pcv2                                                                -- VITAL_SIGN_PHYS2_UOFM_VUID 
                      , obs_pcd2                                                                -- VITAL_SIGN_PHYS2_UOFM_DSPLYNM 
                      , obs_rn                                                                  -- VITAL_SIGN_RATIO_NUMERATOR
                      , obs_dn                                                                  -- VITAL_SIGN_RATIO_DENOMINATOR
                      , SYSTIMESTAMP                                                            -- LAST_UPDATED_DTTZ
                     );

         -- Set variables to load AUTHOR 
         random_num := DBMS_RANDOM.VALUE (-17, -19);

         SELECT TO_CHAR (ref_date + random_num, 'fmMonth ddth, YYYY  fmhh:mi:ss AM' ),
                TO_NUMBER (TO_CHAR (ref_date + random_num, 'yyyymmddhh24miss'))
           INTO literal_date,
                start_date
           FROM DUAL;   

         random_num := random_num + .2;

         SELECT TO_NUMBER (TO_CHAR (ref_date + random_num, 'yyyymmddhh24miss'))
           INTO end_date
           FROM DUAL;
           
         -- set pract_vpid
         pract_vpid := 'test_vpid_' || round((DBMS_RANDOM.VALUE (1, 100)));
               

         SELECT pract_part_seq_id.NEXTVAL
           INTO pract_part_seq_id_val
           FROM DUAL;
         
         SELECT vital_seq_id.CURRVAL
           INTO vital_seq_id_val
           FROM DUAL;
                 
         insert_practpart.insert_message( pract_vpid, 'Author', literal_date, start_date, end_date,
                                          'VITAL', vital_seq_id_val, pract_part_seq_id_val );

         -- load 0 or 1 data enterer providers
         IF num_vdataEnterers > 0
         THEN
             random_num := DBMS_RANDOM.VALUE (-17, -19);

             SELECT TO_CHAR (ref_date + random_num, 'fmMonth ddth, YYYY  fmhh:mi:ss AM' ),
                    TO_NUMBER (TO_CHAR (ref_date + random_num, 'yyyymmddhh24miss'))
               INTO literal_date,
                    start_date
               FROM DUAL;

             random_num := random_num + .2;

             SELECT TO_NUMBER (TO_CHAR (ref_date + random_num, 'yyyymmddhh24miss'))
               INTO end_date
               FROM DUAL;
               
             -- set pract_vpid
             pract_vpid := 'test_vpid_' || round((DBMS_RANDOM.VALUE (1, 100)));

             SELECT pract_part_seq_id.NEXTVAL
               INTO pract_part_seq_id_val
               FROM DUAL;
             
             insert_practpart.insert_message( pract_vpid, 'DataEnterer', literal_date, start_date, end_date,
                                              'VITAL', vital_seq_id_val, pract_part_seq_id_val );
         END IF;
         
         -- load 0 or 1 nullifiers providers
         IF num_nullifiers > 0
         THEN
             random_num := DBMS_RANDOM.VALUE (-17, -19);

             SELECT TO_CHAR (ref_date + random_num, 'fmMonth ddth, YYYY  fmhh:mi:ss AM' ),
                    TO_NUMBER (TO_CHAR (ref_date + random_num, 'yyyymmddhh24miss'))
               INTO literal_date,
                    start_date
               FROM DUAL;

             random_num := random_num + .2;

             SELECT TO_NUMBER (TO_CHAR (ref_date + random_num, 'yyyymmddhh24miss'))
               INTO end_date
               FROM DUAL;
               
             -- set pract_vpid
             pract_vpid := 'test_vpid_' || round((DBMS_RANDOM.VALUE (1, 100)));

             SELECT pract_part_seq_id.NEXTVAL
               INTO pract_part_seq_id_val
               FROM DUAL;
                     
             insert_practpart.insert_message( pract_vpid, 'Nullifier', literal_date, start_date, end_date,
                                              'VITAL', vital_seq_id_val, pract_part_seq_id_val );
         END IF;
         
        
         -- load body_site
         IF num_bodysite > 0
         THEN
            FOR j IN 1 .. num_bodysite
            LOOP
               -- Set body_site
               random_num := ROUND(DBMS_RANDOM.VALUE (1, 15));

               CASE random_num
                  WHEN '1' THEN
                     body_site_d := 'DOPPLER';
                     body_site_v := '2222201';
                  WHEN '2' THEN
                     body_site_d := 'LEFT';
                     body_site_v := '2222202';
                  WHEN '3' THEN
                     body_site_d := 'RIGHT';
                     body_site_v := '2222203';
                  WHEN '4' THEN
                     body_site_d := 'ARM';
                     body_site_v := '2222204';
                  WHEN '5' THEN
                     body_site_d := 'LEG';
                     body_site_v := '2222205';
                  WHEN '6' THEN
                     body_site_d := 'BUTTOCKS';
                     body_site_v := '2222206';
                  WHEN '7' THEN
                     body_site_d := 'STANDING';
                     body_site_v := '2222207';
                  WHEN '8' THEN
                     body_site_d := 'SITTING';
                     body_site_v := '2222208';
                  WHEN '9' THEN
                     body_site_d := 'PRONE';
                     body_site_v := '2222209';
                  WHEN '10' THEN
                     body_site_d := 'KNEE';
                     body_site_v := '2222210';
                  WHEN '11' THEN
                     body_site_d := 'FOREARM';
                     body_site_v := '2222211';
                  WHEN '12' THEN
                     body_site_d := 'FOOT';
                     body_site_v := '2222212';
                  WHEN '13' THEN
                     body_site_d := 'HAND';
                     body_site_v := '2222213';
                  WHEN '14' THEN
                     body_site_d := 'KNEELING';
                     body_site_v := '2222214';
                  ELSE
                     body_site_d := 'STOMACH';
                     body_site_v := '2222215';
               END CASE;

               
               -- insert body_site record
               INSERT INTO body_site
                              (   BODY_SITE_ID
                                , VITAL_ID
                                , BODY_SITE_VALUE_CODESET 
                                , BODY_SITE_VALUE_VUID
                                , BODY_SITE_VALUE_DSPLYNM
                                , LAST_UPDATED_DTTZ   
                              )
               VALUES (
                         body_site_seq_id.nextval                                               -- BODY_SITE_ID 
                       , vital_seq_id_val                                                       -- VITAL_ID
                       , null                                                                   -- BODY_SITE_VALUE_CODESET
                       , body_site_v                                                            -- BODY_SITE_VALUE_VUID
                       , body_site_d                                                            -- BODY_SITE_VALUE_DSPLYNM
                       , SYSTIMESTAMP                                                           -- LAST_UPDATED_DTTZ
                       );
               

            END LOOP;
         END IF;

        
         -- load observation_method
         IF num_obsmethod > 0
         THEN
            FOR j IN 1 .. num_obsmethod
            LOOP
               -- Set observation_method
               random_num := ROUND(DBMS_RANDOM.VALUE (1, 6));

               CASE random_num
                  WHEN '1' THEN
                     OBS_METHOD_D := 'EYE';
                     OBS_METHOD_V := '3222201';
                  WHEN '2' THEN
                     OBS_METHOD_D := 'TOUCH';
                     OBS_METHOD_V := '3222202';
                  WHEN '3' THEN
                     OBS_METHOD_D := 'THERMOMETER';
                     OBS_METHOD_V := '3222203';
                  WHEN '4' THEN
                     OBS_METHOD_D := 'MOUTH';
                     OBS_METHOD_V := '3222204';
                  WHEN '5' THEN
                     OBS_METHOD_D := 'OTHER';
                     OBS_METHOD_V := '3222205';
                  ELSE
                     OBS_METHOD_D := 'HAND';
                     OBS_METHOD_V := '3222215';
               END CASE;

               
               -- insert observation_method record
               INSERT INTO observation_method
                              (   OBSERVATION_METHOD_ID 
                                , VITAL_ID
                                , OBSERVATION_METHOD_CODESET
                                , OBSERVATION_METHOD_VUID
                                , OBSERVATION_METHOD_DSPLYNM
                                , LAST_UPDATED_DTTZ   
                              )
               VALUES (
                         observation_method_seq_id.nextval                                      -- OBSERVATION_METHOD_ID 
                       , vital_seq_id_val                                                       -- VITAL_ID
                       , null                                                                   -- OBSERVATION_METHOD_VALUE_CODESET
                       , OBS_METHOD_V                                                           -- OBSERVATION_METHOD_VALUE_VUID
                       , OBS_METHOD_D                                                           -- OBSERVATION_METHOD_VALUE_DSPLYNM
                       , SYSTIMESTAMP                                                           -- LAST_UPDATED_DTTZ
                       );
               

            END LOOP;
         END IF;

         -- load PATIENT_STATE
         IF num_patstate > 0
         THEN
            FOR j IN 1 .. num_patstate
            LOOP

                insert into PATIENT_STATE (  PATIENT_STATE_ID
                                           , VITAL_ID
                                           , PATIENT_STATE_CODESET
                                           , PATIENT_STATE_VUID
                                           , PATIENT_STATE_DSPLYNM
                                           , OXY_RATE_CONC_GIVEN
                                           , CONC_LOW_VALUE
                                           , CONC_LOW_VALUE_UOFM_CODESET
                                           , CONC_LOW_VALUE_UOFM_VUID
                                           , CONC_LOW_VALUE_UOFM_DSPLYNM
                                           , CONC_HIGH_VALUE
                                           , CONC_HIGH_VALUE_UOFM_CODESET
                                           , CONC_HIGH_VALUE_UOFM_VUID
                                           , CONC_HIGH_VAL_UOFM_DSPLYNM
                                           , RATE_LOW_VALUE
                                           , RATE_LOW_VALUE_UOFM_CODESET
                                           , RATE_LOW_VALUE_UOFM_VUID
                                           , RATE_LOW_VALUE_UOFM_DSPLYNM
                                           , RATE_HIGH_VALUE
                                           , RATE_HIGH_VALUE_UOFM_CODESET
                                           , RATE_HIGH_VALUE_UOFM_VUID
                                           , RATE_HIGH_VALue_UOFM_DSPLYNM
                                           , RATE_PERIOD_VALUE
                                           , RATE_PERIOD_VALUE_UOFM
                                           , LAST_UPDATED_DTTZ
                                          )
                values (  patient_state_seq_id.nextval                              -- supp02_admin_id 
                        , vital_seq_id_val                                          -- vitals_id
                        , NULL                                                      -- PATIENT_STATE_CODESET
                        , '80000001'                                                -- PATIENT_STATE_VUID
                        , 'ALIVE'                                                   -- PATIENT_STATE_DSPLYNM
                        , dbms_random.string('x',trunc(dbms_random.value(1,100)))   -- OXY_RATE_CONC_GIVEN 
                        , round(dbms_random.value(1,50))                            -- CONC_LOW_VALUE 
                        , NULL                                                      -- CONC_LOW_VALUE_UOFM_CODESET
                        , 5                                                         -- CONC_LOW_VALUE_UOFM_VUID 
                        , 'PERCENT'                                                 -- CONC_LOW_VALUE_UOFM_DSPLYNM
                        , round(dbms_random.value(51,100))                          -- CONC_HIGH_VALUE 
                        , NULL                                                      -- CONC_LOW_VALUE_UOFM_CODESET
                        , 5                                                         -- CONC_HIGH_VALUE_UOFM_CODESET 
                        , 'PERCENT'                                                 -- CONC_HIGH_VAL_UOFM_DSPLYNM
                        , round(dbms_random.value(1,50))                            -- RATE_LOW_VALUE 
                        , NULL                                                      -- RATE_LOW_VALUE_UOFM_CODESET
                        , 8                                                         -- RATE_LOW_VALUE_UOFM_VUID 
                        , 'mL'                                                      -- RATE_LOW_VALUE_UOFM_DSPLYNM
                        , round(dbms_random.value(51,100))                          -- RATE_HIGH_VALUE 
                        , NULL                                                      -- RATE_HIGH_VALUE_UOFM_CODESET
                        , 8                                                         -- RATE_HIGH_VALUE_UOFM_VUID 
                        , 'mL'                                                      -- RATE_HIGH_VALue_UOFM_DSPLYNM
                        , round(dbms_random.value(1,100))                           -- RATE_PERIOD_VALUE
                        , 'h'                                                       -- RATE_PERIOD_VALUE_UOFM
                        , SYSTIMESTAMP                                              -- LAST_UPDATED_DTTZ
                       );
            END LOOP;
         END IF;

         -- load Device
         IF num_device > 0
         THEN
            FOR j IN 1 .. num_device
            LOOP

                insert into DEVICE (  DEVICE_ID
                                    , DEVICE_TYPE_DESCRIPTION
                                    , DEVICE_EXTVALUE
                                    , DEVICE_NAMESPACE
                                    , DEVICE_ROOTVALUE
                                    , DEVICE_NAME_FORMATTED
                                    , SOFTWARE_CODESET
                                    , SOFTWARE_VUID
                                    , SOFTWARE_DSPLYNM
                                    , LAST_UPDATED_DTTZ
                                   )
                values (  device_seq_id.nextval                                     -- DEVICE_ID 
                        , dbms_random.string('x',trunc(dbms_random.value(1,100)))   -- DEVICE_TYPE_DESCRIPTION 
                        , NULL                                                      -- DEVICE_EXTVALUE 
                        , NULL                                                      -- DEVICE_NAMESPACE
                        , dbms_random.string('x',trunc(dbms_random.value(1,100)))   -- DEVICE_ROOTVALUE 
                        , 'PERCENT'                                                 -- DEVICE_NAME_FORMATTED
                        , NULL                                                      -- SOFTWARE_CODESET 
                        , '999900'                                                  -- SOFTWARE_VUID
                        , 'BCMA'                                                    -- SOFTWARE_DSPLYNM 
                        , SYSTIMESTAMP                                              -- LAST_UPDATED_DTTZ
                       );

                insert into VITAL_DEVICE (  VITAL_ID
                                          , DEVICE_ID
                                         )
                values (  vital_seq_id_val                                          -- VITAL_ID
                        , device_seq_id.currval                                     -- DEVICE_ID
                       );
            END LOOP;
         END IF;

         COMMIT;
       END LOOP;
   END LOOP;

   DBMS_OUTPUT.put_line (' ');
   DBMS_OUTPUT.put_line (   'Vitals End Time := ' || TO_CHAR (SYSDATE, 'MM/DD/YY hh:mi:ss') );
END;
/