

package gov.va.med.cds.logger;


import gov.va.med.cds.log4j.ApplicationLogEvent;
import gov.va.med.cds.log4j.persistence.LoggerPersistenceManagerInterface;
import gov.va.med.cds.logger.config.LoggerBeanConstants;

import org.apache.log4j.spi.LoggingEvent;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.ObjectMessage;


/**
 * @author vhaislegberb
 * 
 */
public class LoggerMessageDrivenBean
    extends
        org.springframework.ejb.support.AbstractJmsMessageDrivenBean
{

    private static final long serialVersionUID = 6176009691768180038L;

    private LoggerPersistenceManagerInterface loggerPersistenceManager;
   
    /*
     * (non-Javadoc)
     * 
     * @see org.springframework.ejb.support.AbstractMessageDrivenBean#onEjbCreate()
     */
    protected void onEjbCreate( )
    {
        // TODO: I'm not sure if this is necessary or not. Maybe it's being autowired by spring??
        this.loggerPersistenceManager = ( LoggerPersistenceManagerInterface )getBeanFactory().getBean( "loggerPersistenceManager" );
    }


    public void setMessageDrivenContext( MessageDrivenContext messageDrivenContext )
    {
        super.setMessageDrivenContext( messageDrivenContext );
        setBeanFactoryLocator( ContextSingletonBeanFactoryLocator.getInstance() );
        setBeanFactoryLocatorKey( LoggerBeanConstants.PRIMARY_CONTEXT_ID );
    }


    public void onMessage( Message message )
    {
        ApplicationLogEvent appLogEvent = null;
        try
        {
            ObjectMessage objectMessage = ( ( ObjectMessage )message );
            LoggingEvent logEvent = ( LoggingEvent )objectMessage.getObject();

            appLogEvent = new ApplicationLogEvent( logEvent );
            loggerPersistenceManager.persistApplicationLogEvent( appLogEvent );
        }
        catch ( Exception e )
        {
            // make sure that any logs comming from the logging sub-system only go
            // to the file or stdout.
            logger.error( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, appLogEvent.getAppName(), "Error proccessing JMS Appender log event. " ), e );
         }
    }


    protected void onEjbRemove( )
    {
        super.onEjbRemove();
    }
}
