

package gov.va.med.cds.client.functional.vhim400.exceptionlogger;


import gov.va.med.cds.client.functional.AbstractFunctionalTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.sql.ExecuteException;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.xml.Assert;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.testharness.xml.XmlValidationException;
import gov.va.med.cds.util.StreamUtil;

import java.io.IOException;

import javax.xml.transform.TransformerException;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/client/functional/vhim400/soapClientTestContext.xml",
                "classpath:gov/va/med/cds/config/nonWeblogicHdr2DataSourceContext.xml" } )
public class AllergyFullIntoleranceExceptionLoggerTest
    extends
        AbstractFunctionalTest
{
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private String expectedCreateNullResult;
    private String deleteRequest;
    private String uniqueRequestId = "E851B78E-0807-1A28-E86C-E1B362624068";
    private String exceptionMessage = "WRITE_REQUEST_INPUT_PARAMETERS_NULL";

    /*
     * Injected by Spring
     */
    @Autowired
    private JdbcTemplate hdrJdbcTemplate;


    @Test
    @Suite( groups = "smoketest" )
    public void testFullIntoleranceConditionCreateWithNullRequest( )
        throws IOException,
            XmlCompareException,
            TransformerException,
            ExecuteException,
            XmlValidationException,
            InterruptedException
    {
        Resource resource = resourceLoader
                        .getResource( "classpath:gov/va/med/cds/client/functional/vhim400/exceptionlogger/Null_WriteRequest_ExepectedResults.xml" );
        expectedCreateNullResult = StreamUtil.resourceToString( resource );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/client/functional/vhim400/exceptionlogger/Delete_Data.xml" );
        deleteRequest = StreamUtil.resourceToString( resource );

        doDelete();

        String createResult = getClinicalDataService().createClinicalData( null, TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID,
                        uniqueRequestId );

        Assert.assertXmlEquals( createResult, expectedCreateNullResult );

        Thread.sleep( 3000 );

        StringBuilder sqlStmt = new StringBuilder();
        sqlStmt.append( "SELECT COUNT(1) FROM CDS_APPLICATION_LOG WHERE REQUEST_ID = '" );
        sqlStmt.append( uniqueRequestId );
        sqlStmt.append( "' AND MESSAGE LIKE '%" );
        sqlStmt.append( exceptionMessage );
        sqlStmt.append( "%'" );

        int retVal = hdrJdbcTemplate.queryForInt( sqlStmt.toString() );

        Assert.assertTrue( retVal == 1 );

        doDelete();
    }


    private String doDelete( )
    {
        clearCdsApplicationLogTable();

        return getClinicalDataService()
                        .deleteClinicalData( deleteRequest, TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID, uniqueRequestId );

    }


    private void clearCdsApplicationLogTable( )
    {
        this.hdrJdbcTemplate.update( "DELETE FROM CDS_APPLICATION_LOG" );
    }
}
