

package gov.va.med.cds.client.functional.vhim400;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import gov.va.med.cds.client.functional.DataGenerator;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.xml.XmlValidator;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.SessionCallback;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:gov/va/med/cds/client/functional/vhim400/asyncClientTestContext.xml",
                "classpath:gov/va/med/cds/client/functional/testDataGeneratorContext.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class AsyncCdsClientTest
    extends
        AbstractBaseTest
{

    private static final String TEMPLATE_ID = "TEMPLATE_ID";
    private static final String REQUEST_ID = "REQUEST_ID";
    private static final long RECEIVE_TIMEOUT = 20000L;

    @Autowired
    private JmsTemplate questionnaireResultQueueJmsTemplate;

    @Autowired
    private Destination questionnaireResultsQueue;

    @Autowired
    private Destination cdsDefaultResponseQueueDestination;

    @Autowired
    private DataGenerator dataGenerator = new DataGenerator();


//    @Test
//    @Suite( groups = "checkintest" )
//    public void testCanCreateBasicDBQCreateTemplateValid( )
//        throws Exception
//    {
//        String dbqCreateTemplate = this.dataGenerator.createQuestionnaireResult( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, "JUnit Test - AsyncCdsClientTest" );
//        
//        XmlValidator.validateXml( dbqCreateTemplate, TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID );
//    }
    public void testBasicDbqCreate1AsyncValid( )
        throws Exception
    {

        // create a DBQ create template message
        final String requestId = TemplateIdHelper.getUniqueIdentifier();
        final String dbqCreateTemplate = this.dataGenerator.createQuestionnaireResult( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, "JUnit Test - AsyncCdsClientTest" );

        // send the DBQ create XML to the queue.
        Message ack = this.questionnaireResultQueueJmsTemplate.execute( new SessionCallback<Message>()
        {
            @Override
            public Message doInJms( Session session )
                throws JMSException
            {
                // create a temporary queue for the response to be sent to.
                TemporaryQueue replyToQueue = session.createTemporaryQueue();
                
                // create a text message and set the required message properties.
                TextMessage message = session.createTextMessage( dbqCreateTemplate );
                message.setStringProperty( TEMPLATE_ID, TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID );
                message.setStringProperty( REQUEST_ID, requestId );
                message.setJMSReplyTo( replyToQueue );

                MessageProducer producer = session.createProducer( questionnaireResultsQueue );
                producer.send( message );
                MessageConsumer consumer = session.createConsumer( replyToQueue, String.format("%s = '%s'", REQUEST_ID, requestId) );
                Message ack = consumer.receive(RECEIVE_TIMEOUT); 
                consumer.close();
                producer.close();
                return ack;
                
            }
        }, true );

        if ( ack == null )
        {
            fail( String.format( "Receive message timed out. Request ID: %s", requestId ) );
        }

        if ( ack instanceof TextMessage )
        {
            // text the contents of the response to ensure that they are what is expected.
            Document ackDocument = DocumentHelper.parseText( ( ( TextMessage )ack ).getText() );

            // validate that the data in the response is what was expected by the client.
            assertEquals( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, ackDocument.selectSingleNode( "//templateId" ).getText() );
            assertEquals( requestId, ackDocument.selectSingleNode( "//requestId" ).getText() );
            assertTrue( ackDocument.selectNodes( "//identifiers/identifier" ).size() == 1 );
        }
        else
        {
            fail( String.format( "Excpected JMS TextMessage acknowledgement. Received acknowledgement of type %s.", ack.getClass().getName() ) );
        }

    }
    
    
    @Test
    @Suite( groups = "checkintest" )
    public void testBasicDbqCreate1AsyncValidDefaultDestination( )
        throws Exception
    {

        // create a DBQ create template message
        final String requestId = TemplateIdHelper.getUniqueIdentifier();
        final String dbqCreateTemplate = this.dataGenerator.createQuestionnaireResult( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, "JUnit Test - AsyncCdsClientTest" );

        // send the DBQ create XML to the queue.
        Message ack = this.questionnaireResultQueueJmsTemplate.execute( new SessionCallback<Message>()
        {
            @Override
            public Message doInJms( Session session )
                throws JMSException
            {
                // create a text message and set the required message properties.
                TextMessage message = session.createTextMessage( dbqCreateTemplate );
                message.setStringProperty( TEMPLATE_ID, TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID );
                message.setStringProperty( REQUEST_ID, requestId );

                MessageProducer producer = session.createProducer( questionnaireResultsQueue );
                producer.send( message );
                MessageConsumer consumer = session.createConsumer( cdsDefaultResponseQueueDestination, String.format("%s = '%s'", REQUEST_ID, requestId) );
                Message ack = consumer.receive(RECEIVE_TIMEOUT); 
                consumer.close();
                producer.close();
                return ack;
                
            }
        }, true );

        if ( ack == null )
        {
            fail( String.format( "Receive message timed out. Request ID: %s", requestId ) );
        }

        if ( ack instanceof TextMessage )
        {
            // text the contents of the response to ensure that they are what is expected.
            Document ackDocument = DocumentHelper.parseText( ( ( TextMessage )ack ).getText() );

            // validate that the data in the response is what was expected by the client.
            assertEquals( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, ackDocument.selectSingleNode( "//templateId" ).getText() );
            assertEquals( requestId, ackDocument.selectSingleNode( "//requestId" ).getText() );
            assertTrue( ackDocument.selectNodes( "//identifiers/identifier" ).size() == 1 );
        }
        else
        {
            fail( String.format( "Excpected JMS TextMessage acknowledgement. Received acknowledgement of type %s.", ack.getClass().getName() ) );
        }

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testBasicDbqCreateAsyncInvalidMessageFormat( )
        throws Exception
    {

        // create a DBQ create template message
        final String requestId = TemplateIdHelper.getUniqueIdentifier();
        final String dbqCreateTemplate = this.dataGenerator.createQuestionnaireResult( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, "JUnit Test - AsyncCdsClientTest" );

        // remove something from the message that is required.
        Document dbqCreateDoc = DocumentHelper.parseText( dbqCreateTemplate );
        dbqCreateDoc.selectSingleNode( "//detailXML" ).detach();
        final String dbqCreateTemplateInvalid = dbqCreateDoc.asXML();

        assertTrue( !dbqCreateTemplate.equals( dbqCreateTemplateInvalid ) );

        // send the DBQ create XML to the queue.
        Message ack = this.questionnaireResultQueueJmsTemplate.execute( new SessionCallback<Message>()
        {
            @Override
            public Message doInJms( Session session )
                throws JMSException
            {
                // create a temporary queue for the response to be sent to.
                TemporaryQueue replyToQueue = session.createTemporaryQueue();
                
                // create a text message and set the required message properties.
                TextMessage message = session.createTextMessage( dbqCreateTemplateInvalid );
                message.setStringProperty( TEMPLATE_ID, TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID );
                message.setStringProperty( REQUEST_ID, requestId );
                message.setJMSReplyTo( replyToQueue );

                MessageProducer producer = session.createProducer( questionnaireResultsQueue );
                producer.send( message );
                MessageConsumer consumer = session.createConsumer( replyToQueue );
                Message ack = consumer.receive(RECEIVE_TIMEOUT); 
                consumer.close();
                producer.close();
                return ack;
                
            }
        }, true );

        if ( ack == null )
        {
            fail( String.format( "Receive message timed out. Request ID: %s", requestId ) );
        }

        if ( ack instanceof TextMessage )
        {
            // text the contents of the response to ensure that they are what is expected.
            Document ackDocument = DocumentHelper.parseText( ( ( TextMessage )ack ).getText() );

            // validate that the data in the response is what was expected by the client.
            assertEquals( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, ackDocument.selectSingleNode( "//templateId" ).getText() );
            assertEquals( requestId, ackDocument.selectSingleNode( "//requestId" ).getText() );
            assertTrue( ackDocument.selectNodes( "//identifiers/identifier" ).size() == 0 );
            assertTrue( ackDocument.selectNodes( "//errorSection/fatalErrors/fatalError" ).size() == 1 );
        }
        else
        {
            fail( String.format( "Excpected JMS TextMessage acknowledgement. Received acknowledgement of type %s.", ack.getClass().getName() ) );
        }

    }

}