

package gov.va.med.cds.client.functional.vhim400;


import static gov.va.med.cds.testharness.xml.Assert.assertXmlSimilar;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.client.functional.AbstractDataGeneratorValidatorTest;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponse400;
import gov.va.med.cds.clinicaldata.vhim400.ConfigurableClinicalDataResponse;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.XmlValidator;
import gov.va.med.cds.util.StreamUtil;
import gov.va.med.repositories.Pathways;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.dom4j.DocumentHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/client/functional/testRpcDataGeneratorContext.xml",
                "classpath:gov/va/med/cds/config/nonWeblogicHdr2DataSourceContext.xml" } )
public abstract class AbstractClientRpcTest
    extends
        AbstractDataGeneratorValidatorTest
{
    @Autowired
    protected JdbcTemplate hdrJdbcTemplate;

    private Pathways rpcClinicalDataService;

    @Autowired
    protected ClinicalDataBuilder clinicalDataBuilder;

    @Autowired
    protected ConfigurableClinicalDataResponse configurableExamsClinicalDataResponse;

    @Autowired
    protected ConfigurableClinicalDataResponse configurableAppointmentsClinicalDataResponse;

    @Autowired
    protected ClinicalDataResponse400 clinicalDataResponse400;

    private static final String PATHWAYS_DEFAULT_ERROR_RESPONSE_URI = "pathwaysdata:PathwaysData xmlns:pathwaysdata";
    private static final String EXAM_URI = "examsdata:RequestsAndExamsData xmlns:examsdata";

    
    @Test
    @BeforeTestsOnce
    @Suite( groups = "appservertest" )
    public void testIsAlive( )
    {

        assertTrue( rpcClinicalDataService.isAlive() );
    }

    @Resource
    public void setRpcClinicalDataService( Pathways rpcClinicalDataService )
    {
        this.rpcClinicalDataService = rpcClinicalDataService;
        Assert.assertNotNull(this.rpcClinicalDataService);
    }


    @Test
    @Suite( groups = "appservertest" )
    public void testExamRequests( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String OPTION_PARAM_EXAM_REQUEST_STATUS = "requestStatus";

        String[] vistaPatient580 = { "USVHA", "580", "78" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        String expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult1.xml" ) ) );
        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

        //Testing no dates and no status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult2.xml" ) ) );
        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

        //Testing dates and status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        startDate = "1995-01-01";
        endDate = "1995-12-31";
        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();
        optionalParamsMap.put( OPTION_PARAM_EXAM_REQUEST_STATUS, "C" );

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult3.xml" ) ) );
        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

        //Testing no dates and status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();
        optionalParamsMap.put( OPTION_PARAM_EXAM_REQUEST_STATUS, "C" );

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult4.xml" ) ) );
        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

    }


    @Test
    @Suite( groups = "appservertest" )
    public void testExams( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String OPTION_PARAM_EXAM_STATUS = "status";

        String[] vistaPatient580 = { "USVHA", "580", "78" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        String expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testExams/expectedReadResult1.xml" ) ) );

        assertXmlSimilar( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ),
                        detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) );
        //Testing no dates and no status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam-Standardized" );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testExams/expectedReadResult2.xml" ) ) );

        assertXmlSimilar( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ),
                        detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) );
        //Testing dates and status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        startDate = "1995-12-01";
        endDate = "1995-12-31";
        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();
        optionalParamsMap.put( OPTION_PARAM_EXAM_STATUS, "C" );

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testExams/expectedReadResult3.xml" ) ) );

        assertXmlSimilar( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ),
                        detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) );
        //Testing no dates and status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();
        optionalParamsMap.put( OPTION_PARAM_EXAM_STATUS, "X" );

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testExams/expectedReadResult4.xml" ) ) );
        assertXmlSimilar( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ),
                        detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) );
    }


    @SuppressWarnings( "unused" )
    @Test
    @Suite( groups = "appservertest" )
    public void testExamsRead2( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String OPTION_PARAM_EXAM_STATUS = "status";

        String[] vistaPatient580 = { "USVHA", "580", "78" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        String expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testExams/expectedReadResult5.xml" ) ) );
        assertXmlSimilar( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ),
                        detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) );

    }


    @SuppressWarnings( "unused" )
    @Test
    @Suite( groups = "brokentest" )
    public void testExamsWithNullParams( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String OPTION_PARAM_EXAM_STATUS = "status";

        String[] vistaPatient580 = { "USVHA", "580", "78" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( null, readFilter, filterId, requestId );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( EXAM_URI ) );

        readResult = rpcClinicalDataService.readData( "XXX", readFilter, filterId, requestId );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );

        readResult = rpcClinicalDataService.readData( "XXX", readFilter, filterId, null );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, null );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( EXAM_URI ) );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, "" );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( EXAM_URI ) );

        readResult = rpcClinicalDataService.readData( null, null, null, requestId );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );

        readResult = rpcClinicalDataService.readData( null, null, null, null );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );

        readResult = rpcClinicalDataService.readData( "", "", "", "" );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );

        readResult = rpcClinicalDataService.readData( null, readFilter, filterId, "" );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( EXAM_URI ) );

        readResult = rpcClinicalDataService.readData( null, readFilter, null, "" );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( EXAM_URI ) );

        readResult = rpcClinicalDataService.readData( null, null, filterId, "" );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( EXAM_URI ) );

        readResult = rpcClinicalDataService.readData( readTemplateId, null, null, "" );
        assertTrue( readResult.contains( "<errorSection>" ) );
        assertTrue( readResult.contains( EXAM_URI ) );

    }


    @Test
    @Suite( groups = "appservertest" )
    public void testExamsAndExamRequests( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String OPTION_PARAM_EXAM_STATUS = "status";
        String OPTION_PARAM_EXAM_REQUEST_STATUS = "requestStatus";

        String[] vistaPatient580 = { "USVHA", "580", "78" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExams.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExams.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExamRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );
        entryPointFilterList.add( entryPointFilterMapExams );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        String expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult5.xml" ) ) );

        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

        //Testing no dates and no status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );
        entryPointFilterList.add( entryPointFilterMapExams );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult6.xml" ) ) );

        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

        //Testing dates and status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        startDate = "1995-12-01";
        endDate = "1995-12-31";
        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExams.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExams.put( FilterBuilder.END_DATE_KEY, endDate );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );
        entryPointFilterList.add( entryPointFilterMapExams );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();
        optionalParamsMap.put( OPTION_PARAM_EXAM_STATUS, "C" );
        optionalParamsMap.put( OPTION_PARAM_EXAM_REQUEST_STATUS, "C" );

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult7.xml" ) ) );

        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

        //Testing no dates and status
        entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();
        optionalParamsMap.put( OPTION_PARAM_EXAM_STATUS, "X" );
        optionalParamsMap.put( OPTION_PARAM_EXAM_REQUEST_STATUS, "X" );

        readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult8.xml" ) ) );

        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );
    }


    @SuppressWarnings( "unused" )
    @Test
    @Suite( groups = "appservertest" )
    public void testExamsAndExamRequestsRead2( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String OPTION_PARAM_EXAM_STATUS = "status";
        String OPTION_PARAM_EXAM_REQUEST_STATUS = "requestStatus";

        String[] vistaPatient580 = { "USVHA", "580", "78" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExams.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExams.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExamRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );
        entryPointFilterList.add( entryPointFilterMapExams );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Examsdata" );

        String expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testRequestsNExams/expectedReadResult9.xml" ) ) );
        assertXmlSimilar( detachNodesFromExamsReadResult( detachNodesFromReadResult( readResult, configurableExamsClinicalDataResponse ) ),
                        detachNodesFromExamsReadResult( detachNodesFromReadResult( expectedReadResult, configurableExamsClinicalDataResponse ) ) );

    }


    @Test
    @Suite( groups = "appservertest" )
    public void testAppointments( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        String[] vistaPatient580 = { "USVHA", "580", "100600" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );
        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Appointmentsdata" );
        String expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testAppointment/expectedReadResult1.xml" ) ) );
        assertXmlSimilar( detachNodesFromReadResult( readResult, configurableAppointmentsClinicalDataResponse ),
                        detachNodesFromReadResult( expectedReadResult, configurableAppointmentsClinicalDataResponse ) );

        //testing with dates
        entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime, entryPointFilterList,
                        resolvedPatientList, null );
        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( !readResult.contains( "<errorSection>" ) );

        XmlValidator.validateXml( readResult, readTemplateId, "Appointmentsdata" );
        expectedReadResult = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/resources/AbstractClientTest/testAppointment/expectedReadResult2.xml" ) ) );
        assertXmlSimilar( detachNodesFromReadResult( readResult, configurableAppointmentsClinicalDataResponse ),
                        detachNodesFromReadResult( expectedReadResult, configurableAppointmentsClinicalDataResponse ) );
    }


    @Test
    @Suite( groups = "brokentest" )
    public void testAppointmentsWithNullParams( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        String[] vistaPatient580 = { "USVHA", "580", "100600" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );

        String readResult = rpcClinicalDataService.readData( null, readFilter, filterId, requestId );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readResult = rpcClinicalDataService.readData( "XXX", readFilter, filterId, requestId );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readResult = rpcClinicalDataService.readData( "XXX", readFilter, filterId, null );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, null );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, "" );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readResult = rpcClinicalDataService.readData( null, null, null, requestId );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readResult = rpcClinicalDataService.readData( null, null, null, null );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readResult = rpcClinicalDataService.readData( "", "", "", "" );
        assertTrue( readResult.contains( "<errorSection>" ) );

        readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, "", clientRequestInitiationTime, entryPointFilterList,
                        resolvedPatientList, null );
        readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        assertTrue( readResult.contains( "<errorSection>" ) );
    }


    @SuppressWarnings( "unused" )
    @Test
    @Suite( groups = { "smoketest" } )
    public void testExamRequestsReadAuditLog( )
        throws Exception
    {
        String XPATH_EXAM_REQUESTS = "//patient/examRequests/examRequest";

        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "eBenefits 1.0";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";

        String templateId = "";
        String filterRequest = "";

        String[] vistaPatient580 = { "USVHA", "580", "78" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        // clean up PATHWAYS_AUDIT_LOG table
        clearRpcAuditLogTable();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );

        Thread.sleep( 3000 );

        verifyRpcAuditLogData( readTemplateId, clientName, DocumentHelper.parseText( readResult ).selectNodes( XPATH_EXAM_REQUESTS ).size() );
    }


    @Test
    @Suite( groups = "smoketest" )
    public void testExamsAuditLog( )
        throws Exception
    {
        String XPATH_EXAMS = "//patient/exams/exam";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID;
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";

        String[] vistaPatient580 = { "USVHA", "580", "45" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //Testing dates and no status
        Map<String, String> entryPointFilterMapExamRequests = new HashMap<String, String>();
        entryPointFilterMapExamRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExamRequests.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        entryPointFilterMapExamRequests.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMapExamRequests.put( FilterBuilder.END_DATE_KEY, endDate );

        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMapExamRequests );

        Map<String, String> optionalParamsMap = new LinkedHashMap<String, String>();
        optionalParamsMap.clear();

        // clean up PATHWAYS_AUDIT_LOG table
        clearRpcAuditLogTable();

        String readFilter = dataGenerator.buildRequestsNExamsFilterElementWithResolvedIdentfiers( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, startDate, endDate, optionalParamsMap );

        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );

        Thread.sleep( 3000 );
        verifyRpcAuditLogData( readTemplateId, clientName, DocumentHelper.parseText( readResult ).selectNodes( XPATH_EXAMS ).size() );
    }


    @Test
    @Suite( groups = { "smoketest" } )
    public void testAppointmentsAuditLog( )
        throws Exception
    {
        String XPATH_APPOINTMENTS = "//patients/patient/appointments/appointment";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String filterId = TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER;
        String clientName = "VRM 1.0";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String readTemplateId = TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID;

        String startDate = "2002-01-01";
        String endDate = "2011-06-01";

        String[] vistaPatient580 = { "USVHA", "580", "100600" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatientList = getResolvedPatients( patientIdentifiers );

        //testing with dates
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, startDate );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, endDate );
        List<Map<String, String>> entryPointFilterList = new ArrayList<Map<String, String>>();
        entryPointFilterList.add( entryPointFilterMap );

        // clean up PATHWAYS_AUDIT_LOG table
        clearRpcAuditLogTable();

        String readFilter = dataGenerator.createAppointmentSinglePatientDataFilter( filterId, clientName, clientRequestInitiationTime,
                        entryPointFilterList, resolvedPatientList, null );
        String readResult = rpcClinicalDataService.readData( readTemplateId, readFilter, filterId, requestId );
        Thread.sleep( 3000 );

        verifyRpcAuditLogData( readTemplateId, clientName, DocumentHelper.parseText( readResult ).selectNodes( XPATH_APPOINTMENTS ).size() );
    }


    protected void clearRpcAuditLogTable( )
    {
        this.hdrJdbcTemplate.update( "DELETE FROM PATHWAYS_AUDIT_LOG" );
    }


    protected void verifyRpcAuditLogData( String readTemplateId, String clientName, int responseLength )
    {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append( "SELECT COUNT(*) FROM PATHWAYS_AUDIT_LOG al, TEMPLATE_NAME tn WHERE al.TEMPLATE_NAME_ID = tn.TEMPLATE_NAME_ID AND tn.TEMPLATE_NAME_IDENTIFIER = '" );
        sqlBuilder.append( readTemplateId );
        sqlBuilder.append( "'" );
        sqlBuilder.append( " AND RESPONSE_LENGTH = " );
        sqlBuilder.append( responseLength );
        sqlBuilder.append( " AND CLIENT_IDENTIFIER = '" );
        sqlBuilder.append( clientName );
        sqlBuilder.append( "'" );

        int retVal = hdrJdbcTemplate.queryForInt( sqlBuilder.toString() );

        Assert.assertEquals( 1, retVal );
    }


    @After
    @Suite( groups = "smoketest" )
    public void AfterAbstractClientRpcTestMethodTearDown( )
    {
        clearRpcAuditLogTable();
    }
}