

package gov.va.med.cds.client.functional.mbean;


import gov.va.med.cds.client.functional.AbstractFunctionalTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.junit.runners.Suite;

import java.util.HashMap;
import java.util.Map;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.junit.Assert.*;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * Tests the Template cache ManagedBean operations using JMX Connectors
 * 
 * @author VHAISLTHUMMP
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
public class TemplateCacheResizeMBeanTest
    extends
        AbstractFunctionalTest
{
    private static Log logger;
    private static final String NL = System.getProperty( "line.separator" );
    private static final String MBEAN_SERVER_IP = "localhost";
    private static final String MBEAN_SERVER_PORT = "5555";
    private static final String ADMIN_USER_ENV_PROPERTY_NAME = "USER";
    private static final String ADMIN_PASSWORD_ENV_PROPERTY_NAME = "PASSWORD";
    private static final String TEMPLATE_MANAGER_MBEAN_DOMAIN = "gov.va.med.cds.template";
    private static final String TEMPLATE_MANAGER_MBEAN_NAME = ":name=cds-template-manager";

    private JMXConnector jmxc;
    private ObjectName stdMBeanName;
    private MBeanServerConnection mbsc;


    public static final void usage( )
    {
        System.err.println( "The TemplateManager JMX client:" + NL + "Options:" + NL + " -ip - IP Address to TemplateManager." + NL
                        + " -port - Listening port." + NL + " -user - (optional) Specify the username for authentication." + NL
                        + " -password - (optional) Specify the password for authentication." + NL );

        System.exit( 1 );
    }


    @Ignore
    @Test
    @Suite( groups = "prototypetest" )
    // FIX ME .R.S.
    public void testVerifyTemplateCacheResize( )
        throws Exception
    {
        // increasing TemplateCache capacity to 15
        mbsc.invoke( stdMBeanName, "resizeTemplateCache", new Object[] { 15 }, new String[] { "int" } );
        System.out.println( "=====After INCREASING TemplateCache Threshold from 10 (default) to 15======" );
        // get the current size of template cache
        System.out.println( "Number of Templates loaded into TemplateCache : "
                        + mbsc.invoke( stdMBeanName, "getNumberOfTemplatesLoadedIntoTemplateCache", null, null ) );
        assertEquals( ( ( Integer )mbsc.invoke( stdMBeanName, "getTemplateCacheThreshold", null, null ) ).intValue(), 15 );

        // decreasing template cacheMap capacity to 6
        mbsc.invoke( stdMBeanName, "resizeTemplateCache", new Object[] { 6 }, new String[] { "int" } );
        System.out.println( "\n=====After DECREASING TemplateCache Threshold from 15 to 6======" );
        // get the current size of template cache
        System.out.println( "Number of Templates loaded into TemplateCache : "
                        + mbsc.invoke( stdMBeanName, "getNumberOfTemplatesLoadedIntoTemplateCache", null, null ) );
        assertEquals( ( ( Integer )mbsc.invoke( stdMBeanName, "getTemplateCacheThreshold", null, null ) ).intValue(), 6 );

        // increasing template cacheMap capacity to 10
        mbsc.invoke( stdMBeanName, "resizeTemplateCache", new Object[] { 10 }, new String[] { "int" } );
        System.out.println( "\n=====After INCREASING TemplateCache Threshold from 6 to 10======" );
        // get the current size of template cache
        System.out.println( "Number of Templates loaded into TemplateCache : "
                        + mbsc.invoke( stdMBeanName, "getNumberOfTemplatesLoadedIntoTemplateCache", null, null ) );
        assertEquals( ( ( Integer )mbsc.invoke( stdMBeanName, "getTemplateCacheThreshold", null, null ) ).intValue(), 10 );
    }


    @BeforeClass
    static public void beforeTemplateCacheResizeMBeanTestClassSetUp( )
        throws Exception
    {
        logger = LogFactory.getLog( TemplateCacheResizeMBeanTest.class );

    }


    @Ignore
    @BeforeTestsOnce
    @Suite( groups = "prototypetest" )
    public void beforeTemplateCacheResizeMBeanTestsSetUp( )
    {
        // instantiate response validator MBean
        setupTemplateManagerMBean( new String[] { "-ip", MBEAN_SERVER_IP, "-port", MBEAN_SERVER_PORT } );

    }


    @Ignore
    @AfterTestsOnce
    @Suite( groups = "prototypetest" )
    public void afterTemplateCacheResizeMBeanTestsTearDown( )
        throws Exception
    {

        // Close MBeanServer connection
        jmxc.close();
    }


    private void setupTemplateManagerMBean( String[] args )
    {
        try
        {
            GetArgs opts = new GetArgs( TemplateCacheResizeMBeanTest.class, args, "ip:port:user:password:shutdownNow", "ip:port", false );

            String ip = opts.getArg( "ip" );
            String port = opts.getArg( "port" );
            String user = opts.getArg( "user" );
            String password = opts.getArg( "password" );

            // Create an RMI connector client and connect it to the RMI connector server
            JMXServiceURL url = new JMXServiceURL( "service:jmx:rmi:///jndi/rmi://" + ip + ":" + port + "/jmxrmi" );

            // Need to test password against remote server
            Map<String, String> env = new HashMap<String, String>();
            String pkgs = "com.sun.enterprise.admin.jmx.remote.protocol";
            env.put( JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES, pkgs );
            env.put( ADMIN_USER_ENV_PROPERTY_NAME, user );
            env.put( ADMIN_PASSWORD_ENV_PROPERTY_NAME, password );

            // Creates a connector client for the connector server at the given address. The resultant client is not
            // connected until its connect method is called.
            jmxc = JMXConnectorFactory.newJMXConnector( url, env );
            jmxc.connect();

            // Get an MBeanServerConnection
            mbsc = jmxc.getMBeanServerConnection();

            // Create FitlerManager MBean
            stdMBeanName = new ObjectName( TEMPLATE_MANAGER_MBEAN_DOMAIN + TEMPLATE_MANAGER_MBEAN_NAME );
            mbsc.getObjectInstance( stdMBeanName );
        }
        catch ( Exception e )
        {
            if ( e.getMessage().startsWith( "Failed to retrieve RMIServer stub" ) )
            {
                if ( logger.isErrorEnabled() )
                {
                    logger.error( "\nFailed to retrieve RMIServer stub.  Template Manager not running at the specified location." );
                }
            }
            else
            {
                e.printStackTrace();
            }
        }
    }
}
