

package gov.va.med.cds.client.functional;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/testharness/vhim400/builders/buildersTestContext.xml" } )
public class DataGeneratorTest
    extends
        AbstractBaseTest
{
    private DataGenerator dataGenerator = null;


    @Resource
    public void setClinicalDataBuilder( ClinicalDataBuilder clinicalDataBuilder )
    {
        this.dataGenerator = new DataGenerator();
        dataGenerator.setClinicalDataBuilder( clinicalDataBuilder );
    }

    private static final String TEST_REQUEST_ID = "test_request_id";


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateAllergyAssessmentXml( )
        throws Exception
    {
        String allergyAssessmentXml = dataGenerator.createAllergyAssessmentXml( TEST_REQUEST_ID,
                        TemplateIdHelper.ALLERGY_ASSESSMENT_CREATEORUPDATE_TEMPLATE_ID, null );
        System.out.println( allergyAssessmentXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateIntoleranceConditionXml( )
        throws Exception
    {
        String[] createIntoleranceConditionXml = dataGenerator.createIntoleranceConditionXmlWithTemplateIdentifier( TEST_REQUEST_ID,
                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID, "IntoleranceConditionRead40010" );
        for ( int i = 0; i < createIntoleranceConditionXml.length; i++ )
        {
            System.out.println( createIntoleranceConditionXml[i] + "\n" );
        }
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateIntoleranceConditionWithDateRangeXml( )
        throws Exception
    {
        String createIntoleranceConditionWithDateRangeXml = dataGenerator.createIntoleranceConditionWithDateRangeXml( "200801012345" );
        System.out.println( createIntoleranceConditionWithDateRangeXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testcreateIntoleranceConditionWithCommentEventXml( )
        throws Exception
    {
        String createIntoleranceConditionWithCommentEventXml = dataGenerator.createIntoleranceConditionWithCommentEventXml(
                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID, TEST_REQUEST_ID );
        System.out.println( createIntoleranceConditionWithCommentEventXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateVitalObservationEventXml( )
        throws Exception
    {
        String testCreateVitalObservationEventXml = dataGenerator.createVitalObservationEventXml( TEST_REQUEST_ID,
                        TemplateIdHelper.VITALSIGNS_CREATEORUPDATE_TEMPLATE_ID, null );
        System.out.println( testCreateVitalObservationEventXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseXml( )
        throws Exception
    {
        //      String createOutpatientMedicationPromiseXml = dataGenerator.createOutpatientMedicationPromiseXml( TEST_REQUEST_ID );
        String createOutpatientMedicationPromiseXml = dataGenerator.createOutpatientMedicationPromiseXml(
                        TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, TEST_REQUEST_ID, null );
        System.out.println( createOutpatientMedicationPromiseXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseXmlWithPtID( )
        throws Exception
    {
        //      String createOutpatientMedicationPromiseXml = dataGenerator.createOutpatientMedicationPromiseXml( TEST_REQUEST_ID, "test_pt_id");
        String createOutpatientMedicationPromiseXml = dataGenerator.createOutpatientMedicationPromiseXml(
                        TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, TEST_REQUEST_ID, "test_pt_id", "test_assigning_facility" );
        System.out.println( createOutpatientMedicationPromiseXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseWithSpecificDispensesXml( )
        throws Exception
    {
        String createOutpatientMedicationPromiseWithSpecificDispensesXml = dataGenerator
                        .createOutpatientMedicationPromiseWithSpecificDispensesXml( TEST_REQUEST_ID );
        System.out.println( createOutpatientMedicationPromiseWithSpecificDispensesXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseWithExpiryCancelDatesXml( )
        throws Exception
    {
        String createOutpatientMedicationPromiseWithExpiryCancelDatesXml = dataGenerator.createOutpatientMedicationPromiseWithExpiryCancelDatesXml(
                        TEST_REQUEST_ID, 8, 8 );
        System.out.println( createOutpatientMedicationPromiseWithExpiryCancelDatesXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseWithCommentsXml( )
        throws Exception
    {
        String createOutpatientMedicationPromiseWithCommentsXml = dataGenerator.createOutpatientMedicationPromiseWithCommentsXml( TEST_REQUEST_ID );
        System.out.println( createOutpatientMedicationPromiseWithCommentsXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateOutpatientMedicationPromiseWithNullCurrentProvider( )
        throws Exception
    {
        String createOutpatientMedicationPromiseWithNullCurrentProviderXml = dataGenerator
                        .createOutpatientMedicationPromiseWithNullCurrentProvider( TEST_REQUEST_ID );
        System.out.println( createOutpatientMedicationPromiseWithNullCurrentProviderXml );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateLabEventXml( )
        throws Exception
    {
        String createLabRequest = dataGenerator.createLabEventXml( TEST_REQUEST_ID, TemplateIdHelper.LAB_CREATEORUPDATE_TEMPLATE_ID, null );
        System.out.println( createLabRequest );

        String labReadFilter = dataGenerator.createFilterFromLabEvent( createLabRequest, TemplateIdHelper.LAB_READ_TEMPLATE_ID, null );
        System.out.println( labReadFilter );

        labReadFilter = dataGenerator.createFilterFromLabEventWithNationalId( createLabRequest, TemplateIdHelper.LAB_READ_TEMPLATE_ID, null );
        System.out.println( labReadFilter );

        labReadFilter = dataGenerator
                        .createFilterFromLabEventWithNationalId( createLabRequest, TemplateIdHelper.CHDR_LAB_SINGLE_PATIENT_FILTER, null );
        System.out.println( labReadFilter );

    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateLabXml( )
        throws Exception
    {
        String createVitalsRequest = dataGenerator.createVitalObservationEventXml( TEST_REQUEST_ID, TemplateIdHelper.VITALSIGNS_CREATE_TEMPLATE_ID,
                        null );
        System.out.println( createVitalsRequest );
    }


    @Test
    @Suite( groups = "prototypetest" )
    public void testCreateTiuXml( )
        throws Exception
    {
        String filterId = TemplateIdHelper.TIU_SINGLE_PATIENT_DETAIL_DATA_FILTER;
        String patientIdentity = "1";
        String assigningFacility = "580";
        String assigningAuthority = "USVHA";
        String recordIdentity = "755";
        String recordNamespaceId = "580_8925";
        String recordUniversalId = "";
        String recordUniversalIdType = "";

        String[] vistaPatient580 = { assigningAuthority, assigningFacility, patientIdentity };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        String createReadRequest = dataGenerator.createTiuSinglePatientDetailedDataFilter( filterId, resolvedPatients, recordIdentity,
                        recordNamespaceId, recordUniversalId, recordUniversalIdType );
        System.out.println( createReadRequest );

        filterId = TemplateIdHelper.TIU_SINGLE_PATIENT_LIST_DATA_FILTER;
        String documentClassValue = "3";

        createReadRequest = dataGenerator.createTiuSinglePatientListDataFilter( resolvedPatients, filterId, documentClassValue, null, null, null );
        System.out.println( createReadRequest );
    }


    private List<Map<String, String>> getResolvedPatients( String[][] patientIdentifiers )
    {
        List<Map<String, String>> resolvedPatients = new ArrayList<Map<String, String>>();

        for ( String[] patientIdentifier : patientIdentifiers )
        {
            Map<String, String> patient = new HashMap<String, String>();
            patient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, patientIdentifier[0] );
            patient.put( FilterBuilder.ASSIGNING_FACILITY, patientIdentifier[1] );
            patient.put( FilterBuilder.IDENTITY, patientIdentifier[2] );

            resolvedPatients.add( patient );
        }

        return resolvedPatients;
    }

}
