

package gov.va.med.cds.rpc.ejb;


import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.config.BeanConstantsInterface;
import gov.va.med.cds.ejb.ClinicalDataServiceSynchronousSession;
import gov.va.med.cds.ejb.ServiceConstantsInterface;
import gov.va.med.repositories.Pathways;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.jws.WebService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.ejb.support.AbstractStatelessSessionBean;

@WebService(endpointInterface = "gov.va.med.repositories.Pathways", 
targetNamespace="http://repositories.domain.ext/pathways",   
portName="PathwaysHttpPort", 
serviceName="Pathways")
public class ClinicalDataServiceRpcSynchronousSession
    extends
        AbstractStatelessSessionBean
    implements
        Pathways
{
    private static final long serialVersionUID = -7602332875347723055L;
    private Log logger = LogFactory.getLog( ClinicalDataServiceSynchronousSession.class );
    private ClinicalDataServiceInterface clinicalDataSourceSynchronous;
    private String pathwaysAppName;
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;


    @Override
    protected void onEjbCreate( )
        throws CreateException
    {
    	clinicalDataSourceSynchronous = ( ClinicalDataServiceInterface )getBeanFactory()
                        .getBean( BeanConstantsInterface.CLINICAL_DATA_SERVICE_SYNCHRONOUS_BEAN_ID );
        pathwaysAppName = (String) getBeanFactory().getBean( BeanConstantsInterface.PATHWAYS_APP_NAME );
        vhimRequestAuditLogger = ( VhimRequestAuditLoggerInterface )getBeanFactory().getBean( BeanConstantsInterface.VHIM_REQUEST_PATHWAYS_AUDIT_LOGGER );
    }


    /**
     * Override default BeanFactoryLocator implementation
     * 
     * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
     */
    @Override
    public void setSessionContext( SessionContext sessionContext )
    {
        super.setSessionContext( sessionContext );
        setBeanFactoryLocator( ContextSingletonBeanFactoryLocator.getInstance( "cdsBeanRefContext.xml" ) );
        setBeanFactoryLocatorKey( ServiceConstantsInterface.PRIMARY_CONTEXT_ID );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#isAlive()
     */
    public boolean isAlive( )
    {
        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, pathwaysAppName,
                            "About to call the POMO isAlive() method from inside the SLSB" ) );

        boolean result = clinicalDataSourceSynchronous.isAlive();

        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, pathwaysAppName,
                            "Finished calling the POMO isAlive() method from inside the SLSB" ) );

        return result;
    }


    /**
     * Synchronous version of a clinical data read
     *
     * @param templateId ID of the template for which the filter request applies
     * @param filterRequest Filter request specified in xml format according to the CDS filter schema
     * @param filterId ID of the named (canned) filter. The filterId may be null if no canned filter is referenced
     * @param requestId Client specified unique request Id
     * @return Results of the read returned in XML according to the CDS read results schema
     */
    public String readData( String templateId, String filterRequest, String filterId, String requestId )
    {
        long startTime = System.currentTimeMillis();
        
        if( filterRequest != null)
        {
            filterRequest = filterRequest.trim();
        }

        String response =  clinicalDataSourceSynchronous.readClinicalData( templateId, filterRequest, filterId, requestId );
        
        vhimRequestAuditLogger.auditReadRequest( templateId, filterRequest, filterId, requestId, startTime, response );

        return response;
    }
  
}
