

package gov.va.med.cds.ejb;


import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.config.BeanConstantsInterface;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.jws.WebService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.ejb.support.AbstractStatelessSessionBean;


/**
 * XDoclet-based session bean. The class must be declared public according to the EJB specification.
 * 
 * To generate the EJB related files to this EJB: - Add Standard EJB module to XDoclet project properties - Customize
 * XDoclet configuration for your appserver - Run XDoclet
 * 
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="ClinicalDataServiceSynchronousBean" display-name="Clinical Data Source Synchronous Session Bean"
 *           description="Provides an EJB stateless session front end to the Clinical Data Source POJOs"
 *           jndi-name="ejb/remote/gov/va/med/cds/ClinicalDataServiceSynchronousSession" type="Stateless"
 *           view-type="remote"
 */
@javax.jws.WebService(serviceName="ClinicalDataServiceSynchronousInterface",
			portName="ClinicalDataServiceSynchronousInterfaceHttpPort",
			endpointInterface = "gov.va.med.cds.client.ClinicalDataServiceInterface",
		    targetNamespace="http://client.cds.domain.ext")   
public class ClinicalDataServiceSynchronousSession
    extends
        AbstractStatelessSessionBean       
    implements
    ClinicalDataServiceInterface
{
    private static final long serialVersionUID = -7602332875347723053L;

    private Log logger = LogFactory.getLog( ClinicalDataServiceSynchronousSession.class );

    private ClinicalDataServiceInterface clinicalDataSourceSynchronous;
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;
    private String cdsAppName;


    @Override
    protected void onEjbCreate( )
        throws CreateException
    {
        clinicalDataSourceSynchronous = ( ClinicalDataServiceInterface )getBeanFactory().getBean(
                        BeanConstantsInterface.CLINICAL_DATA_SERVICE_SYNCHRONOUS_BEAN_ID );
        vhimRequestAuditLogger = ( VhimRequestAuditLoggerInterface )getBeanFactory().getBean( BeanConstantsInterface.VHIM_REQUEST_AUDIT_LOGGER );
        cdsAppName = ( String )getBeanFactory().getBean( BeanConstantsInterface.CDS_APP_NAME );
    }


    /**
     * Override default BeanFactoryLocator implementation
     * 
     * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
     */
    @Override
    public void setSessionContext( SessionContext sessionContext )
    {
        super.setSessionContext( sessionContext );
        setBeanFactoryLocator( ContextSingletonBeanFactoryLocator.getInstance( "cdsBeanRefContext.xml" ) );
        setBeanFactoryLocatorKey( ServiceConstantsInterface.PRIMARY_CONTEXT_ID );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#appendClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String appendClinicalData( String appendRequest, String templateId, String requestId )
    {
        if( appendRequest != null )
        {
            appendRequest = appendRequest.trim();
        }
    	vhimRequestAuditLogger.auditWriteRequest(templateId, appendRequest, requestId);
        return clinicalDataSourceSynchronous.appendClinicalData( appendRequest, templateId, requestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#createClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String createClinicalData( String createRequest, String templateId, String requestId )
    {
        if( createRequest != null )
        {
            createRequest = createRequest.trim();
        }
    	vhimRequestAuditLogger.auditWriteRequest(templateId, createRequest, requestId);
        return clinicalDataSourceSynchronous.createClinicalData( createRequest, templateId, requestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#deleteClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String deleteClinicalData( String deleteRequest, String templateId, String requestId )
    {
        if( deleteRequest != null )
        {
            deleteRequest = deleteRequest.trim();
        }
    	vhimRequestAuditLogger.auditWriteRequest(templateId, deleteRequest, requestId);
        return clinicalDataSourceSynchronous.deleteClinicalData( deleteRequest, templateId, requestId );
    }
    
    @Override
    public String readClinicalData( String templateId, String filterId, String requestId )
    {
        throw new UnsupportedOperationException();
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#readClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String)
     */
    public String readClinicalData( String templateId, String filterRequest, String filterId, String requestId )
    {
    	long startTime = System.currentTimeMillis();
    	
    	if(filterRequest != null)
    	{
    	    filterRequest = filterRequest.trim();
    	}

        String response =  this.readClinicalData( templateId, filterRequest, filterId, requestId, true );
        
        return response;
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceExtendedInterface#readClinicalData(java.lang.String, 
     *      java.lang.String, java.lang.String, java.lang.String, boolean)
     */
    public String readClinicalData( String templateId, String filterRequest, String filterId, String requestId, boolean audit )
    {
        long startTime = System.currentTimeMillis();
        
        if(filterRequest != null)
        {
            filterRequest = filterRequest.trim();
        }

        String response = clinicalDataSourceSynchronous.readClinicalData( templateId, filterRequest, filterId, requestId );

        // Audit the read request details
        if ( audit )
        {
            vhimRequestAuditLogger.auditReadRequest( templateId, filterRequest, filterId, requestId, startTime, response );
        }

        return response;
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#updateClinicalData(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public String updateClinicalData( String updateRequest, String templateId, String requestId )
    {
        if( updateRequest != null )
        {
            updateRequest = updateRequest.trim();
        }
    	vhimRequestAuditLogger.auditWriteRequest(templateId, updateRequest, requestId);
        return clinicalDataSourceSynchronous.updateClinicalData( updateRequest, templateId, requestId );
    }


    /**
     * 
     * @see gov.va.med.cds.client.ClinicalDataServiceInterface#isAlive()
     */
    public boolean isAlive( )
    {
        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, cdsAppName,
                            "About to call the POMO isAlive() method from inside the SLSB" ) );

        boolean result = clinicalDataSourceSynchronous.isAlive();

        if ( logger.isDebugEnabled() )
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, cdsAppName,
                            "Finished calling the POMO isAlive() method from inside the SLSB" ) );

        return result;
    }


//    @WebMethod(exclude=true)
    public void setClinicalDataServiceSynchronous( ClinicalDataServiceInterface clinicalDataSourceSynchronous )
    {
        this.clinicalDataSourceSynchronous = clinicalDataSourceSynchronous;
    }


//    @WebMethod(exclude=true)
    public void setVhimRequestAuditLogger( VhimRequestAuditLoggerInterface vhimRequestAuditLogger )
    {
        this.vhimRequestAuditLogger = vhimRequestAuditLogger;
    }

}
