

package gov.va.med.cds.xml.schema;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;

import javax.sql.rowset.serial.SerialException;


@RunWith( SuiteAwareRunner.class )
public class ProgrammaticSchemaValidationTest
{
    private static Resource[] jarResources = null;
    private static PathMatchingResourcePatternResolver pathResolver = new PathMatchingResourcePatternResolver();
    public static final String TEMPLATE_JAR_PATH_PATTERN = "file:/Projects/HDR/CDS3.0/VHIM/ClinicalDocumentEvent/Deliverables12062010/Legacy TIU Document List Nov 29 2010/*.jar";
    public static byte[] byteArrayJar = null;


    @BeforeClass
    @Suite( groups = { "schemavalidationtest" } )
    public static void setUp( )
        throws IOException
    {
        jarResources = pathResolver.getResources( TEMPLATE_JAR_PATH_PATTERN );
        if(jarResources.length > 0)
        {
	        Resource jarResource = jarResources[0];
	        byteArrayJar = getBytesFromFile( jarResource.getFile() );
        }
        
      //assertNotNull( byteArrayJar );
    }

    /**
     * This test excercises schema loading from a jar file.
     *
     * @throws IOException
     */
    @Test
    @Suite( groups = { "schemavalidationtest" } )
    public void testLoadSchemaFromJar( )
        throws Exception
    {
    	if( byteArrayJar != null)
    	{
	        Blob blobJar = new javax.sql.rowset.serial.SerialBlob( byteArrayJar );
	        SchemaHelperInterface schemaHelper = new SchemaHelper( blobJar, "testSchema" );
	        assertNotNull( schemaHelper );
	        assertTrue( schemaHelper.toString().contains( "testSchema" ) );
	        assertNotNull( schemaHelper.getSymbolMap() );
	        assertNotNull( schemaHelper.getValidator() );
    	}
    }



    /**
     * Returns the contents of the file in a byte array
     * @param file File this method should read
     * @return byte[] Returns a byte[] array of the contents of the file
     */
    private static byte[] getBytesFromFile( File file )
        throws IOException
    {

        InputStream is = new FileInputStream( file );
        System.out.println( "\nDEBUG: FileInputStream is " + file );

        // Get the size of the file
        long length = file.length();
        System.out.println( "DEBUG: Length of " + file + " is " + length + "\n" );

        /*
         * You cannot create an array using a long type. It needs to be an int
         * type. Before converting to an int type, check to ensure that file is
         * not loarger than Integer.MAX_VALUE;
         */
        if ( length > Integer.MAX_VALUE )
        {
            System.out.println( "File is too large to process" );
            return null;
        }

        // Create the byte array to hold the data
        byte[] bytes = new byte[( int )length];

        // Read in the bytes
        int offset = 0;
        int numRead = 0;
        while ( ( offset < bytes.length ) && ( ( numRead = is.read( bytes, offset, bytes.length - offset ) ) >= 0 ) )
        {

            offset += numRead;

        }

        // Ensure all the bytes have been read in
        if ( offset < bytes.length )
        {
            throw new IOException( "Could not completely read file " + file.getName() );
        }

        is.close();
        return bytes;

    }

}
