<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
     xmlns:xs="http://www.w3.org/2001/XMLSchema" 
     xmlns:fn="http://www.w3.org/2005/xpath-functions" 
     exclude-result-prefixes="xs fn xsl">

<!--output format close to xquery-->
<xsl:output method="xml" encoding="utf-8" omit-xml-declaration="yes" indent="yes"/>

<xsl:template match="/">
	<clinicaldata:ClinicalData xmlns:clinicaldata="Clinicaldata">
			<xsl:for-each select="clinicaldata:ClinicalData">
				<xsl:call-template name="ClinicalData"/>
			</xsl:for-each>
	</clinicaldata:ClinicalData>
</xsl:template>

<xsl:template name="ClinicalData">
		<xsl:sequence select="./templateId"/>
		<xsl:sequence select="./requestId"/>
		<xsl:for-each select="./patient">
			<patient>
				<xsl:call-template name="ClinicalDataPatient">
					<xsl:with-param name="input" select="." as="node()"/>
				</xsl:call-template>
			</patient>
		</xsl:for-each>
		<xsl:if test="count(./errorSection) != 0">
			<errorSection>
				<xsl:call-template name="ErrorSection">
					<xsl:with-param name="input" select="./errorSection" as="node()"/>
				</xsl:call-template>
			</errorSection>
		</xsl:if>
</xsl:template>

<xsl:template name="ClinicalDataPatient">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/requestedNationalId) != 0">
		<requestedNationalId>
			<xsl:value-of select="$input/requestedNationalId"/>
		</requestedNationalId>
	</xsl:if>
	<xsl:if test="count($input/requestedResolvedIdentifiers) != 0">
		<xsl:for-each select="$input/requestedResolvedIdentifiers">
			<requestedResolvedIdentifiers>
				<xsl:call-template name="HL72PersonIdentifier">
					<xsl:with-param name="input" select="." as="node()"/>
				</xsl:call-template>
			</requestedResolvedIdentifiers>
		</xsl:for-each>
	</xsl:if>
	<!--
	<xsl:sequence select="$input/requestedExcludedIdentifiers"/>
	<xsl:sequence select="$input/resultantIdentifiers"/>
	<xsl:sequence select="$input/vitalSignObservationEvents"/>
    -->
	<xsl:if test="count($input/requestedExcludedIdentifiers) != 0">
		<xsl:for-each select="$input/requestedExcludedIdentifiers">
			<requestedExcludedIdentifiers>
				<xsl:call-template name="HL72PersonIdentifier">
					<xsl:with-param name="input" select="." as="node()"/>
				</xsl:call-template>
			</requestedExcludedIdentifiers>
		</xsl:for-each>
	</xsl:if>
	<xsl:if test="count($input/resultantIdentifiers) != 0">
		<xsl:for-each select="$input/resultantIdentifiers">
			<resultantIdentifiers>
				<xsl:call-template name="HL72PersonIdentifier">
					<xsl:with-param name="input" select="." as="node()"/>
				</xsl:call-template>
			</resultantIdentifiers>
		</xsl:for-each>
	</xsl:if>
	<xsl:if test="count(./vitalSignObservationEvents) != 0">
		<xsl:for-each select="./vitalSignObservationEvents">
			<vitalSignObservationEvents>
				<xsl:call-template name="VitalSignObservationEvent">
					<xsl:with-param name="input" select="." as="node()"/>
				</xsl:call-template>
			</vitalSignObservationEvents>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template name="HL72PersonIdentifier">
	<xsl:param name="input" select="()"/>
		<xsl:if test="count($input/identity) != 0">
			<xsl:sequence select="$input/identity"/>
		</xsl:if>
		<xsl:if test="count($input/assigningFacility) != 0">
			<xsl:sequence select="$input/assigningFacility"/>
		</xsl:if>
		<xsl:if test="count($input/assigningAuthority) != 0">
			<xsl:sequence select="$input/assigningAuthority"/>
		</xsl:if>
</xsl:template>

<xsl:template name="VitalSignObservationEvent">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/recordIdentifier) != 0">
		<recordIdentifier>
			<xsl:call-template name="HL72EntityIdentifier">
				<xsl:with-param name="input" select="$input/recordIdentifier" as="node()"/>
			</xsl:call-template>
		</recordIdentifier>
	</xsl:if>
	<xsl:if test="count($input/patient) != 0">
		<patient>
			<xsl:call-template name="PatientLite">
				<xsl:with-param name="input" select="$input/patient" as="node()"/>
			</xsl:call-template>
		</patient>
	</xsl:if>
	<xsl:if test="count($input/observationTime) != 0">
		<observationTime>
			<xsl:call-template name="PointInTime">
				<xsl:with-param name="input" select="$input/observationTime" as="node()"/>
			</xsl:call-template>
		</observationTime>
	</xsl:if>
	<xsl:if test="count($input/observationMethod) != 0">
		<observationMethod>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/observationMethod" as="node()"/>
			</xsl:call-template>
		</observationMethod>
	</xsl:if>
	<xsl:if test="count($input/observedCharacteristic) != 0">
		<observedCharacteristic>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/observedCharacteristic" as="node()"/>
			</xsl:call-template>
		</observedCharacteristic>
	</xsl:if>
	<xsl:if test="count($input/collectionSessionTime) != 0">
		<collectionSessionTime>
			<xsl:call-template name="PointInTime">
				<xsl:with-param name="input" select="$input/collectionSessionTime" as="node()"/>
			</xsl:call-template>
		</collectionSessionTime>
	</xsl:if>
	<xsl:if test="count($input/status) != 0">
		<xsl:sequence select="$input/status"/>
	</xsl:if>
	<xsl:if test="count($input/supplementalOxygen) != 0">
		<supplementalOxygen>
			<xsl:call-template name="OxygenAdministration">
				<xsl:with-param name="input" select="$input/supplementalOxygen" as="node()"/>
			</xsl:call-template>
		</supplementalOxygen>
	</xsl:if>
	<xsl:if test="count($input/author) != 0">
		<author>
			<xsl:call-template name="PractitionerParticipationLite">
				<xsl:with-param name="input" select="$input/author" as="node()"/>
			</xsl:call-template>
		</author>
	</xsl:if>
	<xsl:if test="count($input/homeTelehealthMonitor) != 0">
		<homeTelehealthMonitor>
			<xsl:call-template name="HomeTelehealthMonitor">
				<xsl:with-param name="input" select="$input/homeTelehealthMonitor" as="node()"/>
			</xsl:call-template>
		</homeTelehealthMonitor>
	</xsl:if>
	<xsl:if test="count($input/hospitalLocationIdentifier) != 0">
		<hospitalLocationIdentifier>
			<xsl:call-template name="HL72LocationIdentifier">
				<xsl:with-param name="input" select="$input/hospitalLocationIdentifier" as="node()"/>
			</xsl:call-template>
		</hospitalLocationIdentifier>
	</xsl:if>
	<xsl:if test="count($input/division) != 0">
		<division>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/division" as="node()"/>
			</xsl:call-template>
		</division>
	</xsl:if>
	<xsl:if test="count($input/orderingFacilityIdentifier) != 0">
		<orderingFacilityIdentifier>
			<xsl:call-template name="HL72OrganizationIdentifier">
				<xsl:with-param name="input" select="$input/orderingFacilityIdentifier" as="node()"/>
			</xsl:call-template>
		</orderingFacilityIdentifier>
	</xsl:if>
	<xsl:if test="count($input/stopCode) != 0">
		<stopCode>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/stopCode" as="node()"/>
			</xsl:call-template>
		</stopCode>
	</xsl:if>
	<xsl:if test="count($input/vitalSignObservation) != 0">
		<vitalSignObservation>
			<xsl:call-template name="VitalSignObservation">
				<xsl:with-param name="input" select="$input/vitalSignObservation" as="node()"/>
			</xsl:call-template>
		</vitalSignObservation>
	</xsl:if>
	<xsl:if test="count($input/errorEnterer) != 0">
		<errorEnterer>
			<xsl:call-template name="PractitionerParticipationLite">
				<xsl:with-param name="input" select="$input/errorEnterer" as="node()"/>
			</xsl:call-template>
		</errorEnterer>
	</xsl:if>
	<xsl:if test="count($input/errorReason) != 0">
		<errorReason>
			<xsl:call-template name="ErrorReason">
				<xsl:with-param name="input" select="$input/errorReason" as="node()"/>
			</xsl:call-template>
		</errorReason>
	</xsl:if>
	<xsl:if test="count($input/recordSource) != 0">
		<recordSource>
			<xsl:call-template name="HL72FacilityIdentifier">
				<xsl:with-param name="input" select="$input/recordSource" as="node()"/>
			</xsl:call-template>
		</recordSource>
	</xsl:if>
	<xsl:if test="count($input/recordVersion) != 0">
		<xsl:sequence select="$input/recordVersion"/>
	</xsl:if>
	<xsl:if test="count($input/recordUpdateTime) != 0">
		<recordUpdateTime>
			<xsl:call-template name="PointInTime">
				<xsl:with-param name="input" select="$input/recordUpdateTime" as="node()"/>
			</xsl:call-template>
		</recordUpdateTime>
	</xsl:if>
</xsl:template>

<xsl:template name="HL72EntityIdentifier">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/identity) != 0">
		<xsl:sequence select="($input/identity)"/>
	</xsl:if>
	<xsl:if test="count($input/namespaceId) != 0">
		<xsl:sequence select="($input/namespaceId)"/>
	</xsl:if>
	<xsl:if test="count($input/universalId) != 0">
		<xsl:sequence select="($input/universalId)"/>
	</xsl:if>
	<xsl:if test="count($input/universalIdType) != 0">
		<xsl:sequence select="$input/universalIdType"/>
	</xsl:if>
</xsl:template>

<xsl:template name="PatientLite">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/identifier) != 0">
		<identifier>
			<xsl:call-template name="HL72PersonIdentifier">
				<xsl:with-param name="input" select="$input/identifier" as="node()"/>
			</xsl:call-template>
		</identifier>
	</xsl:if>
	<xsl:if test="count($input/name) != 0">
		<name>
			<xsl:call-template name="HL72PersonName">
				<xsl:with-param name="input" select="$input/name" as="node()"/>
			</xsl:call-template>
		</name>
	</xsl:if>
</xsl:template>

<xsl:template name="HL72PersonName">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/prefix) != 0">
		<xsl:sequence select="$input/prefix"/>
	</xsl:if>
	<xsl:if test="count($input/given) != 0">
		<xsl:sequence select="$input/given"/>
	</xsl:if>
	<xsl:if test="count($input/middle) != 0">
		<xsl:sequence select="$input/middle"/>
	</xsl:if>
	<xsl:if test="count($input/family) != 0">
		<xsl:sequence select="$input/family"/>
	</xsl:if>
	<xsl:if test="count($input/suffix) != 0">
		<xsl:sequence select="$input/suffix"/>
	</xsl:if>
	<xsl:if test="count($input/title) != 0">
		<xsl:sequence select="$input/title"/>
	</xsl:if>
</xsl:template>

<xsl:template name="PointInTime">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/literal) != 0">
		<xsl:sequence select="$input/literal"/>
	</xsl:if>
</xsl:template>

<xsl:template name="HL72CodedElementLite">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/code) != 0">
		<xsl:sequence select="$input/code"/>
	</xsl:if>
	<xsl:if test="count($input/displayText) != 0">
		<xsl:sequence select="$input/displayText"/>
	</xsl:if>
	<xsl:if test="count($input/codingSystem) != 0">
		<xsl:sequence select="$input/codingSystem"/>
	</xsl:if>
</xsl:template>

<xsl:template name="OxygenAdministration">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/flowRateValue) != 0">
		<xsl:sequence select="$input/flowRateValue"/>
	</xsl:if>
	<xsl:if test="count($input/flowRateUnit) != 0">
		<flowRateUnit>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/flowRateUnit" as="node()"/>
			</xsl:call-template>
		</flowRateUnit>
	</xsl:if>
	<xsl:if test="count($input/concentrationValue) != 0">
		<xsl:sequence select="$input/concentrationValue"/>
	</xsl:if>
	<xsl:if test="count($input/concentrationUnit) != 0">
		<concentrationUnit>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/concentrationUnit" as="node()"/>
			</xsl:call-template>
		</concentrationUnit>
	</xsl:if>
</xsl:template>

<xsl:template name="PractitionerParticipationLite">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/comment) != 0">
		<xsl:sequence select="$input/comment"/>
	</xsl:if>
	<xsl:if test="count($input/time) != 0">
		<time>
			<xsl:call-template name="PointInTime">
				<xsl:with-param name="input" select="$input/time" as="node()"/>
			</xsl:call-template>
		</time>
	</xsl:if>
	<xsl:if test="count($input/practitioner) != 0">
		<practitioner>
			<xsl:call-template name="PractitionerLite">
				<xsl:with-param name="input" select="$input/practitioner" as="node()"/>
			</xsl:call-template>
		</practitioner>
	</xsl:if>
</xsl:template>

<xsl:template name="PractitionerLite">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/identifier) != 0">
		<identifier>
			<xsl:call-template name="HL72PersonIdentifier">
				<xsl:with-param name="input" select="$input/identifier" as="node()"/>
			</xsl:call-template>
		</identifier>
	</xsl:if>
	<xsl:if test="count($input/idSourceTable) != 0">
		<xsl:sequence select="$input/idSourceTable"/>
	</xsl:if>
	<xsl:if test="count($input/name) != 0">
		<name>
			<xsl:call-template name="HL72PersonName">
				<xsl:with-param name="input" select="$input/name" as="node()"/>
			</xsl:call-template>
		</name>
	</xsl:if>
</xsl:template>

<xsl:template name="HomeTelehealthMonitor">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/vendor) != 0">
		<xsl:sequence select="$input/vendor"/>
	</xsl:if>
	<xsl:if test="count($input/homeAppliance) != 0">
		<xsl:sequence select="$input/homeAppliance"/>
	</xsl:if>
	<xsl:if test="count($input/measurementDevice) != 0">
		<xsl:sequence select="$input/measurementDevice"/>
	</xsl:if>
</xsl:template>

<xsl:template name="HL72LocationIdentifier">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/pointOfCare) != 0">
		<xsl:sequence select="$input/pointOfCare"/>
	</xsl:if>
	<xsl:if test="count($input/room) != 0">
		<xsl:sequence select="$input/room"/>
	</xsl:if>
	<xsl:if test="count($input/bed) != 0">
		<xsl:sequence select="$input/bed"/>
	</xsl:if>
	<xsl:if test="count($input/facilityNamespaceId) != 0">
		<xsl:sequence select="$input/facilityNamespaceId"/>
	</xsl:if>
	<xsl:if test="count($input/facilityUniversalId) != 0">
		<xsl:sequence select="$input/facilityUniversalId"/>
	</xsl:if>
	<xsl:if test="count($input/facilityUniversalIdType) != 0">
		<xsl:sequence select="$input/facilityUniversalIdType"/>
	</xsl:if>
	<xsl:if test="count($input/personLocationType) != 0">
		<xsl:sequence select="$input/personLocationType"/>
	</xsl:if>
	<xsl:if test="count($input/locationDescription) != 0">
		<xsl:sequence select="$input/locationDescription"/>
	</xsl:if>
</xsl:template>

<xsl:template name="HL72OrganizationIdentifier">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/identity) != 0">
		<xsl:sequence select="$input/identity"/>
	</xsl:if>
	<xsl:if test="count($input/name) != 0">
		<xsl:sequence select="$input/name"/>
	</xsl:if>
	<xsl:if test="count($input/assigningAuthority) != 0">
		<xsl:sequence select="$input/assigningAuthority"/>
	</xsl:if>
</xsl:template>

<xsl:template name="VitalSignObservation">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/value) != 0">
		<xsl:sequence select="$input/value"/>
	</xsl:if>
	<xsl:if test="count($input/unit) != 0">
		<unit>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/unit" as="node()"/>
			</xsl:call-template>
		</unit>
	</xsl:if>
	<xsl:if test="count($input/qualifier) != 0">
		<qualifier>
			<xsl:call-template name="VitalSignQualifier">
				<xsl:with-param name="input" select="$input/qualifier" as="node()"/>
			</xsl:call-template>
		</qualifier>
	</xsl:if>
</xsl:template>

<xsl:template name="VitalSignQualifier">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/value) != 0">
		<value>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/value" as="node()"/>
			</xsl:call-template>
		</value>
	</xsl:if>
</xsl:template>

<xsl:template name="ErrorReason">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/reason) != 0">
		<reason>
			<xsl:call-template name="HL72CodedElementLite">
				<xsl:with-param name="input" select="$input/reason" as="node()"/>
			</xsl:call-template>
		</reason>
	</xsl:if>
</xsl:template>

<xsl:template name="HL72FacilityIdentifier">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/namespaceId) != 0">
		<xsl:sequence select="$input/namespaceId"/>
	</xsl:if>
	<xsl:if test="count($input/universalId) != 0">
		<xsl:sequence select="$input/universalId"/>
	</xsl:if>
	<xsl:if test="count($input/universalIdType) != 0">
		<xsl:sequence select="$input/universalIdType"/>
	</xsl:if>
</xsl:template>

<xsl:template name="ErrorSection">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/errors) != 0">
		<errors>
			<xsl:call-template name="Error">
				<xsl:with-param name="input" select="$input/errors" as="node()"/>
			</xsl:call-template>
		</errors>
	</xsl:if>
	<xsl:if test="count($input/fatalErrors) != 0">
		<fatalErrors>
			<xsl:call-template name="Error">
				<xsl:with-param name="input" select="$input/fatalErrors" as="node()"/>
			</xsl:call-template>
		</fatalErrors>
	</xsl:if>
	<xsl:if test="count($input/warnings) != 0">
		<warnings>
			<xsl:call-template name="Error">
				<xsl:with-param name="input" select="$input/warnings" as="node()"/>
			</xsl:call-template>
		</warnings>
	</xsl:if>
</xsl:template>

<xsl:template name="Error">
	<xsl:param name="input" select="()"/>
	<xsl:if test="count($input/errorId) != 0">
		<xsl:sequence select="$input/errorId"/>
	</xsl:if>
	<xsl:if test="count($input/exception) != 0">
		<xsl:sequence select="$input/exception"/>
	</xsl:if>
	<xsl:if test="count($input/exceptionMessage) != 0">
		<xsl:sequence select="$input/exceptionMessage"/>
	</xsl:if>
	<xsl:if test="count($input/errorCode) != 0">
		<xsl:sequence select="$input/errorCode"/>
	</xsl:if>
	<xsl:if test="count($input/displayMessage) != 0">
		<xsl:sequence select="$input/displayMessage"/>
	</xsl:if>
</xsl:template>

	
</xsl:stylesheet>