

package gov.va.med.cds.vdm.vhim400.template;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * 
 * Testing concurrent processing
 * 
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
public class ConcurrentTemplateTest
    extends
        AbstractTemplateConcurrentTest

{

    private String[] moreTemplatesThanCache = new String[] { "AllergiesRead40010", "AllergyAssessmentCreateOrUpdate40060",
                    "AllergyAssessmentDelete40030", "AllergyAssessmentRead40010", "CdsResponse400", "IntoleranceConditionCreateOrUpdate40060",
                    "IntoleranceConditionDelete40030", "IntoleranceConditionPharmacyRead40010", "IntoleranceConditionRead40010",
                    "IntoleranceConditionReducedRead40011", "LabCreateOrUpdate40060", "LabDelete40030", "LabRead40010",
                    "MHVIntoleranceConditionRead40011", "PharmacyCreateOrUpdate40060", "PharmacyDelete40030", "PharmacyRead40010",
                    "RDIIntoleranceConditionPharmacyRead40010", "ReadResponseRDIandVWTemplateMaster40010", "TiuDocumentDetailRead2",
                    "TiuDocumentDetailRead40012", "TiuDocumentListRead2", "TiuDocumentListRead40011", "VitalsignsCreateOrUpdate40060",
                    "VitalsignsDelete40030", "VitalsignsRead40010", "VWAllergiesRead40010", "VWIntoleranceConditionRead40010",
                    "VWPharmacyDetailRead40010", "VWPharmacyRead40010", "VWVitalsignsRead40010", "MHVLabRead40011" };

    private String[] sameTemplatesAsCache = new String[] { "AllergiesRead40010", "AllergyAssessmentCreateOrUpdate40060",
                    "AllergyAssessmentDelete40030", "AllergyAssessmentRead40010", "CdsResponse400", "IntoleranceConditionCreateOrUpdate40060",
                    "IntoleranceConditionDelete40030", "IntoleranceConditionPharmacyRead40010", "IntoleranceConditionRead40010",
                    "IntoleranceConditionReducedRead40011" };

    private String[] lessTemplatesThanCache = new String[] { "AllergiesRead40010" };


    @Override
    @Test
    @Suite( groups = { "checkintest" } )
    public void performTemplateManagerOperation( )
        throws Exception
    {
        long runToTimeInMilliSeconds = System.currentTimeMillis() + RUN_TIME_IN_MILLI_SECONDS;

        while ( System.currentTimeMillis() < runToTimeInMilliSeconds )
        {
            for ( String template : lessTemplatesThanCache )
            {
                getTemplateManager().getTemplateMetaData( template );
            }
        }

        runToTimeInMilliSeconds = System.currentTimeMillis() + RUN_TIME_IN_MILLI_SECONDS;

        while ( System.currentTimeMillis() < runToTimeInMilliSeconds )
        {
            for ( String template : sameTemplatesAsCache )
            {
                getTemplateManager().getTemplateMetaData( template );
            }
        }

        runToTimeInMilliSeconds = System.currentTimeMillis() + RUN_TIME_IN_MILLI_SECONDS;

        while ( System.currentTimeMillis() < runToTimeInMilliSeconds )
        {
            for ( String template : moreTemplatesThanCache )
            {
                getTemplateManager().getTemplateMetaData( template );
            }
        }
    }

}
