

package gov.va.med.cds.vdm.vhim400.integration;


import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.integration.ErrorSectionCheckerInterface;
import gov.va.med.cds.vdm.ClinicalDataInterface;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ClinicalData;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ErrorSection;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;


public class ErrorSectionChecker
    implements
        ErrorSectionCheckerInterface
{

    public void assertHasFatalErrors( ClinicalDataInterface vdmClinicalData )
    {
        ErrorSection errorSection = ( ( ClinicalData )vdmClinicalData ).getErrorSection();
        assertNotNull( errorSection );
        assertEquals( errorSection.getErrors().size(), 0 );
        assertEquals( errorSection.getFatalErrors().size(), 1 );
        assertEquals( errorSection.getWarnings().size(), 0 );

    }


    public void assertNoErrors( ClinicalDataInterface vdmClinicalData )
    {
        ErrorSection errorSection = ( ( ClinicalData )vdmClinicalData ).getErrorSection();
        if ( errorSection != null )
        {
            assertEquals( errorSection.getErrors().toString(), errorSection.getErrors().size(), 0 );
            assertEquals( errorSection.getFatalErrors().toString(), errorSection.getFatalErrors().size(), 0 );
            assertEquals( errorSection.getWarnings().toString(), errorSection.getWarnings().size(), 0 );
        }

    }


    public void assertErrors( ClinicalDataInterface vdmClinicalData, LoggingSeverity severity, int count )
    {
        ErrorSection errorSection = ( ( ClinicalData )vdmClinicalData ).getErrorSection();
        assertNotNull( errorSection );
        if ( errorSection != null )
        {
            switch ( severity )
            {
            case FATAL:
                assertEquals( errorSection.getFatalErrors().toString() , errorSection.getFatalErrors().size(), count);
                break;
            case ERROR:
                assertEquals(errorSection.getErrors().toString(), errorSection.getErrors().size(), count );
                break;
            case WARNING:
            default:
                assertEquals( errorSection.getWarnings().toString(),errorSection.getWarnings().size(), count);
                break;
            }
        }
    }
}
