

package gov.va.med.cds.vdm.vhim400.integration;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.integration.AbstractEndToEndReadNoXpathFilterTest;
import gov.va.med.cds.integration.ClinicalDataCount;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.template.TemplateWriteRequest;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

import javax.xml.parsers.ParserConfigurationException;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xml.sax.SAXException;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadNoXpathFilterV400Test
    extends
        AbstractEndToEndReadNoXpathFilterTest
{
             
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testAllergiesAssessmentReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        super.testAllergiesAssessmentReadCreateRead();
    }


    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testIntoleranceConditionReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        //super.testIntoleranceConditionReadCreateRead();
    }


    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testOutpatientMedicationPromiseReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        //super.testOutpatientMedicationPromiseReadCreateRead();
    }


    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testVitalSignObservationEventReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        //super.testVitalSignObservationEventReadCreateRead();
    }


    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testLabTestPromiseReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        //super.testLabTestPromiseReadCreateRead();
    }


    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testMultiEntryPointRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        //super.testMultiEntryPointRead();
    }


    @Override
    @Test
    @Suite( groups = { "slowtest" } )
    public void testMultiEntryPointMultiPatientWriteRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        //super.testMultiEntryPointMultiPatientWriteRead();
    }


    protected void prepareAndCreateDataForTest( Document clinicalDataDocument )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        Element clinicalDataPatient = clinicalDataGenerator.getClinicalDataPatient( clinicalDataDocument );
        Assert.assertNotNull( clinicalDataPatient );
        // create control xml and create clinincalData
        String templateId = clinicalDataDocument.getRootElement().elementText( "templateId" );
        String createXml = clinicalDataDocument.asXML();
        createClinicalData( templateId, createXml );
    }


    //Read Template Ids
    protected String getIntoleranceConditionPharmacyReadTemplateID( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID;
    }


    protected String getIntoleranceConditionReadTemplateID( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
    }


    protected String getAllergyAssessmentReadTemplateID( )
    {
        return TemplateIdHelper.ALLERGY_ASSESSMENT_READ_TEMPLATE_ID;
    }


    protected String getPharmacyReadTemplateID( )
    {
        return TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
    }


    protected String getLabReadTemplateID( )
    {
        return TemplateIdHelper.LAB_READ_TEMPLATE_ID;
    }


    protected String getVitalReadTemplateID( )
    {
        return TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID;
    }


    // Create Template Ids
    protected String getIntoleranceConditionCreateTemplateID( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID;
    }


    protected String getAllergyAssessmentCreateTemplateID( )
    {
        return TemplateIdHelper.ALLERGY_ASSESSMENT_CREATE_TEMPLATE_ID;
    }


    protected String getPharmacyCreateTemplateID( )
    {
        return TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID;
    }


    protected String getLabCreateTemplateID( )
    {
        return TemplateIdHelper.LAB_CREATE_TEMPLATE_ID;
    }


    protected String getVitalCreateTemplateID( )
    {
        return TemplateIdHelper.VITALSIGNS_CREATE_TEMPLATE_ID;
    }


    protected Document makeClinicalDataRecord( Element personIdentifier, String templateId )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        // now add an additional ClinicalData record

        Document clinicalDataDocument = clinicalDataGenerator.createClinicalData( templateId, 1, personIdentifier );
        prepareAndCreateDataForTest( clinicalDataDocument );
        return clinicalDataDocument;
    }


    protected void createClinicalData( String templateId, String createXml )
    {
        TemplateWriteRequest templateWriteRequest = new TemplateWriteRequest( createXml, Operation.Create );
        templateWriteRequest.setTemplateId( templateId );
        templateWriteRequest.setRequestId( new UniqueIdentifier().toString() );
        getRequestValidator().validateWriteRequest( templateWriteRequest );
        Document createResult = getRequestProcessor().createClinicalData( createXml, templateId, new UniqueIdentifier().toString() );
        gov.va.med.cds.testharness.xml.Assert.assertNoErrors( createResult.asXML() );
    }


    protected String createIdentityDomainEntryPointFilter( Element patient, DomainEntryPoint... domainEntryPoint )
    {
        List<Element> subjects = new ArrayList<Element>( 1 );
        subjects.add( patient );
        String filter = createIdentityDomainEntryPointFilter( subjects, domainEntryPoint );

        return filter;
    }


    /*
    <?xml version="1.0" encoding="UTF-8"?>
    <!--Sample XML file generated by XMLSpy v2008 (http://www.altova.com)-->
    <filter:filter vhimVersion="String" filterType="VDM" xsi:schemaLocation="Filter Filter400C5.xsd" xmlns:filter="Filter" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
        <filterId>String</filterId>
        <patients>
            <resolvedIdentifiers>
                <identity>String</identity>
                <assigningAuthority>String</assigningAuthority>
                <assigningFacility>String</assigningFacility>
            </resolvedIdentifiers>
        </patients>
        <entryPointFilter queryName="text">
            <domainEntryPoint>String</domainEntryPoint>
            <startDate>1967-08-13</startDate>
            <endDate>1967-08-13</endDate>
            <recordIdentifiers>
                <identity>String</identity>
                <namespaceId>VHA</namespaceId>
                <universalId>String</universalId>
                <universalIdType>String</universalIdType>
            </recordIdentifiers>
            <xpathQuery>
                <xpath>String</xpath>
                <parameter type="text" name="text">
                    <value>String</value>
                </parameter>
            </xpathQuery>
        </entryPointFilter>
        <correlationFilter queryName="text">
            <xpathQuery>
                <xpath>String</xpath>
                <parameter type="text" name="text">
                    <value>String</value>
                </parameter>
            </xpathQuery>
        </correlationFilter>
        <aggregationFilter queryName="text">
            <xpathQuery>
                <xpath>String</xpath>
                <parameter type="text" name="text">
                    <value>String</value>
                </parameter>
            </xpathQuery>
        </aggregationFilter>
    </filter:filter>
     */
    protected String createIdentityDomainEntryPointFilter( List<Element> patients, DomainEntryPoint... domainEntryPoint )
    {
        int count = 1;
        StringBuffer xmlWorkBuffer = new StringBuffer( 0 );
        xmlWorkBuffer.append( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
        xmlWorkBuffer
                        .append( "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" );
        xmlWorkBuffer.append( "<filterId>Filter100</filterId>" );
        xmlWorkBuffer.append( "<patients> " );
        for ( Element patientIdentifier : patients )
        {
            xmlWorkBuffer.append( "<resolvedIdentifiers>" );
            xmlWorkBuffer.append( "<assigningAuthority>" );
            xmlWorkBuffer.append( patientIdentifier.elementText( "assigningAuthority" ) );
            xmlWorkBuffer.append( "</assigningAuthority>" );
            xmlWorkBuffer.append( "<assigningFacility>" );
            xmlWorkBuffer.append( patientIdentifier.elementText( "assigningFacility" ) );
            xmlWorkBuffer.append( "</assigningFacility>" );
            xmlWorkBuffer.append( "<identity>" );
            xmlWorkBuffer.append( patientIdentifier.elementText( "identity" ) );
            xmlWorkBuffer.append( "</identity>" );
            xmlWorkBuffer.append( "</resolvedIdentifiers> " );

        }
        xmlWorkBuffer.append( "</patients> " );
        for ( DomainEntryPoint domainEntry : domainEntryPoint )
        {
            xmlWorkBuffer.append( "<entryPointFilter queryName=\"TestQueryName" ).append( count++ ).append( "\"> " );
            xmlWorkBuffer.append( "<domainEntryPoint>" );
            xmlWorkBuffer.append( domainEntry.name() );
            xmlWorkBuffer.append( "</domainEntryPoint>" );
            xmlWorkBuffer.append( "</entryPointFilter> " );
        }
        xmlWorkBuffer.append( "</filter:filter>" );
        return xmlWorkBuffer.toString();
    }


    protected int countClinicalDataPatients( Document clinicalDataDocument )
    {
        List<Element> patients = clinicalDataDocument.getRootElement().elements( "patient" );
        return patients == null ? 0 : patients.size();
    }


    /**
     * This method creates a map of patients and their DomainEntryPoint data counts
     * The patient key is made up of concatenated source Ids from a TreeSet.
     * The TreeSet is used to always create the key the same no matter how the data is ordered in the clinical data object.
     */
    @SuppressWarnings( "unchecked" )
    protected ClinicalDataCount countAllPatientData( Document clinicalDataDocument )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        ClinicalDataCount clinicalDataCount = new ClinicalDataCount();
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> subjectMap = new HashMap<String, Map<String, Map<DomainEntryPoint, Integer>>>();
        clinicalDataCount.setDataCount( subjectMap );

        List<Element> patients = clinicalDataDocument.getRootElement().elements( "patient" );
        for ( Element clinicalDataPatient : patients )
        {
            TreeSet<String> sortedKey = new TreeSet<String>();
            String subjectKey = "";
            Map<String, Map<DomainEntryPoint, Integer>> sourceIdMap = new HashMap<String, Map<DomainEntryPoint, Integer>>();
            
            List<Element> resultantIdentifiers = clinicalDataPatient.elements("resultantIdentifiers");
            if(resultantIdentifiers == null || resultantIdentifiers.size()==0){
                resultantIdentifiers = clinicalDataPatient.elements("requestedResolvedIdentifiers");
            }
            
            for ( Element personIdentifier : resultantIdentifiers )
            {
                Map<DomainEntryPoint, Integer> domainDataMap = new HashMap<DomainEntryPoint, Integer>();
                String key = personIdentifier.elementText( "identity" ) + personIdentifier.elementText( "assigningFacility" ) + personIdentifier.elementText( "assigningAuthority" );
                sortedKey.add( key );
                int domainCounter = 0;
                List<Element> allergyAssessments = clinicalDataPatient.elements("allergyAssessments");
                for ( Element allergyAssessment : allergyAssessments )
                {
                    Element sourceId = allergyAssessment.element("patient").element( "identifier" );
                    if ( key.equals( sourceId.elementText( "identity" ) + sourceId.elementText( "assigningFacility" ) + sourceId.elementText( "assigningAuthority" ) ) )
                    {
                        domainCounter++ ;
                    }
                }
                domainDataMap.put( DomainEntryPoint.AllergyAssessment, domainCounter );
                domainCounter = 0;
                
                List<Element> intoleranceConditions = clinicalDataPatient.elements("intoleranceConditions");
                for ( Element intoleranceCondition : intoleranceConditions )
                {
                    Element sourceId = intoleranceCondition.element("patient").element( "identifier" );
                    if ( key.equals( sourceId.elementText( "identity" ) + sourceId.elementText( "assigningFacility" ) + sourceId.elementText( "assigningAuthority" ) ) )
                    {
                        domainCounter++ ;
                    }
                }
                domainDataMap.put( DomainEntryPoint.IntoleranceCondition, domainCounter );
                domainCounter = 0;
                
                List<Element> vitalSignObservationEvents = clinicalDataPatient.elements("vitalSignObservationEvents");
                for ( Element vitalSignObservationEvent : vitalSignObservationEvents )
                {
                    Element sourceId = vitalSignObservationEvent.element("patient").element( "identifier" );
                    if ( key.equals( sourceId.elementText( "identity" ) + sourceId.elementText( "assigningFacility" ) + sourceId.elementText( "assigningAuthority" ) ) )
                    {
                        domainCounter++ ;
                    }
                }
                domainDataMap.put( DomainEntryPoint.VitalSignObservationEvent, domainCounter );
                domainCounter = 0;
                
                List<Element> outpatientMedicationPromises = clinicalDataPatient.elements("outpatientMedicationPromises" );
                for ( Element outpatientMedicationPromise : outpatientMedicationPromises )
                {
                 
                    Element sourceId = outpatientMedicationPromise.element("patient").element( "identifier" );
                    if ( key.equals( sourceId.elementText( "identity" ) + sourceId.elementText( "assigningFacility" ) + sourceId.elementText( "assigningAuthority" ) ) )
                    {
                        domainCounter++ ;
                    }
                }
                domainDataMap.put( DomainEntryPoint.OutpatientMedicationPromise, domainCounter );
                domainCounter = 0;
                
                List<Element> labTestPromises = clinicalDataPatient.elements("labTestPromises" );
                for ( Element labTestPromise : labTestPromises )
                {
                    Element sourceId = labTestPromise.element("patient").element( "identifier" );
                    if ( key.equals( sourceId.elementText( "identity" ) + sourceId.elementText( "assigningFacility" ) + sourceId.elementText( "assigningAuthority" ) ) )
                    {
                        domainCounter++ ;
                    }
                }
                domainDataMap.put( DomainEntryPoint.LabTestPromise, domainCounter );

                sourceIdMap.put( key, domainDataMap );
            }
            for ( String key : sortedKey )
            {
                subjectKey += key;
            }
            subjectMap.put( subjectKey, sourceIdMap );
        }

        return clinicalDataCount;
    }

}
