

package gov.va.med.cds.vdm.vhim400.integration;


import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.integration.AbstractEndToEndOutpatientPharmacyTest;
import gov.va.med.cds.integration.ErrorSectionCheckerInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.vdm.vhim400.basedatatypes.BaseDatatypesBuilder;
import gov.va.med.cds.vdm.vhim400.basedatatypes.HL72PersonIdentifier;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ClinicalData;
import gov.va.med.cds.vdm.vhim400.clinicaldata.VdmClinicalDataBuilder;
import gov.va.med.cds.vdm.vhim400.common.ClinicalDataPatient;
import gov.va.med.cds.vdm.vhim400.pharmacy.OutpatientMedicationPromise;
import gov.va.med.cds.vdm.vhim400.pharmacy.VdmOutpatientMedicationPromiseBuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.ParserConfigurationException;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.xml.sax.SAXException;


/**
 *
 * This is a vhim version specific class and initiates all tests through the outermost client pojo
 * (ClinicalDataServiceSynchronous). See the super abstract class documentation. TODO:The first pass refcatoring of
 * moving vhim version dependencies to subclasses is done. Thus need to do second pass refactoring of keeping common
 * code in one place.
 *
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = {"classpath:gov/va/med/cds/vdm/vhim400/marshal/vdm400TestContext.xml"})
public class EndToEndOutpatientPharmacyV400Test
{
  //until more refactoring happens provide empty test method so test is not in ERROR - this test will not run for a build
    @Test
    @Suite(groups="prototypetest") // test used only to avoid initialization errors when class loads without at least one test method.
    public void testEmpty( )
    {
        Assert.assertTrue(true);
    }
    
    //TODO rework logic to use dom4j data building - replace all marshalling logic ...
    //TODO this class extends AbstractEndToEndOutpatientPharmacyTest but the extends is removed on this first pass
    //so it will compile - the extended methods in AbstractEndToEndOutpatientPharmacyTest will need reworking.
    
    //private MarshallerUnmarshallerInterface marshallerUnmarshaller400 = null;
    private VdmClinicalDataBuilder vdmClinicalDataBuilder400;
    private ErrorSectionCheckerInterface errorSectionChecker400 = null;
    
    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testOutpatientMedicationPromiseWithCommentsCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testOutpatientMedicationPromiseWithCommentsCreateReadXmlCompareDelete();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryDateNWithoutCancelDate( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryDateNWithoutCancelDate();
//    }
    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateBeforeExpiryDate( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateBeforeExpiryDate();
//    }
//    
    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterExpiryDate( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterExpiryDate();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterFilterDateRangeNExpiryDateInFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterFilterDateRangeNExpiryDateInFilterDateRange();
//    }
//    
// 
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryDateAfterFilterDateRangeNCancelDateInFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryDateAfterFilterDateRangeNCancelDateInFilterDateRange();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryBeforeFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryBeforeFilterDateRange();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryDateAfterFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryDateAfterFilterDateRange();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateBeforeExpiryNBeforeFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateBeforeExpiryNBeforeFilterDateRange();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateBeforeExpiryNAfterFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateBeforeExpiryNAfterFilterDateRange();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterExpiryNBeforeFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterExpiryNBeforeFilterDateRange();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterExpiryNAfterFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterExpiryNAfterFilterDateRange();
//    }
//    
//    
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testOutpatientMedicationPromiseWithDispensesCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testOutpatientMedicationPromiseWithDispensesCreateReadXmlCompareDelete();
//    }
//    

    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#getOutpatientMedicationPromiseFilterId()
     */
    protected String getOutpatientMedicationPromiseFilterId( )
    {
        return "Filter100";
    }


    /**
     * Used to modify the metadata of the given xml to reflect the CRUAD template ids. This helps in reusing a given xml
     * instead of creating CRUD request related xmls from scratch.
     */
//    protected String modifyTemplateMetaDataOfCRUADResultXml( String templateId, String xml, String domainName )
//    {
//        ClinicalData workClinicalData = ClinicaldataFactory.INSTANCE.createClinicalData();
//        workClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        workClinicalData.setTemplateId( templateId );
//
//        return marshallerUnmarshaller400.marshallToXml( workClinicalData, templateId );
//    }



    /**
     * Creates a VDM IntoleranceCondition from VdmBuilder with non-null identity and marshalls it into xml.
     */
    protected String createOutpatientMedicationPromiseXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );

        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patient );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM Rx with specific dispense count by calling directly the RxVdmBuilder with non-null identity and
     * marshalls it into xml. Uses vdmclinicaldatabuiler call chain for the inital creation of Rx and later calls the Rx
     * vdmbuilder to add more dispenses; thus vdmclinicaldatabuilder flow is not affected.
     */
    protected String createOutpatientMedicationPromiseWithSpecificDispensesXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );

        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patientId );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        // get the above created Rx and add more dispenses
        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );

        VdmOutpatientMedicationPromiseBuilder vdmPharmacyBuilder = new VdmOutpatientMedicationPromiseBuilder();
        // 'All' value implies creating both refill and partial refills of count 3
        outpatientMedicationPromise = vdmPharmacyBuilder.makePharmacyWithDispenses( outpatientMedicationPromise, "All", 3 );

        return marshalToXml( vdmClinicalDataInsert );

    }


    /**
     * Creates Rx with given cancelYear and expiration year
     */
    protected String createOutpatientMedicationPromiseWithExpiryCancelDatesXml( String aRequestId, int cancelDateYearOffset, int expirationDateYearOffset )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );

        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patientId );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        // get the above created Rx and add cancel and expiry date
        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );

        VdmOutpatientMedicationPromiseBuilder vdmPharmacyBuilder = new VdmOutpatientMedicationPromiseBuilder();
        outpatientMedicationPromise = vdmPharmacyBuilder.makePharmacyWithCancelDateNExpiryDate( outpatientMedicationPromise, cancelDateYearOffset,
                        expirationDateYearOffset );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM Rx with expanded patient comments and provider comments of size 8k by calling directly the
     * RxVdmBuilder with non-null identity and marshalls it into xml. Uses vdmclinicaldatabuiler call chain for the
     * inital creation of Rx and later calls the Rx vdmbuilder to add more dispenses; thus vdmclinicaldatabuilder flow
     * is not affected.
     */
//    protected String createOutpatientMedicationPromiseWithCommentsXml( String aRequestId )
//        throws IOException
//    {
//        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
//        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );
//
//        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
//        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
//                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patientId );
//        vdmClinicalDataInsert.setRequestId( aRequestId );
//
//        // get the above created Rx and add more comments
//        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
//        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );
//
//        //outpatientMedicationPromise.setExpandedPatientInstructions( COMMENT_8K_SIZE );
//
//        VdmOutpatientMedicationPromiseBuilder vdmPharmacyBuilder = new VdmOutpatientMedicationPromiseBuilder();
//        // 'All' value implies creating both refill and partial refills of count 3
//        outpatientMedicationPromise = vdmPharmacyBuilder.makePharmacyWithCurrentProviderComments( outpatientMedicationPromise, COMMENT_8K_SIZE );
//
//        return marshalToXml( vdmClinicalDataInsert );
//
//    }


    /**
     * Marshal VDM ClinicalData to VHIM compliant XML
     *
     * @param aClinicalData
     */
    protected String marshalToXml( ClinicalData aClinicalData )
    {
//        String marshalledXml = marshallerUnmarshaller400.marshallToXml( aClinicalData, aClinicalData.getTemplateId() );
//
//        return marshalledXml;
        return null;
    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#unmarshallAndCompare(java.lang.String,
     * java.lang.String)
     */
//    protected void unmarshallAndCompare( String controlXml, String resultXml )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        ClinicalData clinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( controlXml );
//        String templateId = clinicalData.getTemplateId();
//        String requestId = clinicalData.getRequestId();
//
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( resultXml );
//        errorSectionChecker400.assertNoErrors( responseClinicalData );
//
//        // Prep for comparison
//        responseClinicalData.setTemplateId( templateId );
//        responseClinicalData.setRequestId( requestId );
//        String sourceXml = marshallerUnmarshaller400.marshallToXml( responseClinicalData, templateId );
//
//        // data element compare
//        XmlComparator.assertXMLSimilar( sourceXml, controlXml );
//    }


    /*
     * (non-Javadoc)
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromOutpatientMedicationPromise(java.lang
     * .String)
     */
//    protected String createXpathFilterFromOutpatientMedicationPromise( String xml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );
//
//        String xpath = "outpatientMedicationPromises[recordIdentifier/universalId='"
//                        + outpatientMedicationPromise.getRecordIdentifier().getUniversalId() + "']";
//
//        return createXpathFilter( outpatientMedicationPromise.getPatient().getIdentifier(), "OutpatientMedicationPromiseQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.OutpatientMedicationPromise.toString(), null, null );
//    }


    /*
     * creates the filter with given start and end dates.
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromOutpatientMedicationPromise(java.lang
     * .String)
     */
//    protected String createXpathFilterFromOutpatientMedicationPromise( String xml, Date aStartDate, int aEndDate )
//        throws DatatypeConfigurationException
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );
//
//        String xpath = "outpatientMedicationPromises[recordIdentifier/universalId='"
//                        + outpatientMedicationPromise.getRecordIdentifier().getUniversalId() + "']";
//
//        Calendar filterStartDate = convertDateToCalendar( aStartDate );
//        Calendar filterEndDate = convertDateToCalendar( getFilterEndDate( aEndDate ) );
//
//        return createXpathFilter( outpatientMedicationPromise.getPatient().getIdentifier(), "OutpatientMedicationPromiseQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.OutpatientMedicationPromise.toString(), filterStartDate, filterEndDate );
//    }



    /**
     * Creates endDate of a filter
     *
     * @param endDate
     * @return Date
     * @see createXpathFilterFromOutpatientMedicationPromise
     */

    private static Date getFilterEndDate( int endDate )
    {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.add( Calendar.YEAR, endDate );
        int newYear = sysDate.get( Calendar.YEAR );
        GregorianCalendar newDate = new GregorianCalendar( newYear, Calendar.MONTH, 01 );
        Date endDt = newDate.getTime();
        return endDt;

    }


//    protected static String createXpathFilter( HL72PersonIdentifier aHL72PersonIdentifier, String aQueryName, String aXpath,
//                    String aDomainEntryPoint, Calendar aStartDate, Calendar aEndDate )
//    {
//        PersonIdentifier patientIdentifier = new PersonIdentifier();
//        patientIdentifier.setIdentity( aHL72PersonIdentifier.getIdentity() );
//        patientIdentifier.setAssigningAuthority( aHL72PersonIdentifier.getAssigningAuthority() );
//        patientIdentifier.setAssigningFacility( aHL72PersonIdentifier.getAssigningFacility() );
//        ArrayList<PersonIdentifierInterface> resolvedIds = new ArrayList( 1 );
//        resolvedIds.add( patientIdentifier );
//
//        // List<EntryFilter> entryFilters = new ArrayList( 1 );
//        List<String> entryFilters = new ArrayList<String>( 2 );
//        String entryFilter1 = createEntryFilter(aQueryName, aDomainEntryPoint, aStartDate, aEndDate, aXpath);
//        entryFilters.add( entryFilter1 );
//
//        String entryFilter2 = createEntryFilter(aQueryName+"2", aDomainEntryPoint, aStartDate, aEndDate, aXpath);
//        entryFilters.add( entryFilter2 );
//
//        return createFilter( resolvedIds, entryFilters );
//    }


    /**
     * Checks that there are no errors in the result xml
     */
//    protected void checkForNoErrorsInXml( String aResultXml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( aResultXml );
//        errorSectionChecker400.assertNoErrors( responseClinicalData );
//    }


    /**
     * Used in Spring injection
     *
     * @param marshallerUnmarshaller
     */
    // @Test( enabled = false )  - TODO: Remove these comments. The only reason that I'm keeping them around is because I'm not sure what removing them will do.
    @Resource
//    public void setMarshallerUnmarshaller400( MarshallerUnmarshallerInterface marshallerUnmarshaller )
//    {
//        this.marshallerUnmarshaller400 = marshallerUnmarshaller;
//    }


    /**
     * Used in Spring injection
     *
     * @param vdmClinicalDataBuilder400
     */
    //@Test( enabled = false )
//    @Resource
//    public void setVdmClinicalDataBuilder400( VdmClinicalDataBuilder vdmClinicalDataBuilder400 )
//    {
//        this.vdmClinicalDataBuilder400 = vdmClinicalDataBuilder400;
//    }


    /**
     * Used in Spring injection
     *
     * @param errorSectionChecker400
     */
    //@Test( enabled = false )
//    @Resource
//    public void setErrorSectionChecker400( ErrorSectionCheckerInterface errorSectionChecker400 )
//    {
//        this.errorSectionChecker400 = errorSectionChecker400;
//    }


    /**
     * This return ensures the user string is conformant to at least the following rules: - All characters must be
     * numeric for the iso conversion
     *
     * @param observationDate
     * @return String
     */
    private String isNonConformatString( String observationDate )
    {
        for ( int index = 0; index < observationDate.length(); index++ )
        {
            char isoDateCharacter = observationDate.charAt( index );
            if ( !( isoDateCharacter <= '9' && isoDateCharacter >= '0' ) )
            {
                return null;
            }
        }
        observationDate = observationDate.length() > 7 ? observationDate.substring( 0, 8 ) : "00000000";
        return observationDate;
    }


}
