

package gov.va.med.cds.vdm.vhim400.integration;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.integration.AbstractEndToEndErrorHandlingUseCasesTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.vdm.vhim400.allergies.IntoleranceCondition;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ClinicalData;
import gov.va.med.cds.vdm.vhim400.clinicaldata.VdmClinicalDataBuilder;
import gov.va.med.cds.vdm.vhim400.clinicaldata.VdmClinicalDataTestHelper;

import java.io.IOException;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
//@ContextConfiguration( locations = { "classpath:gov/va/med/cds/vdm/vhim400/marshal/vdm400TestContext.xml",
//                "classpath:gov/va/med/cds/config/nonWeblogicHxDataSourceContext.xml" } )
public class EndToEndErrorHandlingUseCasesV400Test
    extends
        AbstractEndToEndErrorHandlingUseCasesTest
{
   //TODO rework logic to use dom4j data building - replace all marshalling logic ...
    
    private static final String INVALID_FILTER = "JUNK_Filter";
    private static final String INVALID_TEMPLATE_ID = "JUNK_READ_TEMPLATE_ID";

    private VdmClinicalDataBuilder vdmClinicalDataBuilder = null;
    //private MarshallerUnmarshallerInterface marshallerUnmarshaller;


    /**
     * ExceptionHandlingSpreadsheet: A null templateId in a read request: is a Fatal Error. returns a message to the
     * client. logs internally.
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testNullTemplateIdReadRequest( )
    {
        super.testNullTemplateIdReadRequest();
    }


    /**
     * ExceptionHandlingSpreadsheet: A null filter in a read request: is a Fatal Error. returns a message to the client.
     * logs internally.
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testNullFilterXmlReadRequest( )
    {
        super.testNullFilterXmlReadRequest();
    }


    /**
     * ExceptionHandlingSpreadsheet: A null write request: is a Fatal Error. returns a message to the client. logs to
     * internally.
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testNullXmlWriteRequest( )
    {
        super.testNullXmlWriteRequest();
    }


    /**
     * ExceptionHandlingSpreadsheet: A write request does not contain a valid template id: is a Fatal Error. returns a
     * message to the client. logs internally.
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testInvalidTemplateIdWriteRequest( )
        throws IOException
    {
        super.testInvalidTemplateIdWriteRequest();
    }


    /**
     * ExceptionHandlingSpreadsheet: A read request does not contain a valid template id: is a Fatal Error. returns a
     * message to the client. logs internally.
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testInvalidTemplateIdReadRequest( )
    {
        super.testInvalidTemplateIdReadRequest();
    }


    /**
     * ExceptionHandlingSpreadsheet: A read request does not contain a valid filter xml: is a Fatal Error. returns a
     * message to the client.logs internally.
     * @throws IOException 
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testInvalidFilterXmlReadRequest( )
    {
        super.testInvalidFilterXmlReadRequest();
    }


    /**
     * ExceptionHandlingSpreadsheet: A write request does not contain something that is required: is a Fatal Error.
     * returns a message to the client.  logs internally.
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testIntegrityConstraintViolationWriteRequest( )
        throws Exception
    {
        super.testIntegrityConstraintViolationWriteRequest();
    }


    /**
     * ExceptionHandlingSpreadsheet: A delete request does not contain a valid identity: is a Fatal Error. returns a
     * message to the client.  logs internally.
     */
    @Override
    @Test
    @Suite( groups = { "brokentest" } )
    public void testBadIdentityDeleteRequest( )
        throws Exception
    {
        super.testBadIdentityDeleteRequest();
    }


    /**
     * This method checks for a particular errorcode and type in the fatal list. Then rebuilds a VDM object and checks
     * values.
     *
     * @param cdsException exception class we are looking for
     * @param errorCode the enum of the error we're looking for
     * @param responseXml xml that was marshaled
     * @param checkDisplayMessage used to compare the display message and client message of the error
     */
    @SuppressWarnings( "unchecked" )
    protected void compareFatalException( Class cdsException, ErrorCodeEnum errorCode, String responseXml, boolean checkDisplayMessage )
    {

        //ClinicalData vdmClinicalData = ( ClinicalData )( marshallerUnmarshaller.unmarshallToVdm( responseXml ) );
        logger.debug( "EndToEndErrorHandlingUseCasesV400Test" );
        //ErrorSection errorSection = vdmClinicalData.getErrorSection();
//        assertNotNull( errorSection );
//        assertEquals( errorSection.getErrors().size(), 0 );
//        assertEquals( errorSection.getFatalErrors().size(), 1 );
//        assertEquals( errorSection.getWarnings().size(), 0 );
//
//        Error error = ( Error )errorSection.getFatalErrors().get( 0 );
//        assertEquals( error.getException(), cdsException.getName() );
//        assertNotNull( error.getExceptionMessage() );
//        assertFalse( error.getExceptionMessage().equals( "" ) );
//        // assertEquals( error.getErrorCode(), errorCode.toString() );
//        assertNotNull( error.getDisplayMessage() );
//
//        // Most display messages contain dynamic processing input and therefore cannot be easily verified.
//        if ( checkDisplayMessage )
//        {
//            assertEquals( error.getDisplayMessage(), errorCode.getClientMessage() );
//        }
//
//        assertNotNull( error.getErrorId() );
    }


    @Override
    protected String createBadFilter( )
    {
        return INVALID_FILTER;
    }


    @Override
    protected String createBadIdentityDeleteRequest( )
    {
        ClinicalData clinicalData = ( ClinicalData )vdmClinicalDataBuilder
                        .createClinicalData( TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID );
        String templateId = clinicalData.getTemplateId();
        //String deleteRequest = marshallerUnmarshaller.marshallToXml( clinicalData, templateId );

        //return deleteRequest;
        return null;
    }


    @Override
    protected String createBadIdentityDeleteRequestTemplateId( )
    {
        ClinicalData clinicalData = ( ClinicalData )vdmClinicalDataBuilder
                        .createClinicalData( TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID );
        String templateId = clinicalData.getTemplateId();

        return templateId;
    }


    @SuppressWarnings( "unchecked" )
    @Override
    protected String createIntegrityConstraintViolationWriteRequest( )
    {
        ClinicalData clinicalData = ( ClinicalData )vdmClinicalDataBuilder.createClinicalData(
                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID, 1 );
        IntoleranceCondition ic = VdmClinicalDataTestHelper.getFirstPatientFirstIntoleranceCondition( clinicalData.getPatient() );
        // this was setSourceId( null ) in v 3.6.2 - not sure if this is the right replacement.
        ic.getPatient().setIdentifier( null );
        //String writeXml = marshallerUnmarshaller.marshallToXml( clinicalData, clinicalData.getTemplateId() );

        //return writeXml;
        return null;
    }


    @Override
    protected String createIntegrityConstraintViolationWriteRequestTemplateId( )
    {
        ClinicalData clinicalData = ( ClinicalData )vdmClinicalDataBuilder.createClinicalData(
                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID, 1 );

        return clinicalData.getTemplateId();
    }


    @Override
    protected String createInvalidReadFilter( )
    {
        return INVALID_FILTER;
    }


    @Override
    protected String createValidReadTemplateId( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
    }


    @Override
    protected String createInvalidTemplateId( )
    {
        return INVALID_TEMPLATE_ID;
    }


    @Override
    protected String createInvalidTemplateIdWriteRequest( )
    {
        ClinicalData clinicalData = ( ClinicalData )vdmClinicalDataBuilder.createClinicalData(
                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID, 1 );
        String templateId = clinicalData.getTemplateId();
        //String writeXml = marshallerUnmarshaller.marshallToXml( clinicalData, templateId );
        //writeXml = writeXml.replaceFirst( "templateId=\"" + templateId + "\"", "templateId=\"veryBadTemplateId\"" );
        //return writeXml;
        return null;
    }


//    @Resource
//    public void setMarshallerUnmarshaller400( MarshallerUnmarshallerInterface marshallerUnmarshaller )
//    {
//        this.marshallerUnmarshaller = marshallerUnmarshaller;
//    }


//    @Resource
//    public void setVdmClinicalDataBuilder400( VdmClinicalDataBuilder vdmBuilder )
//    {
//        this.vdmClinicalDataBuilder = vdmBuilder;
//    }

    @AfterTestsOnce
    @Suite( groups = { "slowtest" } )
    public void afterEndToEndErrorHandlingUseCasesV400TestMethodTearDown( )
    {
        //marshallerUnmarshaller = null;
        //vdmClinicalDataBuilder = null;
    }
}
