

package gov.va.med.cds.vdm.vhim400.integration;


import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.integration.ErrorSectionCheckerInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.vdm.vhim400.allergies.IntoleranceCondition;
import gov.va.med.cds.vdm.vhim400.allergies.VdmIntoleranceConditionBuilder;
import gov.va.med.cds.vdm.vhim400.basedatatypes.BaseDatatypesBuilder;
import gov.va.med.cds.vdm.vhim400.basedatatypes.HL72PersonIdentifier;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ClinicalData;
import gov.va.med.cds.vdm.vhim400.clinicaldata.VdmClinicalDataBuilder;
import gov.va.med.cds.vdm.vhim400.common.ClinicalDataPatient;
import gov.va.med.cds.vdm.vhim400.pharmacy.OutpatientMedicationPromise;
import gov.va.med.cds.vdm.vhim400.pharmacy.VdmOutpatientMedicationPromiseBuilder;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.datatype.XMLGregorianCalendar;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


/**
 *
 * This is a vhim version specific class and initiates all tests through the outermost client pojo
 * (ClinicalDataServiceSynchronous). See the super abstract class documentation. TODO:The first pass refcatoring of
 * moving vhim version dependencies to subclasses is done. Thus need to do second pass refactoring of keeping common
 * code in one place.
 *
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/vdm/vhim400/marshal/vdm400TestContext.xml" } )
public class EndToEndCRUADAutoWiredV400Test
{
  
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";

    //until more refactoring happens provide empty test method so test is not in ERROR - this test will not run for a build
    @Test
    @Suite(groups="prototypetest") // test used only to avoid initialization errors when class loads without at least one test method.
    public void testEmpty( )
    {
        Assert.assertTrue(true);
    }
    //TODO rework logic to use dom4j data building - replace all marshalling logic ...
    
    //TODO the class should extend AbstractEndToEndCRUADAutoWiredTest but the extends was removed
    //so we can compile on the first refactor pass - the AbstractEndToEndCRUADAutoWiredTest must be
    //reworked so that the methods return dom4j - and not objects, etc.
    
//    private static final DateFormat DATE_FORMAT = ;
    //private MarshallerUnmarshallerInterface marshallerUnmarshaller400 = null;
    private VdmClinicalDataBuilder vdmClinicalDataBuilder400;
    private ErrorSectionCheckerInterface errorSectionChecker400 = null;
    private static final String APPLICATION_NAME = "CDS";
    private static final String COMMENT_8K_SIZE = "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz";


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testAllergyAssessmentCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testAllergyAssessmentCreateReadXmlCompareDelete();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testIntoleranceConditionCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testIntoleranceConditionCreateReadXmlCompareDelete();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testIntoleranceConditionWithCommentEventCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testIntoleranceConditionWithCommentEventCreateReadXmlCompareDelete();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testVitalObservationEventCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testVitalObservationEventCreateReadXmlCompareDelete();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testOutpatientMedicationPromiseWithCommentsCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testOutpatientMedicationPromiseWithCommentsCreateReadXmlCompareDelete();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryDateNWithoutCancelDate( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryDateNWithoutCancelDate();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateBeforeExpiryDate( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateBeforeExpiryDate();
//    }

//
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterExpiryDate( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterExpiryDate();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterFilterDateRangeNExpiryDateInFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterFilterDateRangeNExpiryDateInFilterDateRange();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryDateAfterFilterDateRangeNCancelDateInFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryDateAfterFilterDateRangeNCancelDateInFilterDateRange();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryBeforeFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryBeforeFilterDateRange();
//    }

//
//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithExpiryDateAfterFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithExpiryDateAfterFilterDateRange();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateBeforeExpiryNBeforeFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateBeforeExpiryNBeforeFilterDateRange();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateBeforeExpiryNAfterFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateBeforeExpiryNAfterFilterDateRange();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterExpiryNBeforeFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterExpiryNBeforeFilterDateRange();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testRxWithCancelDateAfterExpiryNAfterFilterDateRange( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException,
//            DatatypeConfigurationException
//    {
//        super.testRxWithCancelDateAfterExpiryNAfterFilterDateRange();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testOutpatientMedicationPromiseWithDispensesCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testOutpatientMedicationPromiseWithDispensesCreateReadXmlCompareDelete();
//    }


//    @Override
//    @Test
//    @Suite( groups = { "brokentest" } )
//    public void testLabPromiseCreateReadXmlCompareDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testLabPromiseCreateReadXmlCompareDelete();
//    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#getAllergyAssessmentFilterId()
     */
    protected String getAllergyAssessmentFilterId( )
    {
        return "Filter100";
    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#getIntoleranceConditionFilterId()
     */
    protected String getIntoleranceConditionFilterId( )
    {
        return "Filter100";
    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#getVitalObservationEventFilterId()
     */
    protected String getVitalObservationEventFilterId( )
    {
        return "Filter100";
    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#getOutpatientMedicationPromiseFilterId()
     */
    protected String getOutpatientMedicationPromiseFilterId( )
    {
        return "Filter100";
    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#getLabFilterId()
     */
    protected String getLabFilterId( )
    {
        return "Filter100";
    }


    /**
     * Used to modify the metadata of the given xml to reflect the CRUAD template ids. This helps in reusing a given xml
     * instead of creating CRUD request related xmls from scratch.
     */
//    protected String modifyTemplateMetaDataOfCRUADResultXml( String templateId, String xml, String domainName )
//    {
//        ClinicalData workClinicalData = ClinicaldataFactory.INSTANCE.createClinicalData();
//        workClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        workClinicalData.setTemplateId( templateId );
//
//        return marshallerUnmarshaller400.marshallToXml( workClinicalData, templateId );
//    }


    /**
     * Creates a VDM IntoleranceCondition from VdmBuilder with non-null identity and marshalls it into xml.
     */
    protected String createAllergyAssessmentXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "allergyAssessmentTest", "allergyAssessmentTest" );

        // Hx will be read but no matches will be found. This will allow the entire create/read/compare/delete to be
        // applied to HDR2.
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.ALLERGY_ASSESSMENT_CREATE_TEMPLATE_ID, 1, patient );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM IntoleranceCondition from VdmBuilder with non-null identity and marshalls it into xml.
     */
    protected String createIntoleranceConditionXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "intoleranceConditionTest", "intoleranceConditionTest" );

        // Hx will be read but no matches will be found. This will allow the entire create/read/compare/delete to be
        // applied to HDR2.
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID, 1, patient );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM IntoleranceCondition with commentevent.comment as 8k size from VdmBuilder with non-null identity
     * and marshalls it into xml.
     */
    protected String createIntoleranceConditionWithCommentEventXml( String aRequestId )
        throws IOException
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "intoleranceConditionTest", "intoleranceConditionTest" );

        // Hx will be read but no matches will be found. This will allow the entire create/read/compare/delete to be
        // applied to HDR2.
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID, 1, patientId );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        // get the above created Rx and add more dispenses
        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
        IntoleranceCondition intoleranceCondition = ( IntoleranceCondition )patient.getIntoleranceConditions().get( 0 );

        VdmIntoleranceConditionBuilder vdmICBuilder = new VdmIntoleranceConditionBuilder();
        // add a commentevent.comment of 8k size
        intoleranceCondition = vdmICBuilder.makeAllergyWithCommentEvent( intoleranceCondition, COMMENT_8K_SIZE );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM IntoleranceCondition from VdmBuilder with non-null identity and marshalls it into xml.
     */
    protected String createVitalObservationEventXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "vitalSignTest", "vitalSignTest" );

        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.VITALSIGNS_CREATE_TEMPLATE_ID, 1, patient );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM IntoleranceCondition from VdmBuilder with non-null identity and marshalls it into xml.
     */
    protected String createOutpatientMedicationPromiseXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );

        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patient );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM Rx with specific dispense count by calling directly the RxVdmBuilder with non-null identity and
     * marshalls it into xml. Uses vdmclinicaldatabuiler call chain for the inital creation of Rx and later calls the Rx
     * vdmbuilder to add more dispenses; thus vdmclinicaldatabuilder flow is not affected.
     */
    protected String createOutpatientMedicationPromiseWithSpecificDispensesXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );

        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patientId );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        // get the above created Rx and add more dispenses
        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );

        VdmOutpatientMedicationPromiseBuilder vdmPharmacyBuilder = new VdmOutpatientMedicationPromiseBuilder();
        // 'All' value implies creating both refill and partial refills of count 3
        outpatientMedicationPromise = vdmPharmacyBuilder.makePharmacyWithDispenses( outpatientMedicationPromise, "All", 3 );

        return marshalToXml( vdmClinicalDataInsert );

    }


    /**
     * Creates Rx with given cancelYear and expiration year
     */
    protected String createOutpatientMedicationPromiseWithExpiryCancelDatesXml( String aRequestId, int cancelYear, int expirationYear )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );

        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patientId );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        // get the above created Rx and add cancel and expiry date
        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );

        VdmOutpatientMedicationPromiseBuilder vdmPharmacyBuilder = new VdmOutpatientMedicationPromiseBuilder();
        outpatientMedicationPromise = vdmPharmacyBuilder.makePharmacyWithCancelDateNExpiryDate( outpatientMedicationPromise, cancelYear,
                        expirationYear );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Creates a VDM Rx with expanded patient comments and provider comments of size 8k by calling directly the
     * RxVdmBuilder with non-null identity and marshalls it into xml. Uses vdmclinicaldatabuilder call chain for the
     * inital creation of Rx and later calls the Rx vdmbuilder to add more dispenses; thus vdmclinicaldatabuilder flow
     * is not affected.
     */
    @SuppressWarnings( "unchecked" )
    protected String createOutpatientMedicationPromiseWithCommentsXml( String aRequestId )
        throws IOException
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "outpatientPharmacyTest", "outpatientPharmacyTest" );

        // creates one pharmacy record with default of 2 of each of refill and partial dispenses records
        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
                        TemplateIdHelper.PHARMACY_CREATE_TEMPLATE_ID, 1, patientId );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        // get the above created Rx and add more comments
        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );

        outpatientMedicationPromise.getExpandedPatientInstructions().add( COMMENT_8K_SIZE + "1" );
        outpatientMedicationPromise.getExpandedPatientInstructions().add( COMMENT_8K_SIZE + "2" );

        VdmOutpatientMedicationPromiseBuilder vdmPharmacyBuilder = new VdmOutpatientMedicationPromiseBuilder();
        // 'All' value implies creating both refill and partial refills of count 3
        outpatientMedicationPromise = vdmPharmacyBuilder.makePharmacyWithCurrentProviderComments( outpatientMedicationPromise, COMMENT_8K_SIZE );

        return marshalToXml( vdmClinicalDataInsert );

    }


    /**
     * Creates a VDM Lab from VdmBuilder with non-null identity and marshalls it into xml.
     */
    protected String createLabXml( String aRequestId )
    {
        // Start with a dynamically created xml instance. The Vdm builder has already been tested.
        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier( "labTest", "labTest" );

        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData( TemplateIdHelper.LAB_CREATE_TEMPLATE_ID,
                        1, patientId );
        vdmClinicalDataInsert.setRequestId( aRequestId );

        return marshalToXml( vdmClinicalDataInsert );
    }


    /**
     * Marshal VDM ClinicalData to VHIM compliant XML
     *
     * @param aClinicalData
     */
    protected String marshalToXml( ClinicalData aClinicalData )
    {
//        String marshalledXml = marshallerUnmarshaller400.marshallToXml( aClinicalData, aClinicalData.getTemplateId() );
//
//        return marshalledXml;
        return null;
    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#unmarshallAndCompare(java.lang.String,
     * java.lang.String)
     */
//    protected void unmarshallAndCompare( String controlXml, String resultXml )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        ClinicalData clinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( controlXml );
//        String templateId = clinicalData.getTemplateId();
//        String requestId = clinicalData.getRequestId();
//
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( resultXml );
//        errorSectionChecker400.assertNoErrors( responseClinicalData );
//
//        // Prep for comparison
//        responseClinicalData.setTemplateId( templateId );
//        responseClinicalData.setRequestId( requestId );
//        String sourceXml = marshallerUnmarshaller400.marshallToXml( responseClinicalData, templateId );
//
//        // data element compare
//        XmlComparator.assertXMLSimilar( sourceXml, controlXml );
//    }


    /*
     * (non-Javadoc)
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromAllergyAssessment(java.lang.String)
     */
//    protected String createXpathFilterFromAllergyAssessment( String xml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        AllergyAssessment allergyAssessment = ( AllergyAssessment )patient.getAllergyAssessments().get( 0 );
//
//        String xpath = "allergyAssessments[recordIdentifier/universalId='" + allergyAssessment.getRecordIdentifier().getUniversalId() + "']";
//
//        return createXpathFilter( allergyAssessment.getPatient().getIdentifier(), "AllergyAssessmentQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.AllergyAssessment.toString(), null, null );
//    }


    /*
     * (non-Javadoc)
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromIntoleranceCondition(java.lang.String)
     */
//    protected String createXpathFilterFromIntoleranceCondition( String xml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        IntoleranceCondition intoleranceCondition = ( IntoleranceCondition )patient.getIntoleranceConditions().get( 0 );
//
//        String xpath = "intoleranceConditions[recordIdentifier/universalId='" + intoleranceCondition.getRecordIdentifier().getUniversalId() + "']";
//
//        return createXpathFilter( intoleranceCondition.getPatient().getIdentifier(), "IntoleranceConditionQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.IntoleranceCondition.toString(), null, null );
//    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromLab(java.lang.String)
     */
//    protected String createXpathFilterFromLab( String xml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        LabTestPromise labTestPromise = ( LabTestPromise )patient.getLabTestPromises().get( 0 );
//
//        String xpath = "labTestPromises[recordIdentifier/universalId='" + labTestPromise.getRecordIdentifier().getUniversalId() + "']";
//
//        return createXpathFilter( labTestPromise.getPatient().getIdentifier(), "LabTestPromiseQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.LabTestPromise.toString(), null, null );
//    }


    /*
     * (non-Javadoc)
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromVitalObservationEvent(java.lang.String
     * )
     */
//    protected String createXpathFilterFromVitalObservationEvent( String xml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        VitalSignObservationEvent vitalSignObservationEvent = ( VitalSignObservationEvent )patient.getVitalSignObservationEvents().get( 0 );
//
//        String xpath = "vitalSignObservationEvents[recordIdentifier/universalId='" + vitalSignObservationEvent.getRecordIdentifier().getUniversalId()
//                        + "']";
//
//        return createXpathFilter( vitalSignObservationEvent.getPatient().getIdentifier(), "VitalSignObservationEventQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.VitalSignObservationEvent.toString(), null, null );
//    }


    /*
     * (non-Javadoc)
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromOutpatientMedicationPromise(java.lang
     * .String)
     */
//    protected String createXpathFilterFromOutpatientMedicationPromise( String xml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );
//
//        String xpath = "outpatientMedicationPromises[recordIdentifier/universalId='"
//                        + outpatientMedicationPromise.getRecordIdentifier().getUniversalId() + "']";
//
//        return createXpathFilter( outpatientMedicationPromise.getPatient().getIdentifier(), "OutpatientMedicationPromiseQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.OutpatientMedicationPromise.toString(), null, null );
//    }


    /*
     * creates the filter with given start and end dates.
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromOutpatientMedicationPromise(java.lang
     * .String)
     */
//    protected String createXpathFilterFromOutpatientMedicationPromise( String xml, Date aStartDate, int aEndDate )
//        throws DatatypeConfigurationException
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        OutpatientMedicationPromise outpatientMedicationPromise = ( OutpatientMedicationPromise )patient.getOutpatientMedicationPromises().get( 0 );
//
//        String xpath = "outpatientMedicationPromises[recordIdentifier/universalId='"
//                        + outpatientMedicationPromise.getRecordIdentifier().getUniversalId() + "']";
//
//        Calendar filterStartDate = convertDateToCalendar( aStartDate );
//        Calendar filterEndDate = convertDateToCalendar( getFilterEndDate( aEndDate ) );
//
//        return createXpathFilter( outpatientMedicationPromise.getPatient().getIdentifier(), "OutpatientMedicationPromiseQuery", xpath,
//                        gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.OutpatientMedicationPromise.toString(), filterStartDate, filterEndDate );
//    }


    /**
     * Creates endDate of a filter
     *
     * @param endDate
     * @return Date
     * @see createXpathFilterFromOutpatientMedicationPromise
     */

    private static Date getFilterEndDate( int endDate )
    {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.add( Calendar.YEAR, endDate );
        int newYear = sysDate.get( Calendar.YEAR );
        GregorianCalendar newDate = new GregorianCalendar( newYear, Calendar.MONTH, 01 );
        Date endDt = newDate.getTime();
        return endDt;

    }


//    protected static String createXpathFilter( HL72PersonIdentifier aHL72PersonIdentifier, String aQueryName, String aXpath,
//                    String aDomainEntryPoint, Calendar aStartDate, Calendar aEndDate )
//    {
//        PersonIdentifier patientIdentifier = new PersonIdentifier();
//        patientIdentifier.setIdentity( aHL72PersonIdentifier.getIdentity() );
//        patientIdentifier.setAssigningAuthority( aHL72PersonIdentifier.getAssigningAuthority() );
//        patientIdentifier.setAssigningFacility( aHL72PersonIdentifier.getAssigningFacility() );
//        ArrayList<PersonIdentifier> resolvedIds = new ArrayList<PersonIdentifier>( 1 );
//        resolvedIds.add( patientIdentifier );
//
//        // List<EntryFilter> entryFilters = new ArrayList( 1 );
//        List<String> entryFilters = new ArrayList<String>( 2 );
//        String entryFilter1 = createEntryFilter(aQueryName, aDomainEntryPoint, aStartDate, aEndDate, aXpath);
//        entryFilters.add( entryFilter1 );
//
//        String entryFilter2 = createEntryFilter(aQueryName+"2", aDomainEntryPoint, aStartDate, aEndDate, aXpath);
//        entryFilters.add( entryFilter2 );
//
//        return createFilter( resolvedIds, entryFilters );
//    }


	/*
     * <filter:filter vhimVersion="String" xsi:schemaLocation="Filter Filter400C5.xsd" xmlns:filter="Filter"
     * xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"> <filterId>String</filterId> <patients>
     * <resolvedIdentifiers> <identity>String</identity> <assigningAuthority>String</assigningAuthority>
     * <assigningFacility>String</assigningFacility> </resolvedIdentifiers> </patients> <entryPointFilter
     * queryName="text"> <domainEntryPoint>String</domainEntryPoint> <startDate>1967-08-13</startDate>
     * <endDate>1967-08-13</endDate> <recordIdentifiers> <identity>String</identity> <namespaceId>VHA</namespaceId>
     * <universalId>String</universalId> <universalIdType>String</universalIdType> </recordIdentifiers> <xpathQuery>
     * <xpath>String</xpath> <parameter type="text" name="text"> <value>String</value> </parameter> </xpathQuery>
     * </entryPointFilter> <correlationFilter queryName="text"> <xpathQuery> <xpath>String</xpath> <parameter
     * type="text" name="text"> <value>String</value> </parameter> </xpathQuery> </correlationFilter> <aggregationFilter
     * queryName="text"> <xpathQuery> <xpath>String</xpath> <parameter type="text" name="text"> <value>String</value>
     * </parameter> </xpathQuery> </aggregationFilter> </filter:filter>
     */
    protected static String createFilter( List<PersonIdentifier> aResolvedIds, List<String> aEntryFilters )
    {
        StringBuffer xmlWorkBuffer = new StringBuffer();

        xmlWorkBuffer.setLength( 0 );

        xmlWorkBuffer.append( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
        xmlWorkBuffer
                        .append( "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" );
        xmlWorkBuffer.append( "<filterId>testFilterId</filterId>" );
        xmlWorkBuffer.append( "<patients>" );
        for ( PersonIdentifier patientIdentifier : aResolvedIds )
        {
            xmlWorkBuffer.append( "<resolvedIdentifiers>" );
            xmlWorkBuffer.append( "<assigningAuthority>" );
            xmlWorkBuffer.append( patientIdentifier.getAssigningAuthority() );
            xmlWorkBuffer.append( "</assigningAuthority>" );
            xmlWorkBuffer.append( "<assigningFacility>" );
            xmlWorkBuffer.append( patientIdentifier.getAssigningFacility() );
            xmlWorkBuffer.append( "</assigningFacility>" );
            xmlWorkBuffer.append( "<identity>" );
            xmlWorkBuffer.append( patientIdentifier.getIdentity() );
            xmlWorkBuffer.append( "</identity>" );
            xmlWorkBuffer.append( "</resolvedIdentifiers> " );
        }
        xmlWorkBuffer.append( "</patients>" );

        for ( String entryFilter : aEntryFilters )
        {
        	xmlWorkBuffer.append(entryFilter);
        }

        xmlWorkBuffer.append( " </filter:filter>" );
        return xmlWorkBuffer.toString();
    }


    /*--@Test( enabled = false )--*/
    public static String formatDate( XMLGregorianCalendar aDate )
    {
        String value = null;
        if ( aDate != null )
        {
            value = new SimpleDateFormat( DATE_FORMAT_PATTERN ).format( aDate.toGregorianCalendar().getTime() );
        }
        return value;
    }


    /**
     * Checks that there are no errors in the result xml
     */
//    protected void checkForNoErrorsInXml( String aResultXml )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( aResultXml );
//        errorSectionChecker400.assertNoErrors( responseClinicalData );
//    }


    /**
     * Used in Spring injection
     *
     * @param marshallerUnmarshaller
     */
    /*--@Test( enabled = false )--*/
//    @Resource
//    public void setmarshallerUnmarshaller400( MarshallerUnmarshallerInterface marshallerUnmarshaller )
//    {
//        this.marshallerUnmarshaller400 = marshallerUnmarshaller;
//    }


    /**
     * Used in Spring injection
     *
     * @param vdmClinicalDataBuilder400
     */
    @Resource
    public void setVdmClinicalDataBuilder400( VdmClinicalDataBuilder vdmClinicalDataBuilder400 )
    {
        this.vdmClinicalDataBuilder400 = vdmClinicalDataBuilder400;
    }


    /**
     * Used in Spring injection
     *
     * @param errorSectionChecker400
     */
    /*--@Test( enabled = false )--*/
    @Resource
    public void setErrorSectionChecker400( ErrorSectionCheckerInterface errorSectionChecker400 )
    {
        this.errorSectionChecker400 = errorSectionChecker400;
    }


    /*
     * (non-Javadoc)
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createIntoleranceConditionWithDateRangeXml(java.lang.String
     * )
     */
//    protected String createIntoleranceConditionWithDateRangeXml( String observationDate )
//    {
//        HL72PersonIdentifier patientId = BaseDatatypesBuilder.createHL72PersonIdentifier();
//
//        patientId.setIdentity( "allergyDateTest" );
//        patientId.setAssigningFacility( "allergyDateTest" );
//        ClinicalData vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder400.createClinicalData(
//                        TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID, 1, patientId );
//
//        ClinicalDataPatient patient = ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 );
//
//        IntoleranceCondition intoleranceCondition = ( IntoleranceCondition )patient.getIntoleranceConditions().get( 0 );
//        PointInTime observationTime = BaseDatatypesBuilder.createPointInTime();
//        observationTime.setLiteral( observationDate );
//        intoleranceCondition.setObservationTime( observationTime );
//
//        String createIntoleranceConditionXml = marshallerUnmarshaller400.marshallToXml( vdmClinicalDataInsert, vdmClinicalDataInsert.getTemplateId() );
//
//        return createIntoleranceConditionXml;
//    }


    /*
     * (non-Javadoc)
     *
     * @see
     * gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#createXpathFilterFromIntoleranceConditionDateFilter(java
     * .lang.String, java.lang.String, java.lang.String)
     */
//    protected String createXpathFilterFromIntoleranceConditionDateFilter( String xml, String startDate, String endDate )
//    {
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        IntoleranceCondition intoleranceCondition = ( IntoleranceCondition )patient.getIntoleranceConditions().get( 0 );
//
//        StringBuffer xmlWorkBuffer = new StringBuffer();
//
//        xmlWorkBuffer.setLength( 0 );
//        xmlWorkBuffer.append( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
//        xmlWorkBuffer
//                        .append( "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" );
//        xmlWorkBuffer.append( "<filterId>testFilterId</filterId>" );
//        xmlWorkBuffer.append( "<patients> " );
//        xmlWorkBuffer.append( "<resolvedIdentifiers>" );
//        xmlWorkBuffer.append( "<assigningAuthority>" );
//        xmlWorkBuffer.append( intoleranceCondition.getPatient().getIdentifier().getAssigningAuthority() );
//        xmlWorkBuffer.append( "</assigningAuthority>" );
//        xmlWorkBuffer.append( "<assigningFacility>" );
//        xmlWorkBuffer.append( intoleranceCondition.getPatient().getIdentifier().getAssigningFacility() );
//        xmlWorkBuffer.append( "</assigningFacility>" );
//        xmlWorkBuffer.append( "<identity>" );
//        xmlWorkBuffer.append( intoleranceCondition.getPatient().getIdentifier().getIdentity() );
//        xmlWorkBuffer.append( "</identity>" );
//        xmlWorkBuffer.append( "</resolvedIdentifiers> </patients> " );
//        xmlWorkBuffer.append( "<entryPointFilter queryName=\"IC-allergyType\"> <domainEntryPoint>" );
//        xmlWorkBuffer.append( gov.va.med.cds.cdm.clinicaldata.DomainEntryPoint.IntoleranceCondition.toString() );
//        xmlWorkBuffer.append( "</domainEntryPoint> " );
//        xmlWorkBuffer.append( "<startDate>" );
//        xmlWorkBuffer.append( startDate );
//        xmlWorkBuffer.append( "</startDate> " );
//        xmlWorkBuffer.append( "<endDate>" );
//        xmlWorkBuffer.append( endDate );
//        xmlWorkBuffer.append( "</endDate> " );
//        xmlWorkBuffer.append( "</entryPointFilter>  </filter:filter>" );
//
//        return xmlWorkBuffer.toString();
//    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#compareAllergyFilterAndResults(java.lang.String,
     * java.lang.String, java.lang.String)
     */
//    @SuppressWarnings( "unchecked" )
//    protected void compareAllergyFilterAndResults( String xml, String startDate, String endDate, boolean positiveTest )
//    {
//        boolean foundIt = false;
//        String observationDate = null;
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        List<IntoleranceCondition> intoleranceConditions = ( List<IntoleranceCondition> )patient.getIntoleranceConditions();
//
//        if ( positiveTest )
//        {
//            assertTrue( intoleranceConditions.size() > 0 );
//        }
//        else
//        {
//            assertTrue( intoleranceConditions.size() == 0 );
//        }
//
//        for ( IntoleranceCondition ic : intoleranceConditions )
//        {
//            observationDate = ic.getObservationTime().getLiteral();
//            // Convert non-conforming dates to null
//            observationDate = isNonConformatString( observationDate );
//
//            if ( observationDate == null || ( observationDate.compareTo( endDate ) < 1 && observationDate.compareTo( startDate ) > -1 ) )
//            {
//                foundIt = true;
//                if ( logger.isDebugEnabled() )
//                {
//                    logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, " Date: " + observationDate
//                                    + " exists between " + startDate + " - " + endDate ) );
//                }
//            }
//            assertTrue( "An allergy with observation data of " + observationDate + " is NOT between: " + startDate + " - " + endDate, foundIt );
//        }
//
//    }


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.integration.EndToEndCRUADAutoWiredTest#ensureAllergyContainsInvalidDate(java.lang.String,
     * java.lang.String)
     */
    @SuppressWarnings( "unchecked" )
//    protected void ensureAllergyContainsInvalidDate( String xml, String invalidDate )
//    {
//        boolean foundIt = false;
//        String observationDate = null;
//        ClinicalData responseClinicalData = ( ClinicalData )marshallerUnmarshaller400.unmarshallToVdm( xml );
//        ClinicalDataPatient patient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//
//        List<IntoleranceCondition> intoleranceConditions = ( List<IntoleranceCondition> )patient.getIntoleranceConditions();
//
//        assertTrue( intoleranceConditions.size() > 0 );
//
//        for ( IntoleranceCondition ic : intoleranceConditions )
//        {
//            observationDate = ic.getObservationTime().getLiteral();
//
//            if ( observationDate.equals( invalidDate ) )
//            {
//                foundIt = true;
//            }
//        }
//
//        assertTrue( foundIt );
//    }


    /**
     * This return ensures the user string is conformant to at least the following rules: - All characters must be
     * numeric for the iso conversion
     *
     * @param observationDate
     * @return String
     */
    private String isNonConformatString( String observationDate )
    {
        for ( int index = 0; index < observationDate.length(); index++ )
        {
            char isoDateCharacter = observationDate.charAt( index );
            if ( !( isoDateCharacter <= '9' && isoDateCharacter >= '0' ) )
            {
                return null;
            }
        }
        observationDate = observationDate.length() > 7 ? observationDate.substring( 0, 8 ) : "00000000";
        return observationDate;
    }


//    @AfterTestsOnce
//    @Suite( groups = { "brokentest" } )
//    public void afterEndToEndCRUADAutoWiredV400TestsTearDown( )
//    {
//
//        marshallerUnmarshaller400 = null;
//        vdmClinicalDataBuilder400 = null;
//        errorSectionChecker400 = null;
//    }

//
//    public static void main( String[] args )
//        throws Exception
//    {
//        List<PersonIdentifier> resolvedIds = new ArrayList<PersonIdentifier>();
//        PersonIdentifier sourceId = new PersonIdentifier();
//        sourceId.setIdentity( "EI01" );
//        sourceId.setAssigningFacility( "AS01" );
//        resolvedIds.add( sourceId );
//        sourceId = new PersonIdentifier();
//        sourceId.setIdentity( "EI02" );
//        sourceId.setAssigningFacility( "AS02" );
//        resolvedIds.add( sourceId );
//        sourceId = new PersonIdentifier();
//        sourceId.setIdentity( "EI03" );
//        sourceId.setAssigningFacility( "AS03" );
//        resolvedIds.add( sourceId );
//
//        Calendar startDate = convertDateToCalendar(DATE_FORMAT.parse("2007-08-01"));
//        Calendar endDate = convertDateToCalendar(DATE_FORMAT.parse("2007-08-31"));
//     
//        List<String> entryFilters = new ArrayList<String>();
//        String entryFilter = createEntryFilter("ICQuery", "IntoleranceCondition", startDate, endDate, "/a/b/c=4");
//        entryFilters.add( entryFilter );
//        String xml = EndToEndCRUADAutoWiredV400Test.createFilter( resolvedIds, entryFilters );
//        System.out.println( xml );
//    }
}
