

package gov.va.med.cds.vdm.vhim400.integration;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.integration.AbstractEndToEndCRUADAutoWiredMergeTest;
import gov.va.med.cds.integration.ErrorSectionCheckerInterface;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ClinicalData;
import gov.va.med.cds.vdm.vhim400.clinicaldata.VdmClinicalDataBuilder;

import java.io.IOException;

import javax.annotation.Resource;
import javax.xml.parsers.ParserConfigurationException;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.xml.sax.SAXException;


/**
 *
 * This is a vhim version specific class and initiates all tests through the outermost client pojo
 * (ClinicalDataServiceSynchronous). See the super abstract class documentation.
 *
 */

@RunWith( SuiteAwareSpringRunner.class )
//@ContextConfiguration( locations = { "classpath:gov/va/med/cds/vdm/vhim400/marshal/vdm400TestContext.xml",
//                "classpath:gov/va/med/cds/template/testTemplateContext.xml",
//                "classpath:gov/va/med/cds/config/testTransactionContext.xml",
//                "classpath:gov/va/med/cds/config/vdm400Context.xml" } )
public class EndToEndCRUADAutoWiredMergeV400Test
    extends
        AbstractEndToEndCRUADAutoWiredMergeTest
{
  
    private VdmClinicalDataBuilder vdmClinicalDataBuilder = null;
    private ClinicalData vdmClinicalDataInsert;
    private ErrorSectionCheckerInterface errorSectionChecker = null;


    /**
     * Tests the Non-Merge scenario. Creates a hdr record with different Identity than the one existing in Hx 
     * and returns two records from HDR2 database. 
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws XmlCompareException
     */
//    @Override
//    @Test
//    @Suite( groups = { "slowtest" } )
//    public void testIntoleranceConditionCreateReadNoMergeDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testIntoleranceConditionCreateReadNoMergeDelete();
//    }


    /**
     * Tests the Merge scenario. Creates a hdr record with same Identity as that of the one existing in Hx; but has a different value in Non-id field 
     * to check the Merge functionality and expects a single merged record returned from th HDR2 database. 
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws XmlCompareException
     */
//    @Override
//    @Test
//    @Suite( groups = { "slowtest" } )
//    public void testIntoleranceConditionCreateReadMergeDelete( )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException
//    {
//        super.testIntoleranceConditionCreateReadMergeDelete();
//    }


    /**
     * Creates a filter xml used in a read request.
     */
    protected String getAllergyFilterWithOneResolvedId( String aHxLocalPatientIdEntityIdentifier, String aHxLocalPatientIdAssigningFacUniversalId )
    {
        StringBuffer xmlWorkBuffer = new StringBuffer();
        xmlWorkBuffer.setLength( 0 );

        xmlWorkBuffer.append( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
        xmlWorkBuffer
                        .append( "<filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" );
        xmlWorkBuffer.append( "<filterId>Filter100</filterId>" );
        xmlWorkBuffer.append( "<patients> " );
        xmlWorkBuffer.append( "<resolvedIdentifiers>" );
        xmlWorkBuffer.append( "<assigningAuthority>" );
        xmlWorkBuffer.append( "</assigningAuthority>" );
        xmlWorkBuffer.append( "<assigningFacility>" );
        xmlWorkBuffer.append( aHxLocalPatientIdAssigningFacUniversalId );
        xmlWorkBuffer.append( "</assigningFacility>" );
        xmlWorkBuffer.append( "<identity>" );
        xmlWorkBuffer.append( aHxLocalPatientIdEntityIdentifier );
        xmlWorkBuffer.append( "</identity>" );
        xmlWorkBuffer.append( "</resolvedIdentifiers> " );
        xmlWorkBuffer.append( "</patients> " );
        xmlWorkBuffer.append( "<entryPointFilter queryName=\"IC-allergyType\">" );
        xmlWorkBuffer.append( "<domainEntryPoint>" );
        xmlWorkBuffer.append( DomainEntryPoint.IntoleranceCondition.getName() );
        xmlWorkBuffer.append( "</domainEntryPoint>" );
        xmlWorkBuffer.append( "</entryPointFilter>" );

        xmlWorkBuffer.append( "</filter:filter>" );

        return xmlWorkBuffer.toString();
    }


    /**
     * Returns the filter id used in the read request
     */
    protected String getAllergyFilterId( )
    {
        return "Filter100";
    }


    /**
     * Checks that there are no errors in the result xml
     */
    protected void checkForNoErrorsInXml( Document aResultXml )
    {
        //TODO replace with errorsection checing - 
        //errorSectionChecker.assertNoErrors( responseClinicalData );
    }


    /**
     * Gets the number of IntoleranceConditions from the read result xml
     */
    protected int getDomainRecordCount( Document aReadResult )
    {
        //TODO: add method to find record count of document
        return 0;

    }


    /**
     * Gets the IntoleranceCondition Create template id
     */
    protected String getAllergyCreateTemplateId( )
    {

        return vdmClinicalDataInsert.getTemplateId();
    }


    /**
     * Returns the IntoleranceCondition Author comment field value
     */
    protected Element getIntoleranceConditionAuthorComment( Document readResult )
    {
        Element comment = null;
        //TODO: add logic to return the comment Element of document
//        ClinicalDataPatient clinicalDataPatient = ( ClinicalDataPatient )responseClinicalData.getPatient().get( 0 );
//        IntoleranceCondition intoleranceCondition = ( IntoleranceCondition )clinicalDataPatient.getIntoleranceConditions().get( 0 );
//        PractitionerParticipationLite author = intoleranceCondition.getAuthor();
//        if ( null != author )
//        {
//            comment = author.getComment();
//        }
          return comment;

    }


   

   


    /**
     * Creates a VDM IntoleranceCondition from VdmBuilder with non-null identity and marshalls it into xml.
     */
    protected String createAllergyXmlDifferentIdentity( )
    {
        //TODO: change code to create the allergy using the dataGenerator/builders
//        HL72PersonIdentifier patient = createPatient( "129", "613" );
//
//        // Same record in HDR and Hx
//
//        vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder.createClinicalData( TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID,
//                        1, patient );
//
//        HL72EntityIdentifier id = BaseDatatypesBuilder.createHL72EntityIdentifier();
//        id.setNamespaceId( "613" );
//        id.setIdentity( "1" );
//        //        id.setUniversalId( "differentFromHx" );
//        //        id.setUniversalIdType( "differentFromHx" );
//
//        ( ( IntoleranceCondition )( ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 ) ).getIntoleranceConditions().get( 0 ) )
//                        .setRecordIdentifier( id );
//
//        
//
//        return createIntoleranceConditionXml;
        return null;
    }




    /**
     * Creates a VDM IntoleranceCondition from VdmBuilder with null identity and marshalls it into xml.
     */
    protected String createAllergyXmlWithSameIdentity( )
    {
        //TODO: change code to create the allergy using the dataGenerator/builders
//        HL72PersonIdentifier patient = createPatient( "129", "613" );
//
//        vdmClinicalDataInsert = ( ClinicalData )vdmClinicalDataBuilder.createClinicalData( TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID,
//                        1, patient );
//
//        HL72EntityIdentifier id = BaseDatatypesBuilder.createHL72EntityIdentifier();
//        id.setNamespaceId( "613_120.8" );
//        id.setIdentity( "2" );
//        id.setUniversalId( null );
//        id.setUniversalIdType( null );
//
//        ( ( IntoleranceCondition )( ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 ) ).getIntoleranceConditions().get( 0 ) )
//                        .setRecordIdentifier( id );
//
//        ( ( IntoleranceCondition )( ( ClinicalDataPatient )vdmClinicalDataInsert.getPatient().get( 0 ) ).getIntoleranceConditions().get( 0 ) )
//                        .getAuthor().setComment( "HDR test Record" );
//
//        String createIntoleranceConditionXml = marshallerUnmarshaller400.marshallToXml( vdmClinicalDataInsert, vdmClinicalDataInsert.getTemplateId() );
//
//        return createIntoleranceConditionXml;
        return null;
    }



//    /**
//     * Used in Spring injection
//     *
//     * @param vdmBuilder
//     */
//    @Resource
//    public void setVdmClinicalDataBuilder( VdmClinicalDataBuilder vdmBuilder )
//    {
//        this.vdmClinicalDataBuilder = vdmBuilder;
//    }


//    /**
//     * Used in Spring injection
//     *
//     * @param errorSectionChecker
//     */
//    @Resource
//    public void setErrorSectionChecker( ErrorSectionCheckerInterface errorSectionChecker )
//    {
//        this.errorSectionChecker = errorSectionChecker;
//    }


    /*
     * Gets the IntoleranceCondition Delete template id
     */
    protected String getAllergyDeleteTemplateId( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_DELETE_TEMPLATE_ID;
    }


    /**
     * Gets the IntoleranceCondition Read template id
     */
    protected String getAllergyReadTemplateId( )
    {
        return TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
    }


    @AfterTestsOnce
    @Suite( groups = { "slowtest" } )
    public void afterEndToEndCRUADAutoWiredMergeV400TestsTearDown( )
        throws Exception
    {
//        marshallerUnmarshaller400 = null;
//        vdmClinicalDataBuilder = null;
//        vdmClinicalDataInsert = null;
//        errorSectionChecker = null;
    }


    @Override
    protected void checkForNoErrorsInXml( String createResult )
    {
        // TODO Auto-generated method stub
        
    }


    @Override
    protected int getDomainRecordCount( String readResultFromHx )
    {
        // TODO Auto-generated method stub
        return 0;
    }


    @Override
    protected String getIntoleranceConditionAuthorComment( String readResultFromHx )
    {
        // TODO Auto-generated method stub
        return null;
    }


    @Override
    protected String populateTemplateMetaDataOfClinicalDataRecord( String templateId, String readResultFromHx, int recordNumber )
    {
        // TODO Auto-generated method stub
        return null;
    }
}
