

package gov.va.med.cds.vdm.vhim400.integration;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import gov.va.med.cds.AbstractBaseIntegrationCoreTest;
import gov.va.med.cds.filter.CdsFilterFactoryInterface;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.RequestValidatorInterface;
import gov.va.med.cds.request.ResponseValidatorInterface;
import gov.va.med.cds.template.TemplateMetaDataProviderInterface;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ClinicalData;
import gov.va.med.cds.vdm.vhim400.clinicaldata.ErrorSection;
import gov.va.med.cds.vdm.vhim400.clinicaldata.VdmClinicalDataBuilder;

import javax.annotation.Resource;

import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/nonWeblogicApplicationContext.xml",
                "classpath:gov/va/med/cds/vdm/vhim3602/vdm3602TestContext.xml" } )
public abstract class AbstractV400EndToEndTest
    extends
        AbstractBaseIntegrationCoreTest
{
    protected RequestProcessorInterface requestProcessor = null;
    protected RequestValidatorInterface requestValidator = null;
    protected ResponseValidatorInterface responseValidator = null;
    protected TemplateMetaDataProviderInterface templateMetaDataProvider = null;
    protected CdsFilterFactoryInterface filterFactory;
    protected VdmClinicalDataBuilder vdmBuilder;
    


    @Resource
    public void setRequestProcessor( RequestProcessorInterface requestProcessor )
    {
        this.requestProcessor = requestProcessor;
    }




    @Resource
    public void setRequestValidator( RequestValidatorInterface requestValidator )
    {
        this.requestValidator = requestValidator;
    }


    protected AbstractV400EndToEndTest( String configFilePath )
    {
        super( configFilePath );
    }


    protected AbstractV400EndToEndTest( )
    {
        super();
    }


    // to check if error section/its content is null; use where errors are not expected.
    protected void checkForNoErrorsInXml( ClinicalData vdmClinicalData )
    {

        ErrorSection errorSection = vdmClinicalData.getErrorSection();
        if ( errorSection != null )
        {
            assertEquals( errorSection.getErrors().size(), 0 );
            assertEquals( errorSection.getFatalErrors().size(), 0 );
            assertEquals( errorSection.getWarnings().size(), 0 );
        }

    }


    // used for checking the presence of one fatal error; use where one fatal error is expected.
    protected void checkForFatalErrorsInXml( ClinicalData vdmClinicalData )
    {

        ErrorSection errorSection = vdmClinicalData.getErrorSection();
        assertNotNull( errorSection );
        assertEquals( errorSection.getErrors().size(), 0 );
        assertEquals( errorSection.getFatalErrors().size(), 1 );
        assertEquals( errorSection.getWarnings().size(), 0 );

    }


    @Resource
    public void setFilterFactory( CdsFilterFactoryInterface filterFactory )
    {
        this.filterFactory = filterFactory;
    }


    public CdsFilterFactoryInterface getFilterFactory( )
    {
        return this.filterFactory;
    }


    @Resource
    public void setResponseValidator( ResponseValidatorInterface responseValidator )
    {
        this.responseValidator = responseValidator;
    }


    @Resource
    public void setTemplateMetaDataProvider( TemplateMetaDataProviderInterface templateMetaDataProvider )
    {
        this.templateMetaDataProvider = templateMetaDataProvider;
    }


    @Resource
    public void setVdmClinicalDataBuilder( VdmClinicalDataBuilder vdmBuilder )
    {
        this.vdmBuilder = vdmBuilder;
    }
}