

package gov.va.med.cds.util;


import static org.easymock.EasyMock.expect;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.testharness.AbstractBaseTest;

import java.util.HashMap;
import java.util.Map;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;


public class TimeoutUtilTest
    extends
        AbstractBaseTest
{
    public static final String UPPER_LIMIT_TIMEOUT = "upperLimitTimeout";


    @Test
    @Suite( groups = { "checkintest" } )
    public void testTimeoutFromFilterIsBeingUsed( )
    {
        EntryFilterInterface filter = EasyMock.createMock( EntryFilterInterface.class );
        expect( filter.getTimeout() ).andReturn( 88L ).anyTimes();
        EasyMock.replay( filter );

        Map<String, String> templateTimeoutMap = new HashMap<String, String>();
        templateTimeoutMap.put( UPPER_LIMIT_TIMEOUT, "99" );
        Long resultTimeout = TimeoutUtil.processTimeout( templateTimeoutMap, filter, "cdsAppName" );
        Assert.assertEquals( new Long( "88" ), resultTimeout );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testUpperlTimeoutFromFilterIsBeingUsedAgainstFilterTimeout( )
    {
        EntryFilterInterface filter = EasyMock.createMock( EntryFilterInterface.class );
        expect( filter.getTimeout() ).andReturn( 88L ).anyTimes();
        EasyMock.replay( filter );

        Map<String, String> templateTimeoutMap = new HashMap<String, String>();
        templateTimeoutMap.put( UPPER_LIMIT_TIMEOUT, "77" );
        Long resultTimeout = TimeoutUtil.processTimeout( templateTimeoutMap, filter, "cdsAppName" );
        Assert.assertEquals( new Long( "77" ), resultTimeout );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testTimeoutFromConfigIsBeingUsed( )
    {
        EntryFilterInterface filter = EasyMock.createMock( EntryFilterInterface.class );
        expect( filter.getTimeout() ).andReturn( null ).anyTimes();
        expect( filter.getTemplateId() ).andReturn( "testTemplateId" );
        expect( filter.getDomainEntryPoint() ).andReturn( "testDomainEntryPoint" );
        EasyMock.replay( filter );

        Map<String, String> templateTimeoutMap = new HashMap<String, String>();
        templateTimeoutMap.put( UPPER_LIMIT_TIMEOUT, "99" );
        templateTimeoutMap.put( "testTemplateId-testDomainEntryPoint", "88" );
        Long resultTimeout = TimeoutUtil.processTimeout( templateTimeoutMap, filter, "cdsAppName" );
        Assert.assertEquals( new Long( "88" ), resultTimeout );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testUpperlTimeoutFromFilterIsBeingUsedAgainstConfigTimeout( )
    {
        EntryFilterInterface filter = EasyMock.createMock( EntryFilterInterface.class );
        expect( filter.getTimeout() ).andReturn( null ).anyTimes();
        expect( filter.getTemplateId() ).andReturn( "testTemplateId" );
        expect( filter.getDomainEntryPoint() ).andReturn( "testDomainEntryPoint" );
        EasyMock.replay( filter );

        Map<String, String> templateTimeoutMap = new HashMap<String, String>();
        templateTimeoutMap.put( UPPER_LIMIT_TIMEOUT, "77" );
        templateTimeoutMap.put( "testTemplateId-testDomainEntryPoint", "88" );
        Long resultTimeout = TimeoutUtil.processTimeout( templateTimeoutMap, filter, "cdsAppName" );
        Assert.assertEquals( new Long( "77" ), resultTimeout );
    }
}
