

package gov.va.med.cds.util;


import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;

import java.io.File;
import java.util.List;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/nestedElementsWrapperContext.xml" } )
public class NestedElementWrapperUtilTest
{
    @Resource
    private NestedElementWrapperUtil nestedElementWrapperUtil;


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRxAddNestedElements( )
        throws Exception
    {
        String createRequest = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/java/gov/va/med/cds/integration/vhim400/SampleOpRxCreate.xml" ) ) );

        Document clinicalDataDocument = DocumentHelper.parseText( createRequest );
        String templateId = TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID;

        clinicalDataDocument = nestedElementWrapperUtil.addNestedElements( clinicalDataDocument, templateId );

        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/patientInstructions/patientInstructions" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/otherPatientInstructions/otherPatientInstructions" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/expandedPatientInstructions/expandedPatientInstructions" )
                        .size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/pharmacyInstructions/pharmacyInstructions" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/sig/sig" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/treatmentFactor/treatmentFactor" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/medicationInstructions/medicationInstructions" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/originalDispense/originalDispense" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/originalDispense/originalDispense/comments/comments" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes(
                        "//outpatientMedicationPromises/originalDispense/originalDispense/currentProviderComments/currentProviderComments" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/refillDispense/refillDispense" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/refillDispense/refillDispense/comments/comments" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes(
                        "//outpatientMedicationPromises/refillDispense/refillDispense/currentProviderComments/currentProviderComments" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/partialDispense/partialDispense" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//outpatientMedicationPromises/partialDispense/partialDispense/comments/comments" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes(
                        "//outpatientMedicationPromises/partialDispense/partialDispense/currentProviderComments/currentProviderComments" ).size() > 0 );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testIntoleranceCondtionAddNestedElements( )
        throws Exception
    {
        String createRequest = StreamUtil.resourceToString( new FileSystemResource( new File(
                        "src/test/java/gov/va/med/cds/util/IntoleranceConditionCreate.xml" ) ) );

        Document clinicalDataDocument = DocumentHelper.parseText( createRequest );
        String templateId = TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID;

        clinicalDataDocument = nestedElementWrapperUtil.addNestedElements( clinicalDataDocument, templateId );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/reaction/reaction" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/chartMarker/chartMarker" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/idBandMarker/idBandMarker" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/drugIngredient/drugIngredient" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/drugClass/drugClass" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/commentEvents/commentEvents" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/commentEvents/commentEvents/comments" ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/commentEvents/commentEvents[1]/comments/comments" ).size() == 2 );
        assertTrue( clinicalDataDocument.selectNodes( "//intoleranceConditions/commentEvents/commentEvents[2]/comments/comments" ).size() == 2 );
        
    }
}
