/**
 * 
 */
package gov.va.med.cds.transaction;

import static org.junit.Assert.assertNotNull;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.persistence.PersistenceException;

import java.util.ArrayList;
import java.util.List;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.scheduling.commonj.WorkManagerTaskExecutor;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkManager;

/**
 * @author VHAISLTALBOM
 *
 */
@RunWith( SuiteAwareRunner.class )
public class SpringWorkManagerSchedulerTest
{
    @Test 
    @Suite( groups = { "checkintest" } )
    public void testSchedule() throws IllegalArgumentException, WorkException
    {
        SpringWorkManagerScheduler springWorkManagerScheduler = new SpringWorkManagerScheduler();
        WorkManager workManager = EasyMock.createMock( WorkManager.class );
        springWorkManagerScheduler.setWorkManager( workManager );
        
        Work work = EasyMock.createMock( Work.class );
        WorkItem workItem = EasyMock.createMock( WorkItem.class );
    
        EasyMock.expect( workManager.schedule(work) ).andReturn(workItem);
        EasyMock.replay( workManager );
        
        assertNotNull( springWorkManagerScheduler.schedule( work ));
        
        EasyMock.verify( workManager );
   
    }
    
    @Test 
    @Suite( groups = { "checkintest" } )
    public void testWaitForAll() throws IllegalArgumentException, WorkException, InterruptedException
    {
        SpringWorkManagerScheduler springWorkManagerScheduler = new SpringWorkManagerScheduler();
        WorkManager workManager = EasyMock.createMock( WorkManager.class );
        springWorkManagerScheduler.setWorkManager( workManager );
        
        WorkItem workItem = EasyMock.createMock( WorkItem.class );
        List<WorkItem> jobs = new ArrayList<WorkItem>();
        jobs.add( workItem );
    
        EasyMock.expect(workManager.waitForAll(jobs, WorkManagerTaskExecutor.INDEFINITE)).andReturn(true);
        EasyMock.replay( workManager );
        
        springWorkManagerScheduler.waitForAll( jobs );
        
        EasyMock.verify( workManager );
   
    }
    
    @Test (expected=WorkException.class)
    @Suite( groups = { "checkintest" } )
    public void testWaitForAllWithException() throws Exception
    {
        SpringWorkManagerScheduler springWorkManagerScheduler = new SpringWorkManagerScheduler();
        WorkManager workManager = EasyMock.createMock( WorkManager.class );
        springWorkManagerScheduler.setWorkManager( workManager );
        
        WorkItem workItem = EasyMock.createMock( WorkItem.class );
        List<WorkItem> jobs = new ArrayList<WorkItem>();
        jobs.add( workItem );
        
        InterruptedException ie = new InterruptedException("testing");
    
        EasyMock.expect(workManager.waitForAll(jobs, WorkManagerTaskExecutor.INDEFINITE)).andThrow( ie );
        EasyMock.replay( workManager );
        
        springWorkManagerScheduler.waitForAll( jobs );
        
    }



}
