

package gov.va.med.cds.tfs.util;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Assert;
import org.junit.Test;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;


public class TemplateMetaDataHelperTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testBuildVhimVersions( )
    {
        String vhimVersionsStr = "[Vhim_4_00,Vhim_4_01,Vhim_5_00]";
        String[] expectedVhimVersions = { "Vhim_4_00", "Vhim_4_01", "Vhim_5_00" };

        String[] vhimVersions = TemplateMetaDataHelper.buildVhimVersions( vhimVersionsStr );
        Assert.assertTrue( Arrays.equals( expectedVhimVersions, vhimVersions ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testBuildEntryPoints( )
    {
        Set<DomainEntryPoint> expectedEmptyEntryPoints = new HashSet<DomainEntryPoint>();
        Set<DomainEntryPoint> entryPointsSet = TemplateMetaDataHelper.buildEntryPoints( null );
        Assert.assertTrue( entryPointsSet.equals( expectedEmptyEntryPoints ) );

        StringBuilder entryPointBuilder = new StringBuilder();
        entryPointBuilder.append( "[" ).append( DomainEntryPoint.AllergyAssessment );
        entryPointBuilder.append( "," ).append( DomainEntryPoint.IntoleranceCondition ).append( "]" );

        Set<DomainEntryPoint> expectedEntryPoints = new HashSet<DomainEntryPoint>();
        expectedEntryPoints.add( DomainEntryPoint.AllergyAssessment );
        expectedEntryPoints.add( DomainEntryPoint.IntoleranceCondition );

        entryPointsSet = TemplateMetaDataHelper.buildEntryPoints( entryPointBuilder.toString() );
        Assert.assertTrue( entryPointsSet.equals( expectedEntryPoints ) );

        String[] expectedEntryPointsArray = TemplateMetaDataHelper.buildVhimVersions( entryPointBuilder.toString() );

        Collection<String> entryPointsCollection = TemplateMetaDataHelper.getEntryPoints( entryPointsSet );
        String[] entryPointsArray = new String[entryPointsCollection.size()];
        entryPointsCollection.toArray( entryPointsArray );

        Assert.assertTrue( Arrays.equals( entryPointsArray, expectedEntryPointsArray ) );
    }
}
