

package gov.va.med.cds.template;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;


@RunWith( SuiteAwareRunner.class )
public class TemplateServiceSimulatorTest
{

    private static Map<String, Properties> templateMetaDataMap = new HashMap<String, Properties>();
    private static Properties property = null;

    private static TemplateServiceSimulator templateServiceSimulator = null;


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void templateServiceSimulatorTestSetUp( )
        throws IOException
    {
        property = new Properties();

        property.setProperty( "id", "IntoleranceConditionRead40010" );
        property.setProperty( "requestType", "Read" );
        property.setProperty( "testOnly", "false" );
        property.setProperty( "targetNamespace", "Clinicaldata" );
        property.setProperty( "vhimVersion", "Vhim_4_00" );
        property.setProperty( "entryPoint", "[IntoleranceCondition]" );

        templateMetaDataMap.put( "IntoleranceConditionRead40010", property );

        templateServiceSimulator = new TemplateServiceSimulator();

        property.setProperty( "path", "templatecache" );
        templateServiceSimulator.setTestTemplates( property );

        property.setProperty( "path", "templatecache/IntoleranceConditionRead40010.meta" );
        templateServiceSimulator.setTestTemplates( property );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void getActiveTemplateIdsTest( )
        throws IOException
    {
        templateServiceSimulator.initialize();
        templateServiceSimulator.isAlive();
        templateServiceSimulator.getActiveTemplateIds( "Vhim_4_00" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void getTemplateMetaDataTest( )
        throws IOException
    {
        templateServiceSimulator.getTemplateMetaData( "IntoleranceConditionRead40010" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void getVhimVersionsTest( )
    {
        templateServiceSimulator.getVhimVersions();
    }
}
