/**
 * 
 */
package gov.va.med.cds.template;

import static org.junit.Assert.assertTrue;
import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.response.ResponseAggregatorInterface;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;
import gov.va.med.cds.response.sequencer.ResponseSequencerInterface;

import java.util.HashMap;
import java.util.Map;

import org.easymock.EasyMock;
import org.junit.Test;

/**
 * @author susarlan
 *
 */
public class TemplateHelperTest 
{
	@Test
	public void testTemplateHelper()
	{
		String templateId = "templateId1";
		String requestId = "requestId1";
		
		Map<String, Map<String, Object>> templateDependentObjectsMap = new HashMap<String, Map<String, Object>>();

		WriteResponseGeneratorInterface responseGenerator = EasyMock.createNiceMock(WriteResponseGeneratorInterface.class);	
		ErrorSectionHelperInterface errorSectionHelper = EasyMock.createNiceMock(ErrorSectionHelperInterface.class);
		ResponseAggregatorInterface responseAggregator = EasyMock.createNiceMock(ResponseAggregatorInterface.class);		
		ResponseSequencerInterface responseSequencer = EasyMock.createNiceMock(ResponseSequencerInterface.class);

		Map<String, Object> mapOfObjects = new HashMap<String, Object>();
		mapOfObjects.put("gov.va.med.cds.response.WriteResponseGeneratorInterface", responseGenerator);
		mapOfObjects.put("gov.va.med.cds.request.ErrorSectionHelperInterface", errorSectionHelper);
		mapOfObjects.put("gov.va.med.cds.response.ResponseAggregatorInterface", responseAggregator);
		mapOfObjects.put("gov.va.med.cds.response.sequencer.ResponseSequencerInterface", responseSequencer);
		
		templateDependentObjectsMap.put("templateId1", mapOfObjects);
		
		TemplateHelper templateHelper = new TemplateHelper();
		templateHelper.setTemplateDependentObjectsMap(templateDependentObjectsMap);
		
		EasyMock.replay(responseGenerator, errorSectionHelper, responseAggregator, responseSequencer);
		
		assertTrue(templateHelper.getWriteResponseGenerator(templateId) instanceof WriteResponseGeneratorInterface);
		assertTrue(templateHelper.getResponseAggregator(templateId) instanceof ResponseAggregatorInterface);
		assertTrue(templateHelper.getResponseSequencer(templateId) instanceof ResponseSequencerInterface);
		assertTrue(templateHelper.getErrorSectionHelper(templateId) instanceof ErrorSectionHelperInterface);
	}

}
