

package gov.va.med.cds.template;


import static org.easymock.EasyMock.*;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.SearchPathGeneratorInterface;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class TemplateCacheFileManagerTest
{
    private static TemplateCacheInterface templateCache = null;
    private static TemplateMetaDataInterface templateMetaData = null;
    private static SearchPathGeneratorInterface searchPathGenerator = null;
    private static TemplateCacheFileManager templateCacheFileManager = null;

    private static Set<DomainEntryPoint> domain = new HashSet<DomainEntryPoint>();


    private static void initMocks( )
    {
        searchPathGenerator = createNiceMock( SearchPathGeneratorInterface.class );
        templateMetaData = createNiceMock( TemplateMetaDataInterface.class );
        templateCache = createNiceMock( TemplateCacheInterface.class );
    }


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void templateCacheFileManagerTestSetUp( )
    {
        initMocks();

        domain.add( DomainEntryPoint.IntoleranceCondition );
    }


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeMethodSetUp( )
        throws IOException
    {
        reset( searchPathGenerator, templateMetaData );

        templateCacheFileManager = new TemplateCacheFileManager();
        templateCacheFileManager.setSearchPathGenerator( searchPathGenerator );

        expect( searchPathGenerator.getSearchPath() ).andReturn( "file:templatecache" ).anyTimes();
        expect( templateMetaData.getWriteCdsVdm() ).andReturn( "vhim_4_00" ).anyTimes();
        expect( templateMetaData.getTemplateName() ).andReturn( "IntoleranceConditionRead40010" ).anyTimes();

        expect( templateMetaData.getTemplateId() ).andReturn( "IntoleranceConditionRead40010" ).anyTimes();
        expect( templateMetaData.getVhimVersions() ).andReturn( new String[] { "Vhim_4_00" } ).anyTimes();
        expect( templateMetaData.getOperation() ).andReturn( Operation.Read ).anyTimes();
        expect( templateMetaData.getTemplateDescription() ).andReturn( "IntoleranceConditionRead40010" ).anyTimes();
        expect( templateMetaData.getDomainEntryPoints() ).andReturn( domain );

        expect( templateMetaData.getTemplateJar() ).andReturn( null );

        templateCacheFileManager.setPersist( true );

        replay( searchPathGenerator, templateMetaData );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void loadAllTemplatesIntoCacheTest( )
    {
        templateCacheFileManager.loadAllTemplatesIntoCache( templateCache );
        templateCacheFileManager.loadTemplateIntoCache( templateCache, "IntoleranceConditionRead40010" );
    }


    @Test( expected = TemplateCacheException.class )
    @Suite( groups = { "checkintest" } )
    public void saveTemplateMetaDataToPersistenceExceptionTest( )
    {
     	 reset( searchPathGenerator);
    	 expect( searchPathGenerator.getSearchPath() ).andReturn( "file:templatecachex" ).anyTimes();
    	 replay( searchPathGenerator );
    	templateCacheFileManager.saveTemplateMetaDataToPersistence( templateMetaData );
    }

}
