

package gov.va.med.cds.response.vhim400;


import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.clinicaldata.vhim400.PathwaysDataResponseInterface;
import gov.va.med.cds.exception.AbstractCdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;
import gov.va.med.cds.template.TemplateHelperInterface;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;

import org.dom4j.Document;
import org.dom4j.Element;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareRunner.class )
public class WriteResponseGeneratorTest
{
    WriteResponseGeneratorInterface generator = new WriteResponseGenerator();
    private static final String CDS_APP_NAME = "CDS 3.6";


    @Test
    @Suite( groups = { "checkintest" } )
    public void generateSuccessfulWriteResponseTest( )
    {

        ClinicalDataResponseInterface clinicalData = EasyMock.createMock( ClinicalDataResponseInterface.class );
        /* some templates will build a response with recordIdentifiers - most will not
         * this test will provide empty identifier list content and construct a response without identifiers*/
        List<String> createdIdentifierResponseTemplates = new ArrayList<String>();

        Element recordIdentifierElementMock = EasyMock.createNiceMock( Element.class );
        List<Element> recordIdentifiers = new ArrayList<Element>();
        recordIdentifiers.add( recordIdentifierElementMock );

        Document doc = EasyMock.createMock( Document.class );
        Element root = EasyMock.createMock( Element.class );
        EasyMock.expect(
                        clinicalData.buildEmptyClinicalDocument( TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID,
                                        TemplateIdHelper.UNIQUE_REQUEST_ID, false ) ).andReturn( doc );
        EasyMock.expect( doc.getRootElement() ).andReturn( root );
        EasyMock.expect( root.addElement( "errorSection" ) ).andReturn( null );

        EasyMock.replay( clinicalData, doc, root );

        ( ( WriteResponseGenerator )generator ).setClinicalDataResponse( clinicalData );
        ( ( WriteResponseGenerator )generator ).setCreatedIdentifierResponseTemplates( createdIdentifierResponseTemplates );

        generator.generateSuccessfulWriteResponse( TemplateIdHelper.INTOLERANCE_CONDITION_CREATE_TEMPLATE_ID, TemplateIdHelper.UNIQUE_REQUEST_ID,
                        recordIdentifiers );

        EasyMock.verify( clinicalData, doc, root );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = "checkintest" )
    public void generateWriteErrorResponseTest( )
        throws Exception
    {
        AbstractCdsBaseException exception = new ValidationException( ErrorCodeEnum.READ_REQUEST_INPUT_PARAMETERS_NULL );
        String[] customMsgValues = {"customMsgValue1"};
        exception.setCustomMsgValues( customMsgValues );
        String templateId = TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID;
        String requestId = TemplateIdHelper.UNIQUE_REQUEST_ID;
        List<String> createdIdentifierResponseTemplates = new ArrayList<String>();
        //Create Mocks
        Element recordIdentifierElementMock = EasyMock.createNiceMock( Element.class );
        List<Element> recordIdentifiers = new ArrayList<Element>();
        recordIdentifiers.add( recordIdentifierElementMock );
        ClinicalDataResponseInterface clinicalData = EasyMock.createMock( ClinicalDataResponseInterface.class );
        ExceptionLoggerInterface guaranteedLoggerMock = EasyMock.createNiceMock( ExceptionLoggerInterface.class );
        ErrorSectionHelperInterface errorSectionHelperMock = EasyMock.createMock( ErrorSectionHelperInterface.class );
        TemplateHelperInterface templateHelperMock = EasyMock.createMock( TemplateHelperInterface.class );
        ClinicalDataResponseInterface clinicalDataResponseMock = EasyMock.createMock( ClinicalDataResponseInterface.class );
        Document writeResultDocumentMock = EasyMock.createMock( Document.class );
        Document clinicalRequestDocumentMock = EasyMock.createMock( Document.class );
        Map<String, PathwaysDataResponseInterface> configurableResponseMapMock = EasyMock.createNiceMock( Map.class );

        // Set expectations
        EasyMock.expect( clinicalData.buildErrorResponse( templateId, requestId, null, clinicalRequestDocumentMock ) ).andReturn(writeResultDocumentMock );
        EasyMock.expect( clinicalDataResponseMock.buildEmptyClinicalDocumentWithoutPatient( templateId, requestId ) ).andReturn( writeResultDocumentMock );
        EasyMock.expect( templateHelperMock.getErrorSectionHelper( templateId ) ).andReturn( errorSectionHelperMock );
        EasyMock.expect( errorSectionHelperMock.buildErrorSection( EasyMock.isA( Document.class ), EasyMock.isA( ExceptionInfo.class ), EasyMock.eq( requestId ) ) ).andReturn( null );

        EasyMock.replay( clinicalData, guaranteedLoggerMock, errorSectionHelperMock, clinicalDataResponseMock, templateHelperMock, writeResultDocumentMock, configurableResponseMapMock, clinicalRequestDocumentMock );

        ExceptionHandler.setClinicalDataResponse( clinicalDataResponseMock );
        ExceptionHandler.setTemplateHelper( templateHelperMock );
        ExceptionHandler.setGuaranteedLogger( guaranteedLoggerMock );
        ExceptionHandler.setCdsAppName( CDS_APP_NAME );
        ExceptionHandler.setPathwaysConfigurableResponseMap( configurableResponseMapMock );
        ( ( WriteResponseGenerator )generator ).setClinicalDataResponse( clinicalData );
        ( ( WriteResponseGenerator )generator ).setCreatedIdentifierResponseTemplates( createdIdentifierResponseTemplates );

        generator.generateWriteErrorResponse( templateId, requestId, exception, clinicalRequestDocumentMock, CDS_APP_NAME );

        EasyMock.verify( errorSectionHelperMock, clinicalDataResponseMock, templateHelperMock, writeResultDocumentMock);
    }
}
