

package gov.va.med.cds.response.strategy;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.ClassPathResource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.Assert;


@RunWith( SuiteAwareRunner.class )
public class ReferenceMappingVistaResponseBlobStrategyTest
{
    public static final String stream = "<Def>APPOINTMENT IEN^PATIENT IEN^PATIENT^APPOINTMENT DATE^EXAM LOCATION IEN^EXAM LOCATION^EXAM LOCATION PHONE^EXAM LOCATION OFFICE IEN^EXAM LOCATION OFFICE NAME^EXAM LOCATION SHORT NAME^EXAM LOCATION STATION NUMBER^EXAM LOCATION OFFICIAL VA NAME^APPOINTMENT STATUS IEN^APPOINTMENT STATUS^EXAM CATEGORY IEN^EXAM CATEGORY^EKG DATE/TIME^X-RAY DATE/TIME^LAB DATE/TIME^STATUS IEN^STATUS^</Def>\n"
                    + "--Appointment IEN--^100600^FOURHUNDREDEIGHTYEIGHT,PAT^3030512.1345^23^GENERAL MEDICINE^259^500^CAMP MASTER^CAMP^500^2^--APPOINTMENT STATUS IEN--^SCHEDULED/KEPT^9^REGULAR^^^^--STATUS IEN--^NO ACTION TAKEN^";

    ReferenceMappingVistaResponseBlobStrategy responseStrategy = null;

    List<Map<String, Object>> resultList = null;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEachTest( )
    {
        responseStrategy = new ReferenceMappingVistaResponseBlobStrategy();
        Map<String, Object> firstRow = new HashMap<String, Object>();
        firstRow.put( "stream", stream.getBytes() );
        resultList = new ArrayList<Map<String, Object>>();
        resultList.add( firstRow );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResultList( )
        throws Exception
    {
        List<Map<String, Object>> newResultList = responseStrategy.formatResultList( resultList );
        Assert.assertEquals( 1, newResultList.size() );
        Assert.assertEquals( 19, newResultList.get( 0 ).size() );
        Assert.assertEquals( "--Appointment IEN--", newResultList.get( 0 ).get( "APPOINTMENT IEN" ) );
        Assert.assertEquals( "100600", newResultList.get( 0 ).get( "PATIENT IEN" ) );
        Assert.assertEquals( "FOURHUNDREDEIGHTYEIGHT,PAT", newResultList.get( 0 ).get( "PATIENT" ) );
        Assert.assertEquals( "3030512.1345", newResultList.get( 0 ).get( "APPOINTMENT DATE" ) );
        Assert.assertEquals( "23", newResultList.get( 0 ).get( "EXAM LOCATION IEN" ) );
        Assert.assertEquals( "GENERAL MEDICINE", newResultList.get( 0 ).get( "EXAM LOCATION" ) );
        Assert.assertEquals( "259", newResultList.get( 0 ).get( "EXAM LOCATION PHONE" ) );
        Assert.assertEquals( "500", newResultList.get( 0 ).get( "EXAM LOCATION OFFICE IEN" ) );
        Assert.assertEquals( "CAMP MASTER", newResultList.get( 0 ).get( "EXAM LOCATION OFFICE NAME" ) );
        Assert.assertEquals( "CAMP", newResultList.get( 0 ).get( "EXAM LOCATION SHORT NAME" ) );
        Assert.assertEquals( "500", newResultList.get( 0 ).get( "EXAM LOCATION STATION NUMBER" ) );
        Assert.assertEquals( "2", newResultList.get( 0 ).get( "EXAM LOCATION OFFICIAL VA NAME" ) );
        Assert.assertEquals( "--APPOINTMENT STATUS IEN--", newResultList.get( 0 ).get( "APPOINTMENT STATUS IEN" ) );
        Assert.assertEquals( "SCHEDULED/KEPT", newResultList.get( 0 ).get( "APPOINTMENT STATUS" ) );
        Assert.assertEquals( "9", newResultList.get( 0 ).get( "EXAM CATEGORY IEN" ) );
        Assert.assertEquals( "REGULAR", newResultList.get( 0 ).get( "EXAM CATEGORY" ) );
        Assert.assertEquals( null, newResultList.get( 0 ).get( "EKG DATE/TIME" ) );
        Assert.assertEquals( null, newResultList.get( 0 ).get( "X-RAY DATE/TIME" ) );
        Assert.assertEquals( null, newResultList.get( 0 ).get( "LAB DATE/TIME^STATUS IEN^STATUS" ) );
        Assert.assertEquals( "--STATUS IEN--", newResultList.get( 0 ).get( "STATUS IEN" ) );
        Assert.assertEquals( "NO ACTION TAKEN", newResultList.get( 0 ).get( "STATUS" ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResponse( )
        throws Exception
    {
        Map<String, ClassPathResource> refXmlMap = new HashMap<String, ClassPathResource>();

        ClassPathResource classPathResource = new ClassPathResource( "resources/rpcmappings/vrm/AppointmentsRead1.xml" );
        refXmlMap.put( "Appointment-AppointmentsRead1", classPathResource );
        responseStrategy.setRefXmlMap( refXmlMap );
        Element element = responseStrategy.formatResponse( resultList, "Appointment", "AppointmentsRead1" );
        Assert.assertNotNull( element );
        Assert.assertEquals( "results", element.getName() );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResponseForExam1( )
        throws Exception
    {
        Map<String, ClassPathResource> refXmlMap = new HashMap<String, ClassPathResource>();

        ClassPathResource classPathResource = new ClassPathResource( "resources/rpcmappings/vrm/ExamRead1.xml" );
        refXmlMap.put( "Exam2507-RequestsAndExamsRead1", classPathResource );
        responseStrategy.setRefXmlMap( refXmlMap );
        Element element = responseStrategy.formatResponse( resultList, "Exam2507", "RequestsAndExamsRead1" );
        Assert.assertNotNull( element );
        Assert.assertEquals( "results", element.getName() );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResponseForExam2( )
        throws Exception
    {
        Map<String, ClassPathResource> refXmlMap = new HashMap<String, ClassPathResource>();

        ClassPathResource classPathResource = new ClassPathResource( "resources/rpcmappings/vrm/ExamRead2.xml" );
        refXmlMap.put( "Exam2507-RequestsAndExamsRead2", classPathResource );
        responseStrategy.setRefXmlMap( refXmlMap );
        Element element = responseStrategy.formatResponse( resultList, "Exam2507", "RequestsAndExamsRead2" );
        Assert.assertNotNull( element );
        Assert.assertEquals( "results", element.getName() );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResponseForExamRequestExam1( )
        throws Exception
    {
        Map<String, ClassPathResource> refXmlMap = new HashMap<String, ClassPathResource>();

        ClassPathResource classPathResource = new ClassPathResource( "resources/rpcmappings/vrm/ExamRequestRead1.xml" );
        refXmlMap.put( "ExamRequest2507-RequestsAndExamsRead1", classPathResource );
        responseStrategy.setRefXmlMap( refXmlMap );
        Element element = responseStrategy.formatResponse( resultList, "ExamRequest2507", "RequestsAndExamsRead1" );
        Assert.assertNotNull( element );
        Assert.assertEquals( "results", element.getName() );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatResponseForExamRequestExam2( )
        throws Exception
    {
        Map<String, ClassPathResource> refXmlMap = new HashMap<String, ClassPathResource>();

        ClassPathResource classPathResource = new ClassPathResource( "resources/rpcmappings/vrm/ExamRequestRead1.xml" );
        refXmlMap.put( "ExamRequest2507-RequestsAndExamsRead2", classPathResource );
        responseStrategy.setRefXmlMap( refXmlMap );
        Element element = responseStrategy.formatResponse( resultList, "ExamRequest2507", "RequestsAndExamsRead2" );
        Assert.assertNotNull( element );
        Assert.assertEquals( "results", element.getName() );
    }
}
