

package gov.va.med.cds.response.sequencer;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.template.AbstractTemplateManagerTest;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.testharness.xml.XmlCompareException;

import org.dom4j.Document;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class ResponseSchemaSequencerTest
    extends
        AbstractTemplateManagerTest
{
    private static boolean validateReadResponseXml = true;


    @Test
    @Suite( groups = "checkintest" )
    public void testUnsequenced_PharmacyRead40010( )
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>PharmacyRead40010</templateId> <requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId> <patient> <outpatientMedicationPromises> <recordIdentifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </recordIdentifier> <pdtsPrescriptionId>PdtsPrescriptionId</pdtsPrescriptionId> <prescriptionId>PrescriptionId</prescriptionId> <pharmacyPatientType>PharmacyPatientType</pharmacyPatientType> <specialDrugTracking> <totalDailyDosage> <value>1.0</value> <unit> <code>test_code_2005</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </totalDailyDosage> <wbcObservation> <count> <value>10.0</value> <unit> <code>test_code_2004</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </count> <testDate> <literal>20100915162219</literal> </testDate> </wbcObservation> </specialDrugTracking> <dataEnterer> <comment>DataEnterer</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_3</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </dataEnterer> <pharmacyRequest> <cosigner> <comment>Cosigner</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_13002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </cosigner> <orderedMedication> <cmopDrugCode> <code>test_code_2002</code> <displayText>OrderedMedication CmopDrugCdDisplayTextLite</displayText> <codingSystem>OrderedMedication CmopDrugCdCodingSystemLite</codingSystem> </cmopDrugCode> <medicationCode> <code>test_code_2002</code> <displayText> Med Alt CodeDisplayTextLite</displayText> <codingSystem> Med Alt CodeCodingSystemLite</codingSystem> <alternateCode> Med Alt Codetest_altcode_3005</alternateCode> <alternateDisplayText> Med Alt CodeAltDisplayTextLite</alternateDisplayText> <alternateCodingSystem> Med Alt CodeAltCodingSystem</alternateCodingSystem> </medicationCode> <otcCode> <code>test_code_2002</code> <displayText>OrderedMedication NDFCdDisplayTextLite</displayText> <codingSystem>OrderedMedication NDFCdCodingSystemLite</codingSystem> </otcCode> <tradeName> <code>test_code_2002</code> <displayText>OrderedMedication TradeNmDisplayTextLite</displayText> <codingSystem>OrderedMedication TradeNmCodingSystemLite</codingSystem> </tradeName> </orderedMedication> <genericRequestIdentifier> <identity>ID_1284589339697</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_1284589339697</universalId> <universalIdType>universalIdType</universalIdType> </genericRequestIdentifier> <orderLocationIdentifier> <pointOfCare>PointOfCare</pointOfCare> <room>Room</room> <bed>Bed</bed> <facilityNamespaceId>FacilityNamespaceId</facilityNamespaceId> <facilityUniversalId>FacilityUniversalId</facilityUniversalId> <facilityUniversalIdType>FacilityUniversalIdType</facilityUniversalIdType> <personLocationType>PersonLocationType</personLocationType> <locationDescription>LocationDescription</locationDescription> </orderLocationIdentifier> <orderedItem> <itemCode> <code>test_code_2001</code> <displayText>OrderedItem ItemDisplayTextLite</displayText> <codingSystem>OrderedItem ItemCodingSystemLite</codingSystem> </itemCode> <dosageFormCode> <code>test_code_2001</code> <displayText>DosageFormDisplayTextLite</displayText> <codingSystem>DosageFormCodingSystemLite</codingSystem> </dosageFormCode> </orderedItem> <orderingInstitutionIdentifier> <identity>OrganizationId</identity> <name>OrganizationName</name> <assigningAuthority>AssigningAuthNamespaceId</assigningAuthority> </orderingInstitutionIdentifier> <orderDate> <literal>20100915162219</literal> </orderDate> <status>Status</status> <statusModifier> <code>test_code_2003</code> <displayText>StatusModifierDisplayTextLite</displayText> <codingSystem>StatusModifierCodingSystemLite</codingSystem> </statusModifier> </pharmacyRequest> <patient> <identifier> <identity>prasad_123</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lastDispenseDate> <literal>20100915162219</literal> </lastDispenseDate> <numberOfRefillsAuthorized>2</numberOfRefillsAuthorized> <patientInstructions>PatientInstructions-0</patientInstructions> <patientInstructions>PatientInstructions-1</patientInstructions> <otherPatientInstructions>OtherPatientInstructions-0</otherPatientInstructions> <otherPatientInstructions>OtherPatientInstructions-1</otherPatientInstructions> <expandedPatientInstructions>ExpandedPatientInstructions-0</expandedPatientInstructions> <expandedPatientInstructions>ExpandedPatientInstructions-1</expandedPatientInstructions> <pharmacyInstructions>PharmacyInstructions-0</pharmacyInstructions> <pharmacyInstructions>PharmacyInstructions-1</pharmacyInstructions> <sig>Sig-0</sig> <sig>Sig-1</sig> <digitalSignatureIndicator> <code>test_code_2005</code> <displayText>DigitalSignatureIndicatorDisplayTextLite</displayText> <codingSystem>DigitalSignatureIndicatorCodingSystemLite</codingSystem> </digitalSignatureIndicator> <copayTransactionType> <code>test_code_2005</code> <displayText>CopayTransactionTypeDisplayTextLite</displayText> <codingSystem>CopayTransactionTypeCodingSystemLite</codingSystem> </copayTransactionType> <transitionalRxBenefit> <code>test_code_2002</code> <displayText>TransitionalRxBenefitDisplayTextLite</displayText> <codingSystem>TransitionalRxBenefitCodingSystemLite</codingSystem> </transitionalRxBenefit> <treatmentFactor> <factor> <code>test_code_2005</code> <displayText>FactorDisplayTextLite</displayText> <codingSystem>FactorCodingSystemLite</codingSystem> </factor> <factorValue> <code>test_code_2004</code> <displayText>FactorValueDisplayTextLite</displayText> <codingSystem>FactorValueCodingSystemLite</codingSystem> </factorValue> </treatmentFactor> <originalDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2001</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERID_7003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2001</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2002</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2004</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2001</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2001</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>OriginalnewLotId</lotId> <ndc> <code>test_code_2003</code> <displayText>OriginalNdcDisplayTextLite</displayText> <codingSystem>OriginalNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2003</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </originalDispense> <refillDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2005</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2001</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2003</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2005</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2002</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2002</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>RefillnewLotId</lotId> <ndc> <code>test_code_2001</code> <displayText>RefillNdcDisplayTextLite</displayText> <codingSystem>RefillNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2003</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </refillDispense> <refillDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2002</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2003</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2005</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2005</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2002</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2004</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>RefillnewLotId</lotId> <ndc> <code>test_code_2004</code> <displayText>RefillNdcDisplayTextLite</displayText> <codingSystem>RefillNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2002</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </refillDispense> <partialDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2002</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933971310000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933971310000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2002</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2002</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2002</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2005</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2001</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>PartialnewLotId</lotId> <ndc> <code>test_code_2004</code> <displayText>PartialNdcDisplayTextLite</displayText> <codingSystem>PartialNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2003</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </partialDispense> <partialDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2004</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933971310000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933971310000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2002</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2001</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2001</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2001</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2001</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>PartialnewLotId</lotId> <ndc> <code>test_code_2005</code> <displayText>PartialNdcDisplayTextLite</displayText> <codingSystem>PartialNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2004</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </partialDispense> <cancel> <cancelDate> <literal>20100915162219</literal> </cancelDate> <comments>CancelAct_Comment-0</comments> <comments>CancelAct_Comment-1</comments> </cancel> <medicationInstructions> <conjunction> <code>test_code_2003</code> <displayText>ConjunctionDisplayTextLite</displayText> <codingSystem>ConjunctionCodingSystemLite</codingSystem> </conjunction> <dispenseUnitsPerDose>15.0</dispenseUnitsPerDose> <dosageOrdered>DosageOrdered</dosageOrdered> <noun> <code>test_code_2001</code> <displayText>NounDisplayTextLite</displayText> <codingSystem>NounCodingSystemLite</codingSystem> </noun> <route> <code>test_code_2005</code> <displayText>RouteDisplayTextLite</displayText> <codingSystem>RouteCodingSystemLite</codingSystem> </route> <schedule> <code>test_code_2002</code> <displayText>ScheduleDisplayTextLite</displayText> <codingSystem>ScheduleCodingSystemLite</codingSystem> </schedule> <verb> <code>test_code_2004</code> <displayText>VerbDisplayTextLite</displayText> <codingSystem>VerbCodingSystemLite</codingSystem> </verb> <giveUnits> <code>test_code_2002</code> <displayText>VistaGiveUnitsDisplayTextLite</displayText> <codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem> </giveUnits> <intendedDuration>IntendedDuration</intendedDuration> </medicationInstructions> <medicationInstructions> <conjunction> <code>test_code_2005</code> <displayText>ConjunctionDisplayTextLite</displayText> <codingSystem>ConjunctionCodingSystemLite</codingSystem> </conjunction> <dispenseUnitsPerDose>15.0</dispenseUnitsPerDose> <dosageOrdered>DosageOrdered</dosageOrdered> <noun> <code>test_code_2003</code> <displayText>NounDisplayTextLite</displayText> <codingSystem>NounCodingSystemLite</codingSystem> </noun> <route> <code>test_code_2005</code> <displayText>RouteDisplayTextLite</displayText> <codingSystem>RouteCodingSystemLite</codingSystem> </route> <schedule> <code>test_code_2004</code> <displayText>ScheduleDisplayTextLite</displayText> <codingSystem>ScheduleCodingSystemLite</codingSystem> </schedule> <verb> <code>test_code_2004</code> <displayText>VerbDisplayTextLite</displayText> <codingSystem>VerbCodingSystemLite</codingSystem> </verb> <giveUnits> <code>test_code_2001</code> <displayText>VistaGiveUnitsDisplayTextLite</displayText> <codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem> </giveUnits> <intendedDuration>IntendedDuration</intendedDuration> </medicationInstructions> <finisher> <comment>Finisher Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_FINISHERID_7003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </finisher> <activityLog> <activityDate> <literal>20100915162219</literal> </activityDate> <reason> <code>test_code_2002</code> <displayText>ReasonDisplayTextLite</displayText> <codingSystem>ReasonCodingSystemLite</codingSystem> </reason> <initiator> <comment>Initiator Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_INITIATOR_17001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </initiator> <comment>ActivityLog Comment</comment> </activityLog> <activityLog> <activityDate> <literal>20100915162219</literal> </activityDate> <reason> <code>test_code_2005</code> <displayText>ReasonDisplayTextLite</displayText> <codingSystem>ReasonCodingSystemLite</codingSystem> </reason> <initiator> <comment>Initiator Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_INITIATOR_17003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </initiator> <comment>ActivityLog Comment</comment> </activityLog> <recordSource> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1284589339713100000</universalId> <universalIdType>universalIdType</universalIdType> </recordSource> <recordVersion>10000</recordVersion> <recordUpdateTime> <literal>20100915162219</literal> </recordUpdateTime> </outpatientMedicationPromises> </patient> </clinicaldata:ClinicalData>";
        String unsequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>PharmacyRead40010</templateId> <requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId> <patient> <outpatientMedicationPromises> <recordIdentifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </recordIdentifier> <prescriptionId>PrescriptionId</prescriptionId> <pdtsPrescriptionId>PdtsPrescriptionId</pdtsPrescriptionId> <pharmacyPatientType>PharmacyPatientType</pharmacyPatientType> <specialDrugTracking> <totalDailyDosage> <value>1.0</value> <unit> <code>test_code_2005</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </totalDailyDosage> <wbcObservation> <count> <value>10.0</value> <unit> <code>test_code_2004</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </count> <testDate> <literal>20100915162219</literal> </testDate> </wbcObservation> </specialDrugTracking> <dataEnterer> <comment>DataEnterer</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_3</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </dataEnterer> <pharmacyRequest> <cosigner> <comment>Cosigner</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_13002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </cosigner> <orderedMedication> <cmopDrugCode> <code>test_code_2002</code> <displayText>OrderedMedication CmopDrugCdDisplayTextLite</displayText> <codingSystem>OrderedMedication CmopDrugCdCodingSystemLite</codingSystem> </cmopDrugCode> <medicationCode> <code>test_code_2002</code> <displayText> Med Alt CodeDisplayTextLite</displayText> <codingSystem> Med Alt CodeCodingSystemLite</codingSystem> <alternateCode> Med Alt Codetest_altcode_3005</alternateCode> <alternateDisplayText> Med Alt CodeAltDisplayTextLite</alternateDisplayText> <alternateCodingSystem> Med Alt CodeAltCodingSystem</alternateCodingSystem> </medicationCode> <otcCode> <code>test_code_2002</code> <displayText>OrderedMedication NDFCdDisplayTextLite</displayText> <codingSystem>OrderedMedication NDFCdCodingSystemLite</codingSystem> </otcCode> <tradeName> <code>test_code_2002</code> <displayText>OrderedMedication TradeNmDisplayTextLite</displayText> <codingSystem>OrderedMedication TradeNmCodingSystemLite</codingSystem> </tradeName> </orderedMedication> <genericRequestIdentifier> <identity>ID_1284589339697</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_1284589339697</universalId> <universalIdType>universalIdType</universalIdType> </genericRequestIdentifier> <orderLocationIdentifier> <pointOfCare>PointOfCare</pointOfCare> <room>Room</room> <bed>Bed</bed> <facilityNamespaceId>FacilityNamespaceId</facilityNamespaceId> <facilityUniversalId>FacilityUniversalId</facilityUniversalId> <facilityUniversalIdType>FacilityUniversalIdType</facilityUniversalIdType> <personLocationType>PersonLocationType</personLocationType> <locationDescription>LocationDescription</locationDescription> </orderLocationIdentifier> <orderedItem> <itemCode> <code>test_code_2001</code> <displayText>OrderedItem ItemDisplayTextLite</displayText> <codingSystem>OrderedItem ItemCodingSystemLite</codingSystem> </itemCode> <dosageFormCode> <code>test_code_2001</code> <displayText>DosageFormDisplayTextLite</displayText> <codingSystem>DosageFormCodingSystemLite</codingSystem> </dosageFormCode> </orderedItem> <orderingInstitutionIdentifier> <identity>OrganizationId</identity> <name>OrganizationName</name> <assigningAuthority>AssigningAuthNamespaceId</assigningAuthority> </orderingInstitutionIdentifier> <orderDate> <literal>20100915162219</literal> </orderDate> <status>Status</status> <statusModifier> <code>test_code_2003</code> <displayText>StatusModifierDisplayTextLite</displayText> <codingSystem>StatusModifierCodingSystemLite</codingSystem> </statusModifier> </pharmacyRequest> <patient> <identifier> <identity>prasad_123</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lastDispenseDate> <literal>20100915162219</literal> </lastDispenseDate> <numberOfRefillsAuthorized>2</numberOfRefillsAuthorized> <patientInstructions>PatientInstructions-0</patientInstructions> <patientInstructions>PatientInstructions-1</patientInstructions> <otherPatientInstructions>OtherPatientInstructions-0</otherPatientInstructions> <otherPatientInstructions>OtherPatientInstructions-1</otherPatientInstructions> <expandedPatientInstructions>ExpandedPatientInstructions-0</expandedPatientInstructions> <expandedPatientInstructions>ExpandedPatientInstructions-1</expandedPatientInstructions> <pharmacyInstructions>PharmacyInstructions-0</pharmacyInstructions> <pharmacyInstructions>PharmacyInstructions-1</pharmacyInstructions> <sig>Sig-0</sig> <sig>Sig-1</sig> <digitalSignatureIndicator> <code>test_code_2005</code> <displayText>DigitalSignatureIndicatorDisplayTextLite</displayText> <codingSystem>DigitalSignatureIndicatorCodingSystemLite</codingSystem> </digitalSignatureIndicator> <copayTransactionType> <code>test_code_2005</code> <displayText>CopayTransactionTypeDisplayTextLite</displayText> <codingSystem>CopayTransactionTypeCodingSystemLite</codingSystem> </copayTransactionType> <transitionalRxBenefit> <code>test_code_2002</code> <displayText>TransitionalRxBenefitDisplayTextLite</displayText> <codingSystem>TransitionalRxBenefitCodingSystemLite</codingSystem> </transitionalRxBenefit> <treatmentFactor> <factor> <code>test_code_2005</code> <displayText>FactorDisplayTextLite</displayText> <codingSystem>FactorCodingSystemLite</codingSystem> </factor> <factorValue> <code>test_code_2004</code> <displayText>FactorValueDisplayTextLite</displayText> <codingSystem>FactorValueCodingSystemLite</codingSystem> </factorValue> </treatmentFactor> <originalDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2001</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERID_7003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2001</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2002</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2004</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2001</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2001</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>OriginalnewLotId</lotId> <ndc> <code>test_code_2003</code> <displayText>OriginalNdcDisplayTextLite</displayText> <codingSystem>OriginalNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2003</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </originalDispense> <refillDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2005</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2001</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2003</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2005</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2002</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2002</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>RefillnewLotId</lotId> <ndc> <code>test_code_2001</code> <displayText>RefillNdcDisplayTextLite</displayText> <codingSystem>RefillNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2003</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </refillDispense> <refillDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2002</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933969710000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933969710000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2003</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2005</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2005</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2002</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2004</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>RefillnewLotId</lotId> <ndc> <code>test_code_2004</code> <displayText>RefillNdcDisplayTextLite</displayText> <codingSystem>RefillNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2002</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </refillDispense> <partialDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2002</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933971310000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933971310000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2002</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2002</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2002</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2005</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2001</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>PartialnewLotId</lotId> <ndc> <code>test_code_2004</code> <displayText>PartialNdcDisplayTextLite</displayText> <codingSystem>PartialNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2003</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </partialDispense> <partialDispense> <comments>Comments-0</comments> <comments>Comments-1</comments> <dispenseDate> <literal>20100915162219</literal> </dispenseDate> <fillDate> <literal>20100915162219</literal> </fillDate> <quantityDispensed> <value>1.0</value> <unit> <code>test_code_2004</code> <displayText>UnitDisplayTextLite</displayText> <codingSystem>UnitCodingSystemLite</codingSystem> </unit> </quantityDispensed> <currentProvider> <identifier> <identity>test_PROVIDERD_7001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </currentProvider> <currentProviderComments>ProviderComments-0</currentProviderComments> <currentProviderComments>ProviderComments-1</currentProviderComments> <loginDate> <literal>20100915162219</literal> </loginDate> <daysSupply>5</daysSupply> <identifier> <identity>ID_128458933971310000</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_128458933971310000</universalId> <universalIdType>universalIdType</universalIdType> </identifier> <levelOfUnderstanding> <code>test_code_2002</code> <displayText>LevelOfUnderstandingDisplayTextLite</displayText> <codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem> </levelOfUnderstanding> <mailWindow>MailWindow</mailWindow> <releaseDate> <literal>20100915162219</literal> </releaseDate> <wasPatientCounseled> <code>test_code_2001</code> <displayText>WasPatientCounseledDisplayTextLite</displayText> <codingSystem>WasPatientCounseledCodingSystemLite</codingSystem> </wasPatientCounseled> <division> <divisionId> <code>test_code_2001</code> <displayText>DivisionIdDisplayTextLite</displayText> <codingSystem>DivisionIdCodingSystemLite</codingSystem> </divisionId> <ncpdpId> <code>test_code_2001</code> <displayText>NcpdpIdDisplayTextLite</displayText> <codingSystem>NcpdpIdCodingSystemLite</codingSystem> </ncpdpId> </division> <dispensedDrug> <drugUnitPrice> <currency> <code>test_code_2001</code> <displayText>CurrencyDisplayTextLite</displayText> <codingSystem>CurrencyCodingSystemLite</codingSystem> </currency> <value>0.0</value> </drugUnitPrice> <expirationDate> <literal>20100915162219</literal> </expirationDate> <lotId>PartialnewLotId</lotId> <ndc> <code>test_code_2005</code> <displayText>PartialNdcDisplayTextLite</displayText> <codingSystem>PartialNdcCodingSystemLite</codingSystem> </ndc> </dispensedDrug> <pharmacist> <comment>Pharmacist Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_IDS_6001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </pharmacist> <cmopEventStatus> <code>test_code_2004</code> <displayText>CmopEventStatusDisplayTextLite</displayText> <codingSystem>CmopEventStatusCodingSystemLite</codingSystem> </cmopEventStatus> <numberOfRefillsRemaining>13</numberOfRefillsRemaining> </partialDispense> <cancel> <cancelDate> <literal>20100915162219</literal> </cancelDate> <comments>CancelAct_Comment-0</comments> <comments>CancelAct_Comment-1</comments> </cancel> <medicationInstructions> <conjunction> <code>test_code_2003</code> <displayText>ConjunctionDisplayTextLite</displayText> <codingSystem>ConjunctionCodingSystemLite</codingSystem> </conjunction> <dispenseUnitsPerDose>15.0</dispenseUnitsPerDose> <dosageOrdered>DosageOrdered</dosageOrdered> <noun> <code>test_code_2001</code> <displayText>NounDisplayTextLite</displayText> <codingSystem>NounCodingSystemLite</codingSystem> </noun> <route> <code>test_code_2005</code> <displayText>RouteDisplayTextLite</displayText> <codingSystem>RouteCodingSystemLite</codingSystem> </route> <schedule> <code>test_code_2002</code> <displayText>ScheduleDisplayTextLite</displayText> <codingSystem>ScheduleCodingSystemLite</codingSystem> </schedule> <verb> <code>test_code_2004</code> <displayText>VerbDisplayTextLite</displayText> <codingSystem>VerbCodingSystemLite</codingSystem> </verb> <giveUnits> <code>test_code_2002</code> <displayText>VistaGiveUnitsDisplayTextLite</displayText> <codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem> </giveUnits> <intendedDuration>IntendedDuration</intendedDuration> </medicationInstructions> <medicationInstructions> <conjunction> <code>test_code_2005</code> <displayText>ConjunctionDisplayTextLite</displayText> <codingSystem>ConjunctionCodingSystemLite</codingSystem> </conjunction> <dispenseUnitsPerDose>15.0</dispenseUnitsPerDose> <dosageOrdered>DosageOrdered</dosageOrdered> <noun> <code>test_code_2003</code> <displayText>NounDisplayTextLite</displayText> <codingSystem>NounCodingSystemLite</codingSystem> </noun> <route> <code>test_code_2005</code> <displayText>RouteDisplayTextLite</displayText> <codingSystem>RouteCodingSystemLite</codingSystem> </route> <schedule> <code>test_code_2004</code> <displayText>ScheduleDisplayTextLite</displayText> <codingSystem>ScheduleCodingSystemLite</codingSystem> </schedule> <verb> <code>test_code_2004</code> <displayText>VerbDisplayTextLite</displayText> <codingSystem>VerbCodingSystemLite</codingSystem> </verb> <giveUnits> <code>test_code_2001</code> <displayText>VistaGiveUnitsDisplayTextLite</displayText> <codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem> </giveUnits> <intendedDuration>IntendedDuration</intendedDuration> </medicationInstructions> <finisher> <comment>Finisher Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_FINISHERID_7003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </finisher> <activityLog> <activityDate> <literal>20100915162219</literal> </activityDate> <reason> <code>test_code_2002</code> <displayText>ReasonDisplayTextLite</displayText> <codingSystem>ReasonCodingSystemLite</codingSystem> </reason> <initiator> <comment>Initiator Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_INITIATOR_17001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </initiator> <comment>ActivityLog Comment</comment> </activityLog> <activityLog> <activityDate> <literal>20100915162219</literal> </activityDate> <reason> <code>test_code_2005</code> <displayText>ReasonDisplayTextLite</displayText> <codingSystem>ReasonCodingSystemLite</codingSystem> </reason> <initiator> <comment>Initiator Comment</comment> <time> <literal>20100915162219</literal> </time> <practitioner> <identifier> <identity>test_INITIATOR_17003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </initiator> <comment>ActivityLog Comment</comment> </activityLog> <recordSource> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1284589339713100000</universalId> <universalIdType>universalIdType</universalIdType> </recordSource> <recordVersion>10000</recordVersion> <recordUpdateTime> <literal>20100915162219</literal> </recordUpdateTime> </outpatientMedicationPromises> </patient> </clinicaldata:ClinicalData>";
        String templateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );
        Document resultDoc = sequencer.sequence( templateId, unsequencedXml, validateReadResponseXml );
        assertNotNull( resultDoc );

        try
        {
            XmlComparator.assertXMLSimilar( sequencedXml, resultDoc.asXML() );
        }
        catch ( XmlCompareException xce )
        {
            fail();
        }

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testUnsequenced_AllergyAssessmentRead40010( )
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>AllergyAssessmentRead40010</templateId> <requestId>552ADDB2-0C22-FE1C-B864-6B464E9AA4E5</requestId> <patient> <requestedResolvedIdentifiers> <identity>test_AA_10004</identity> <assigningFacility>605</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifiers> <requestedResolvedIdentifiers> <identity>test_BB_10004</identity> <assigningFacility>605</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifiers> <allergyAssessments> <recordIdentifier> <identity>ID_1282338941885</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_1282338941885</universalId> <universalIdType>universalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>test_AA_10004</identity> <assigningFacility>605</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <observationTime> <literal>20100820151541</literal> </observationTime> <assessmentValue> <code>test_code_2001</code> <displayText>codePrefix_?DisplayTextLite</displayText> <codingSystem>codePrefix_?CodingSystemLite</codingSystem> </assessmentValue> <status>Status</status> <author> <comment>Author Comment</comment> <time> <literal>20100820151541</literal> </time> <practitioner> <identifier> <identity>test_authorid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> <recordSource> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1282338941880100000</universalId> <universalIdType>universalIdType</universalIdType> </recordSource> <recordVersion>1</recordVersion> <recordUpdateTime> <literal>20100820151541</literal> </recordUpdateTime> </allergyAssessments> </patient> </clinicaldata:ClinicalData>";
        String unsequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>AllergyAssessmentRead40010</templateId> <requestId>552ADDB2-0C22-FE1C-B864-6B464E9AA4E5</requestId> <patient> <requestedResolvedIdentifiers> <identity>test_AA_10004</identity> <assigningFacility>605</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifiers> <requestedResolvedIdentifiers> <identity>test_BB_10004</identity> <assigningFacility>605</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifiers> <allergyAssessments> <recordIdentifier> <identity>ID_1282338941885</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>UID_1282338941885</universalId> <universalIdType>universalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>test_AA_10004</identity> <assigningAuthority>USVHA</assigningAuthority> <assigningFacility>605</assigningFacility> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <observationTime> <literal>20100820151541</literal> </observationTime> <assessmentValue> <code>test_code_2001</code> <displayText>codePrefix_?DisplayTextLite</displayText> <codingSystem>codePrefix_?CodingSystemLite</codingSystem> </assessmentValue> <status>Status</status> <author> <comment>Author Comment</comment> <time> <literal>20100820151541</literal> </time> <practitioner> <identifier> <identity>test_authorid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> <recordSource> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1282338941880100000</universalId> <universalIdType>universalIdType</universalIdType> </recordSource> <recordVersion>1</recordVersion> <recordUpdateTime> <literal>20100820151541</literal> </recordUpdateTime> </allergyAssessments> </patient> </clinicaldata:ClinicalData>";
        String templateId = TemplateIdHelper.ALLERGY_ASSESSMENT_READ_TEMPLATE_ID;
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );
        Document resultDoc = sequencer.sequence( templateId, unsequencedXml, validateReadResponseXml );
        assertNotNull( resultDoc );

        try
        {
            XmlComparator.assertXMLSimilar( sequencedXml, resultDoc.asXML() );
        }
        catch ( XmlCompareException xce )
        {
            fail();
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testUnsequenced_IntoleranceConditionRead40010( )
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>IntoleranceConditionRead40010</templateId> <requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId> <patient> <requestedResolvedIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </requestedResolvedIdentifiers> <resultantIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </resultantIdentifiers> <intoleranceConditions> <recordIdentifier> <identity>FNTest_Intolerance_Condition_identity</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1204757305879100021</universalId> <universalIdType>aUniversalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <observationTime> <literal>196912311PORT0</literal> </observationTime> <agent> <code>Other3</code> <displayText>AgentDisplayTextLite</displayText> <codingSystem>AgentCodingSystemLite</codingSystem> </agent> <allergyType> <code>Other</code> <displayText>AllergyTypeDisplayTextLite</displayText> <codingSystem>AllergyTypeCodingSystemLite</codingSystem> </allergyType> <gmrAllergyAgent> <code>Other3</code> <displayText>AgentDisplayText</displayText> <codingSystem>AgentCodingSystem</codingSystem> <alternateCode>Agenttest_altcode_3004</alternateCode> <alternateDisplayText>AgentAltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>AgentAltCodingSystem</alternateCodingSystem> </gmrAllergyAgent> <informationSourceCategory> <code>test_code_2003</code> <displayText>ISC DisplayTextLite</displayText> <codingSystem>ISC CodingSystemLite</codingSystem> </informationSourceCategory> <mechanism> <code>test_code_2005</code> <displayText>Mechanism DisplayTextLite</displayText> <codingSystem>Mechanism CodingSystemLite</codingSystem> </mechanism> <status>Status</status> <verified>true</verified> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2002</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2003</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <verifier> <comment>Verifier Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_VERIFIERID_2002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </verifier> <author> <comment>Author Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_AUTHORID_1003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> <errorEnterer> <comment>ErrorEnterer Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_ERRORENTERERID_5004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </errorEnterer> <idBandMarker> <comment>ID Band Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <idBandMarker> <comment>ID Band Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <chartMarker> <comment>Chart Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <chartMarker> <comment>Chart Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <drugClass> <code> <code>Class6</code> <displayText>Drug Class 2DisplayText</displayText> <codingSystem>Drug Class 2CodingSystem</codingSystem> <alternateCode>Drug Class 2test_altcode_3005</alternateCode> <alternateDisplayText>Drug Class 2AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 2AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugClass> <code> <code>Class4</code> <displayText>Drug Class 1DisplayText</displayText> <codingSystem>Drug Class 1CodingSystem</codingSystem> <alternateCode>Drug Class 1test_altcode_3001</alternateCode> <alternateDisplayText>Drug Class 1AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 1AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugIngredient> <code> <code>Ingredient3</code> <displayText>Drug Ing. 2DisplayTextLite</displayText> <codingSystem>Drug Ing. 2CodingSystemLite</codingSystem> </code> </drugIngredient> <drugIngredient> <code> <code>Ingredient6</code> <displayText>Drug Ing. 1DisplayTextLite</displayText> <codingSystem>Drug Ing. 1CodingSystemLite</codingSystem> </code> </drugIngredient> <facilityIdentifier> <identity>OrganizationId</identity> <name>OrganizationName</name> <assigningAuthority>AssigningAuthNamespaceId</assigningAuthority> </facilityIdentifier> <recordVersion>10002</recordVersion> <recordUpdateTime> <literal>20080305154825</literal> </recordUpdateTime> </intoleranceConditions> </patient> </clinicaldata:ClinicalData>";
        String unsequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>IntoleranceConditionRead40010</templateId> <requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId> <patient> <requestedResolvedIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </requestedResolvedIdentifiers> <resultantIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </resultantIdentifiers> <intoleranceConditions> <recordIdentifier> <identity>FNTest_Intolerance_Condition_identity</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1204757305879100021</universalId> <universalIdType>aUniversalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <agent> <code>Other3</code> <displayText>AgentDisplayTextLite</displayText> <codingSystem>AgentCodingSystemLite</codingSystem> </agent> <allergyType> <code>Other</code> <displayText>AllergyTypeDisplayTextLite</displayText> <codingSystem>AllergyTypeCodingSystemLite</codingSystem> </allergyType> <gmrAllergyAgent> <code>Other3</code> <displayText>AgentDisplayText</displayText> <codingSystem>AgentCodingSystem</codingSystem> <alternateCode>Agenttest_altcode_3004</alternateCode> <alternateDisplayText>AgentAltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>AgentAltCodingSystem</alternateCodingSystem> </gmrAllergyAgent> <observationTime> <literal>196912311PORT0</literal> </observationTime> <informationSourceCategory> <code>test_code_2003</code> <displayText>ISC DisplayTextLite</displayText> <codingSystem>ISC CodingSystemLite</codingSystem> </informationSourceCategory> <mechanism> <code>test_code_2005</code> <displayText>Mechanism DisplayTextLite</displayText> <codingSystem>Mechanism CodingSystemLite</codingSystem> </mechanism> <status>Status</status> <verified>true</verified> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2002</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2003</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <verifier> <comment>Verifier Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_VERIFIERID_2002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </verifier> <author> <comment>Author Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_AUTHORID_1003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> <errorEnterer> <comment>ErrorEnterer Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_ERRORENTERERID_5004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </errorEnterer> <idBandMarker> <comment>ID Band Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <idBandMarker> <comment>ID Band Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <chartMarker> <comment>Chart Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <chartMarker> <comment>Chart Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <drugClass> <code> <code>Class6</code> <displayText>Drug Class 2DisplayText</displayText> <codingSystem>Drug Class 2CodingSystem</codingSystem> <alternateCode>Drug Class 2test_altcode_3005</alternateCode> <alternateDisplayText>Drug Class 2AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 2AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugClass> <code> <code>Class4</code> <displayText>Drug Class 1DisplayText</displayText> <codingSystem>Drug Class 1CodingSystem</codingSystem> <alternateCode>Drug Class 1test_altcode_3001</alternateCode> <alternateDisplayText>Drug Class 1AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 1AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugIngredient> <code> <code>Ingredient3</code> <displayText>Drug Ing. 2DisplayTextLite</displayText> <codingSystem>Drug Ing. 2CodingSystemLite</codingSystem> </code> </drugIngredient> <drugIngredient> <code> <code>Ingredient6</code> <displayText>Drug Ing. 1DisplayTextLite</displayText> <codingSystem>Drug Ing. 1CodingSystemLite</codingSystem> </code> </drugIngredient> <facilityIdentifier> <identity>OrganizationId</identity> <name>OrganizationName</name> <assigningAuthority>AssigningAuthNamespaceId</assigningAuthority> </facilityIdentifier> <recordVersion>10002</recordVersion> <recordUpdateTime> <literal>20080305154825</literal> </recordUpdateTime> </intoleranceConditions> </patient> </clinicaldata:ClinicalData>";
        String templateId = TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );
        Document resultDoc = sequencer.sequence( templateId, unsequencedXml, validateReadResponseXml );
        assertNotNull( resultDoc );

        try
        {
            XmlComparator.assertXMLSimilar( sequencedXml, resultDoc.asXML() );
        }
        catch ( XmlCompareException xce )
        {
            fail();
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testUnsequencedWithErrorSection_IntoleranceConditionRead40010( )
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>IntoleranceConditionRead40010</templateId><requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId><patient><requestedResolvedIdentifiers><identity>talbotTest</identity><assigningFacility>intoleranceConditionTest</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></requestedResolvedIdentifiers><resultantIdentifiers><identity>talbotTest</identity><assigningFacility>intoleranceConditionTest</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></resultantIdentifiers><intoleranceConditions><recordIdentifier><identity>FNTest_Intolerance_Condition_identity</identity><namespaceId>DefaultAssigningFacility</namespaceId><universalId>1204757305879100021</universalId><universalIdType>aUniversalIdType</universalIdType></recordIdentifier><patient><identifier><identity>talbotTest</identity><assigningFacility>intoleranceConditionTest</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></patient><observationTime><literal>196912311PORT0</literal></observationTime><agent><code>Other3</code><displayText>AgentDisplayTextLite</displayText><codingSystem>AgentCodingSystemLite</codingSystem></agent><allergyType><code>Other</code><displayText>AllergyTypeDisplayTextLite</displayText><codingSystem>AllergyTypeCodingSystemLite</codingSystem></allergyType><gmrAllergyAgent><code>Other3</code><displayText>AgentDisplayText</displayText><codingSystem>AgentCodingSystem</codingSystem><alternateCode>Agenttest_altcode_3004</alternateCode><alternateDisplayText>AgentAltDisplayTextLite</alternateDisplayText><alternateCodingSystem>AgentAltCodingSystem</alternateCodingSystem></gmrAllergyAgent><informationSourceCategory><code>test_code_2003</code><displayText>ISC DisplayTextLite</displayText><codingSystem>ISC CodingSystemLite</codingSystem></informationSourceCategory><mechanism><code>test_code_2005</code><displayText>Mechanism DisplayTextLite</displayText><codingSystem>Mechanism CodingSystemLite</codingSystem></mechanism><status>Status</status><verified>true</verified><reaction><observationTime><literal>196912311PORT0</literal></observationTime><reaction><code>test_code_2002</code><displayText>Reaction DisplayTextLite</displayText><codingSystem>Reaction CodingSystemLite</codingSystem></reaction><author><comment>Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_eid_1004</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></author></reaction><reaction><observationTime><literal>196912311PORT0</literal></observationTime><reaction><code>test_code_2003</code><displayText>Reaction DisplayTextLite</displayText><codingSystem>Reaction CodingSystemLite</codingSystem></reaction><author><comment>Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_eid_1002</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></author></reaction><verifier><comment>Verifier Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_VERIFIERID_2002</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></verifier><author><comment>Author Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_AUTHORID_1003</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></author><errorEnterer><comment>ErrorEnterer Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_ERRORENTERERID_5004</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></errorEnterer><idBandMarker><comment>ID Band Marker 2 Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_IDBANDUPDATERID_3002</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></idBandMarker><idBandMarker><comment>ID Band Marker 1 Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_IDBANDUPDATERID_3002</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></idBandMarker><chartMarker><comment>Chart Marker 2 Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_CHARTMARKERID_4001</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></chartMarker><chartMarker><comment>Chart Marker 1 Comment</comment><time><literal>20080305154825</literal></time><practitioner><identifier><identity>test_CHARTMARKERID_4003</identity><assigningFacility>DefaultAssigningFacility</assigningFacility><assigningAuthority>DefaultAssigningAuthority</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></chartMarker><commentEvents><date><literal>String</literal></date><author><identifier><identity>String</identity><assigningFacility>String</assigningFacility><assigningAuthority>String</assigningAuthority></identifier><idSourceTable>String</idSourceTable><name><prefix>String</prefix><given>String</given><middle>String</middle><family>String</family><suffix>String</suffix><title>String</title></name></author><commentType><code>String</code><displayText>String</displayText><codingSystem>String</codingSystem></commentType><comments>String</comments><comments>String</comments></commentEvents><commentEvents><date><literal>String</literal></date><author><identifier><identity>String</identity><assigningFacility>String</assigningFacility><assigningAuthority>String</assigningAuthority></identifier><idSourceTable>String</idSourceTable><name><prefix>String</prefix><given>String</given><middle>String</middle><family>String</family><suffix>String</suffix><title>String</title></name></author><commentType><code>String</code><displayText>String</displayText><codingSystem>String</codingSystem></commentType><comments>String</comments><comments>String</comments></commentEvents><drugClass><code><code>Class6</code><displayText>Drug Class 2DisplayText</displayText><codingSystem>Drug Class 2CodingSystem</codingSystem><alternateCode>Drug Class 2test_altcode_3005</alternateCode><alternateDisplayText>Drug Class 2AltDisplayTextLite</alternateDisplayText><alternateCodingSystem>Drug Class 2AltCodingSystem</alternateCodingSystem></code></drugClass><drugClass><code><code>Class4</code><displayText>Drug Class 1DisplayText</displayText><codingSystem>Drug Class 1CodingSystem</codingSystem><alternateCode>Drug Class 1test_altcode_3001</alternateCode><alternateDisplayText>Drug Class 1AltDisplayTextLite</alternateDisplayText><alternateCodingSystem>Drug Class 1AltCodingSystem</alternateCodingSystem></code></drugClass><drugIngredient><code><code>Ingredient3</code><displayText>Drug Ing. 2DisplayTextLite</displayText><codingSystem>Drug Ing. 2CodingSystemLite</codingSystem></code></drugIngredient><drugIngredient><code><code>Ingredient6</code><displayText>Drug Ing. 1DisplayTextLite</displayText><codingSystem>Drug Ing. 1CodingSystemLite</codingSystem></code></drugIngredient><facilityIdentifier><identity>OrganizationId</identity><name>OrganizationName</name><assigningAuthority>AssigningAuthNamespaceId</assigningAuthority></facilityIdentifier><recordVersion>10002</recordVersion><recordUpdateTime><literal>20080305154825</literal></recordUpdateTime></intoleranceConditions></patient><errorSection><warnings><errorId>2E8AF431-EA0F-DC22-78E0-B01F7914AF6E</errorId><exception>gov.va.med.cds.persistence.PersistenceException</exception><exceptionMessage>READ_REQUEST_DATA_SOURCE_FAILURE</exceptionMessage><errorCode>READ_REQUEST_DATA_SOURCE_FAILURE</errorCode><displayMessage>Assigning Facility is 657. Patient ID is 7430122. Domain entry point is IntoleranceCondition. Database is VISTA-657-R. The Error reason is READ_REQUEST_DATA_SOURCE_FAILURE.</displayMessage></warnings></errorSection></clinicaldata:ClinicalData>";
        String unsequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>IntoleranceConditionRead40010</templateId> <requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId> <patient> <requestedResolvedIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </requestedResolvedIdentifiers> <resultantIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </resultantIdentifiers> <intoleranceConditions> <recordIdentifier> <identity>FNTest_Intolerance_Condition_identity</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1204757305879100021</universalId> <universalIdType>aUniversalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <agent> <code>Other3</code> <displayText>AgentDisplayTextLite</displayText> <codingSystem>AgentCodingSystemLite</codingSystem> </agent> <allergyType> <code>Other</code> <displayText>AllergyTypeDisplayTextLite</displayText> <codingSystem>AllergyTypeCodingSystemLite</codingSystem> </allergyType> <gmrAllergyAgent> <code>Other3</code> <displayText>AgentDisplayText</displayText> <codingSystem>AgentCodingSystem</codingSystem> <alternateCode>Agenttest_altcode_3004</alternateCode> <alternateDisplayText>AgentAltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>AgentAltCodingSystem</alternateCodingSystem> </gmrAllergyAgent> <observationTime> <literal>196912311PORT0</literal> </observationTime> <informationSourceCategory> <code>test_code_2003</code> <displayText>ISC DisplayTextLite</displayText> <codingSystem>ISC CodingSystemLite</codingSystem> </informationSourceCategory> <mechanism> <code>test_code_2005</code> <displayText>Mechanism DisplayTextLite</displayText> <codingSystem>Mechanism CodingSystemLite</codingSystem> </mechanism> <status>Status</status> <verified>true</verified> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2002</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2003</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <verifier> <comment>Verifier Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_VERIFIERID_2002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </verifier> <author> <comment>Author Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_AUTHORID_1003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> <errorEnterer> <comment>ErrorEnterer Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_ERRORENTERERID_5004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </errorEnterer> <idBandMarker> <comment>ID Band Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <idBandMarker> <comment>ID Band Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <chartMarker> <comment>Chart Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <chartMarker> <comment>Chart Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <drugClass> <code> <code>Class6</code> <displayText>Drug Class 2DisplayText</displayText> <codingSystem>Drug Class 2CodingSystem</codingSystem> <alternateCode>Drug Class 2test_altcode_3005</alternateCode> <alternateDisplayText>Drug Class 2AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 2AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugClass> <code> <code>Class4</code> <displayText>Drug Class 1DisplayText</displayText> <codingSystem>Drug Class 1CodingSystem</codingSystem> <alternateCode>Drug Class 1test_altcode_3001</alternateCode> <alternateDisplayText>Drug Class 1AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 1AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugIngredient> <code> <code>Ingredient3</code> <displayText>Drug Ing. 2DisplayTextLite</displayText> <codingSystem>Drug Ing. 2CodingSystemLite</codingSystem> </code> </drugIngredient> <drugIngredient> <code> <code>Ingredient6</code> <displayText>Drug Ing. 1DisplayTextLite</displayText> <codingSystem>Drug Ing. 1CodingSystemLite</codingSystem> </code> </drugIngredient> <facilityIdentifier> <identity>OrganizationId</identity> <name>OrganizationName</name> <assigningAuthority>AssigningAuthNamespaceId</assigningAuthority> </facilityIdentifier> <recordVersion>10002</recordVersion> <recordUpdateTime> <literal>20080305154825</literal> </recordUpdateTime> </intoleranceConditions> </patient> <errorSection><warnings><errorId>2E8AF431-EA0F-DC22-78E0-B01F7914AF6E</errorId><exception>gov.va.med.cds.persistence.PersistenceException</exception><exceptionMessage>READ_REQUEST_DATA_SOURCE_FAILURE</exceptionMessage><errorCode>READ_REQUEST_DATA_SOURCE_FAILURE</errorCode><displayMessage>Assigning Facility is 657. Patient ID is 7430122. Domain entry point is IntoleranceCondition. Database is VISTA-657-R. The Error reason is READ_REQUEST_DATA_SOURCE_FAILURE.</displayMessage></warnings></errorSection> </clinicaldata:ClinicalData>";
        String templateId = TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );
        Document resultDoc = sequencer.sequence( templateId, unsequencedXml, validateReadResponseXml );
        assertNotNull( resultDoc );
        try
        {
            XmlComparator.assertXMLSimilar( sequencedXml, resultDoc.asXML() );
        }
        catch ( XmlCompareException xce )
        {
            fail();
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testUnsequenced_VitalsignsRead40010( )
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>VitalsignsRead40010</templateId> <requestId>E851B78E-0807-1A28-E86C-E1B362624068</requestId> <patient> <requestedResolvedIdentifiers> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifiers> <resultantIdentifiers> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </resultantIdentifiers> <vitalSignObservationEvents> <recordIdentifier> <identity>ID_12774088531861</identity> <namespaceId>Default Namespace</namespaceId> <universalId>UID_12774088531861</universalId> <universalIdType>aUniversalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <observationTime> <literal>20081230</literal> </observationTime> <observationMethod> <code>observationMethodtest_code_200</code> <displayText>observationMethodDisplayTextLite</displayText> <codingSystem>observationMethodCodingSystemLite</codingSystem> </observationMethod> <observedCharacteristic> <code>obsCharCodetest_code_2002</code> <displayText>obsCharCodeDisplayTextLite</displayText> <codingSystem>obsCharCodeCodingSystemLite</codingSystem> </observedCharacteristic> <collectionSessionTime> <literal>20100624134733</literal> </collectionSessionTime> <status>Status</status> <supplementalOxygen> <flowRateValue>theSoFlowRateValue</flowRateValue> <flowRateUnit> <code>soFlowRateUofMtest_code_2001</code> <displayText>soFlowRateUofMDisplayTextLite</displayText> <codingSystem>soFlowRateUofMCodingSystemLite</codingSystem> </flowRateUnit> <concentrationValue>theSoConcentrationValue</concentrationValue> <concentrationUnit> <code>soConcentrationUofMtest_code_2</code> <displayText>soConcentrationUofMDisplayTextLite</displayText> <codingSystem>soConcentrationUofMCodingSystemLite</codingSystem> </concentrationUnit> </supplementalOxygen> <author> <comment>Comment</comment> <time> <literal>20100624134733</literal> </time> <practitioner> <identifier> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>author</prefix> <family>PRACTITIONER</family> </name> </practitioner> </author> <homeTelehealthMonitor> <vendor>HthVendor</vendor> <homeAppliance>HthHomeAppliance</homeAppliance> <measurementDevice>HthmeasurementDevice</measurementDevice> </homeTelehealthMonitor> <hospitalLocationIdentifier> <pointOfCare>PointOfCare</pointOfCare> <room>Room</room> <bed>Bed</bed> <facilityNamespaceId>FacilityNamespaceId</facilityNamespaceId> <facilityUniversalId>FacilityUniversalId</facilityUniversalId> <facilityUniversalIdType>FacilityUniversalIdType</facilityUniversalIdType> <personLocationType>PersonLocationType</personLocationType> <locationDescription>HospCode</locationDescription> </hospitalLocationIdentifier> <division> <code>divisiontest_code_2005</code> <displayText>divisionDisplayTextLite</displayText> <codingSystem>divisionCodingSystemLite</codingSystem> </division> <orderingFacilityIdentifier> <identity>orgId</identity> <name>ordFacility</name> <assigningAuthority>assgnAuth</assigningAuthority> </orderingFacilityIdentifier> <stopCode> <code>stoptest_code_2005</code> <displayText>stopDisplayTextLite</displayText> <codingSystem>stopCodingSystemLite</codingSystem> </stopCode> <vitalSignObservation> <value>theVitalValue</value> <unit> <code>obsUofMtest_code_2003</code> <displayText>obsUofMDisplayTextLite</displayText> <codingSystem>obsUofMCodingSystemLite</codingSystem> </unit> <qualifier> <value> <code>Qualifier1test_code_2001</code> <displayText>Qualifier1DisplayTextLite</displayText> <codingSystem>Qualifier1CodingSystemLite</codingSystem> </value> </qualifier> <qualifier> <value> <code>Qualifier2test_code_2002</code> <displayText>Qualifier2DisplayTextLite</displayText> <codingSystem>Qualifier2CodingSystemLite</codingSystem> </value> </qualifier> </vitalSignObservation> <errorEnterer> <comment>Comment</comment> <time> <literal>20100624134733</literal> </time> <practitioner> <identifier> <identity>test_eid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <idSourceTable>thePractitionerIdSourceTable</idSourceTable> <name> <prefix>errorEnterer</prefix> <family>PRACTITIONER</family> </name> </practitioner> </errorEnterer> <errorReason> <reason> <code>errorReasontest_code_2001</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <errorReason> <reason> <code>errorReasontest_code_2002</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <errorReason> <reason> <code>errorReasontest_code_2001</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <errorReason> <reason> <code>errorReasontest_code_2002</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <recordVersion>0</recordVersion> <recordUpdateTime> <literal>20100624134733</literal> </recordUpdateTime> </vitalSignObservationEvents> </patient> </clinicaldata:ClinicalData>";
        String unsequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>VitalsignsRead40010</templateId> <requestId>E851B78E-0807-1A28-E86C-E1B362624068</requestId> <patient> <requestedResolvedIdentifiers> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifiers> <resultantIdentifiers> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </resultantIdentifiers> <vitalSignObservationEvents> <errorReason> <reason> <code>errorReasontest_code_2001</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <errorReason> <reason> <code>errorReasontest_code_2002</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <errorReason> <reason> <code>errorReasontest_code_2001</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <errorReason> <reason> <code>errorReasontest_code_2002</code> <displayText>errorReasonDisplayTextLite</displayText> <codingSystem>errorReasonCodingSystemLite</codingSystem> </reason> </errorReason> <recordIdentifier> <identity>ID_12774088531861</identity> <namespaceId>Default Namespace</namespaceId> <universalId>UID_12774088531861</universalId> <universalIdType>aUniversalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <observationTime> <literal>20081230</literal> </observationTime> <observationMethod> <code>observationMethodtest_code_200</code> <displayText>observationMethodDisplayTextLite</displayText> <codingSystem>observationMethodCodingSystemLite</codingSystem> </observationMethod> <observedCharacteristic> <code>obsCharCodetest_code_2002</code> <displayText>obsCharCodeDisplayTextLite</displayText> <codingSystem>obsCharCodeCodingSystemLite</codingSystem> </observedCharacteristic> <collectionSessionTime> <literal>20100624134733</literal> </collectionSessionTime> <status>Status</status> <supplementalOxygen> <flowRateValue>theSoFlowRateValue</flowRateValue> <concentrationValue>theSoConcentrationValue</concentrationValue> <flowRateUnit> <code>soFlowRateUofMtest_code_2001</code> <displayText>soFlowRateUofMDisplayTextLite</displayText> <codingSystem>soFlowRateUofMCodingSystemLite</codingSystem> </flowRateUnit> <concentrationUnit> <code>soConcentrationUofMtest_code_2</code> <displayText>soConcentrationUofMDisplayTextLite</displayText> <codingSystem>soConcentrationUofMCodingSystemLite</codingSystem> </concentrationUnit> </supplementalOxygen> <author> <comment>Comment</comment> <time> <literal>20100624134733</literal> </time> <practitioner> <identifier> <identity>test_eid_1005</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>author</prefix> <family>PRACTITIONER</family> </name> </practitioner> </author> <homeTelehealthMonitor> <vendor>HthVendor</vendor> <homeAppliance>HthHomeAppliance</homeAppliance> <measurementDevice>HthmeasurementDevice</measurementDevice> </homeTelehealthMonitor> <hospitalLocationIdentifier> <pointOfCare>PointOfCare</pointOfCare> <room>Room</room> <bed>Bed</bed> <facilityNamespaceId>FacilityNamespaceId</facilityNamespaceId> <facilityUniversalId>FacilityUniversalId</facilityUniversalId> <facilityUniversalIdType>FacilityUniversalIdType</facilityUniversalIdType> <personLocationType>PersonLocationType</personLocationType> <locationDescription>HospCode</locationDescription> </hospitalLocationIdentifier> <division> <code>divisiontest_code_2005</code> <displayText>divisionDisplayTextLite</displayText> <codingSystem>divisionCodingSystemLite</codingSystem> </division> <orderingFacilityIdentifier> <identity>orgId</identity> <name>ordFacility</name> <assigningAuthority>assgnAuth</assigningAuthority> </orderingFacilityIdentifier> <stopCode> <code>stoptest_code_2005</code> <displayText>stopDisplayTextLite</displayText> <codingSystem>stopCodingSystemLite</codingSystem> </stopCode> <vitalSignObservation> <qualifier> <value> <code>Qualifier1test_code_2001</code> <displayText>Qualifier1DisplayTextLite</displayText> <codingSystem>Qualifier1CodingSystemLite</codingSystem> </value> </qualifier> <qualifier> <value> <code>Qualifier2test_code_2002</code> <displayText>Qualifier2DisplayTextLite</displayText> <codingSystem>Qualifier2CodingSystemLite</codingSystem> </value> </qualifier> <value>theVitalValue</value> <unit> <code>obsUofMtest_code_2003</code> <displayText>obsUofMDisplayTextLite</displayText> <codingSystem>obsUofMCodingSystemLite</codingSystem> </unit> </vitalSignObservation> <errorEnterer> <comment>Comment</comment> <time> <literal>20100624134733</literal> </time> <practitioner> <idSourceTable>thePractitionerIdSourceTable</idSourceTable> <identifier> <identity>test_eid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </identifier> <name> <prefix>errorEnterer</prefix> <family>PRACTITIONER</family> </name> </practitioner> </errorEnterer> <recordVersion>0</recordVersion> <recordUpdateTime> <literal>20100624134733</literal> </recordUpdateTime> </vitalSignObservationEvents> </patient> </clinicaldata:ClinicalData>";
        String templateId = TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID;
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );
        Document resultDoc = sequencer.sequence( templateId, unsequencedXml, validateReadResponseXml );
        assertNotNull( resultDoc );

        try
        {
            XmlComparator.assertXMLSimilar( sequencedXml, resultDoc.asXML() );
        }
        catch ( XmlCompareException xce )
        {
            fail();
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEmptySourceDocument( )
    {
        String templateId = TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );

        try
        {
            sequencer.sequence( templateId, "", validateReadResponseXml );
        }
        catch ( Exception ex )
        {
            assertTrue( ex.getMessage().contains( "SCHEMA_VALIDATION_FAILED" ) );
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testInvalidSourceDocument( )
    {
        String templateId = TemplateIdHelper.INTOLERANCE_CONDITION_READ_TEMPLATE_ID;
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );

        try
        {
            sequencer.sequence( templateId, "<clinicaldata:ClinicalData xmlns:clinicaldata='Clinicaldata'></clinicaldata:ClinicalData>",
                            validateReadResponseXml );
        }
        catch ( Exception ex )
        {
            assertTrue( ex.getMessage().contains( "SCHEMA_VALIDATION_FAILED" ) );
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testInvalidSchema( )
        throws Exception
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>IntoleranceConditionRead40010</templateId> <requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId> <patient> <requestedResolvedIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </requestedResolvedIdentifiers> <resultantIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </resultantIdentifiers> <intoleranceConditions> <recordIdentifier> <identity>FNTest_Intolerance_Condition_identity</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1204757305879100021</universalId> <universalIdType>aUniversalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <observationTime> <literal>196912311PORT0</literal> </observationTime> <agent> <code>Other3</code> <displayText>AgentDisplayTextLite</displayText> <codingSystem>AgentCodingSystemLite</codingSystem> </agent> <allergyType> <code>Other</code> <displayText>AllergyTypeDisplayTextLite</displayText> <codingSystem>AllergyTypeCodingSystemLite</codingSystem> </allergyType> <gmrAllergyAgent> <code>Other3</code> <displayText>AgentDisplayText</displayText> <codingSystem>AgentCodingSystem</codingSystem> <alternateCode>Agenttest_altcode_3004</alternateCode> <alternateDisplayText>AgentAltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>AgentAltCodingSystem</alternateCodingSystem> </gmrAllergyAgent> <informationSourceCategory> <code>test_code_2003</code> <displayText>ISC DisplayTextLite</displayText> <codingSystem>ISC CodingSystemLite</codingSystem> </informationSourceCategory> <mechanism> <code>test_code_2005</code> <displayText>Mechanism DisplayTextLite</displayText> <codingSystem>Mechanism CodingSystemLite</codingSystem> </mechanism> <status>Status</status> <verified>true</verified> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2002</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <reaction> <observationTime> <literal>196912311PORT0</literal> </observationTime> <reaction> <code>test_code_2003</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <verifier> <comment>Verifier Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_VERIFIERID_2002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </verifier> <author> <comment>Author Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_AUTHORID_1003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> <errorEnterer> <comment>ErrorEnterer Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_ERRORENTERERID_5004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </errorEnterer> <idBandMarker> <comment>ID Band Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <idBandMarker> <comment>ID Band Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <chartMarker> <comment>Chart Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <chartMarker> <comment>Chart Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <drugClass> <code> <code>Class6</code> <displayText>Drug Class 2DisplayText</displayText> <codingSystem>Drug Class 2CodingSystem</codingSystem> <alternateCode>Drug Class 2test_altcode_3005</alternateCode> <alternateDisplayText>Drug Class 2AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 2AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugClass> <code> <code>Class4</code> <displayText>Drug Class 1DisplayText</displayText> <codingSystem>Drug Class 1CodingSystem</codingSystem> <alternateCode>Drug Class 1test_altcode_3001</alternateCode> <alternateDisplayText>Drug Class 1AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 1AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugIngredient> <code> <code>Ingredient3</code> <displayText>Drug Ing. 2DisplayTextLite</displayText> <codingSystem>Drug Ing. 2CodingSystemLite</codingSystem> </code> </drugIngredient> <drugIngredient> <code> <code>Ingredient6</code> <displayText>Drug Ing. 1DisplayTextLite</displayText> <codingSystem>Drug Ing. 1CodingSystemLite</codingSystem> </code> </drugIngredient> <facilityIdentifier> <identity>OrganizationId</identity> <name>OrganizationName</name> <assigningAuthority>AssigningAuthNamespaceId</assigningAuthority> </facilityIdentifier> <recordVersion>10002</recordVersion> <recordUpdateTime> <literal>20080305154825</literal> </recordUpdateTime> </intoleranceConditions> </patient> </clinicaldata:ClinicalData>";
        String templateId = "invalid_template";
        ResponseSchemaSequencer sequencer = new ResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );

        try
        {
            sequencer.sequence( templateId, sequencedXml, validateReadResponseXml );
        }
        catch ( Exception ex )
        {
            assertTrue( ex.getMessage().contains( "READ_REQUEST_TEMPLATE_ID_INVALID" ) );
        }

    }
}
