

package gov.va.med.cds.response.organizer;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.response.organizer.strategy.OrderingStrategyInterface;

import org.dom4j.Document;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class ResponseOrganizerTest
{
    
    @Test
    @Suite( groups = "checkintest" )
    public void testOrganize( )
    {
        String xmlFilterRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
        "<filter:filter xmlns:filter='Filter'>" +
            "<filterId>TIU_SINGLE_PATIENT_LIST_DATA_FILTER</filterId>" +
                "<patients/>" +
            "<entryPointFilter queryName='ID_1'>" +
            "<domainEntryPoint>ClinicalDocumentEvent</domainEntryPoint>" +
            "<orderBy><xqueryExpression>/referenceDate/literal descending</xqueryExpression></orderBy>" +
            "</entryPointFilter>" +
        "</filter:filter>";

        // create mocks
        Document documentMock = EasyMock.createMock( Document.class );
        OrderingStrategyInterface strategyMock = EasyMock.createMock( OrderingStrategyInterface.class );
        
        // create responseOrganizer
        ResponseOrganizer responseOrganizer = new ResponseOrganizer();
        
        // set mocks
        responseOrganizer.setOrderingStrategy( strategyMock);
        
        // set expectations
        EasyMock.expect( strategyMock.order( "/referenceDate/literal descending","ClinicalDocumentEvent", documentMock ) ).andReturn( documentMock);
        
        // replay
        EasyMock.replay( strategyMock, documentMock );
        responseOrganizer.organize( xmlFilterRequest, documentMock  );
        
        // verify
        EasyMock.verify( strategyMock, documentMock );
    }

    @Test
    @Suite( groups = "checkintest" )
    public void testOrganize_NoSortCriteria( )
    {
        String xmlFilterNoOrderBy = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
        "<filter:filter xmlns:filter='Filter'>" +
            "<filterId>TIU_SINGLE_PATIENT_LIST_DATA_FILTER</filterId>" +
                "<patients/>" +
            "<entryPointFilter queryName='ID_1'>" +
            "<domainEntryPoint>ClinicalDocumentEvent</domainEntryPoint>" +
            "</entryPointFilter>" +
        "</filter:filter>";
        
        // create mocks
        OrderingStrategyInterface strategyMock = EasyMock.createMock( OrderingStrategyInterface.class );
        
        // create responseOrganizer
        ResponseOrganizer responseOrganizer = new ResponseOrganizer();
        
        // set mocks
        responseOrganizer.setOrderingStrategy( strategyMock );
        
        // strategy to sort xml is not called.
        
        // replay
        EasyMock.replay( strategyMock);
        responseOrganizer.organize( xmlFilterNoOrderBy, null);
        
        // verify
        EasyMock.verify( strategyMock);
    }
    
}
