

package gov.va.med.cds.response.organizer;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.dom4j.DocumentException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith( SuiteAwareRunner.class )
public class ResponseOrganazerExceptionTest
{

    @Test
    @Suite( groups = "checkintest"  )
    public void testResponseOrganazerExceptionErrorCodeEnumThrowableStringArray( )
    {
        String xmlFilterRequest = "<filter:filter></filter:filter> ";
        DocumentException e = new DocumentException( "Boom!" );
        ResponseOrganazerException exception = new ResponseOrganazerException( ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION, e, xmlFilterRequest );
        Assert.assertEquals( ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION, exception.getErrorCode() );
        Assert.assertNotNull( exception.getCause() );
        Assert.assertEquals( "FILTER_PARSER_DOM_EXCEPTION", exception.getMessage());
        Assert.assertEquals( xmlFilterRequest, exception.getCustomMsgValues()[0]);
    }
    
    @Test
    @Suite( groups = "checkintest"  )
    public void testResponseOrganazerExceptionErrorCodeEnumStringArray( )
    {
        ResponseOrganazerException exception = new ResponseOrganazerException( ErrorCodeEnum.XQUERY_EXPRESSION_EXCEPTION, "ClinicalDocumentEvent","//clinicalDocumentEvens", "//bad expression");
        Assert.assertEquals( ErrorCodeEnum.XQUERY_EXPRESSION_EXCEPTION, exception.getErrorCode() );
        Assert.assertNull( exception.getCause() );
        Assert.assertEquals( "XQUERY_EXPRESSION_EXCEPTION", exception.getMessage());
        String[]expected = "ClinicalDocumentEvent,//clinicalDocumentEvens,//bad expression".split(",");
        Assert.assertArrayEquals( expected, exception.getCustomMsgValues());
    }
  
}
