

package gov.va.med.cds.persistence.hibernate.common;


import static org.junit.Assert.fail;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.sql.ResultSet;
import java.sql.SQLException;

import junit.framework.Assert;

import org.dom4j.Element;
import org.easymock.EasyMock;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class VistaReducedReadPersonNameUserTypeTest
{
    final static String fromDb= "identity^prefix^given^middle^family^suffix^title";
    static VistaPersonName vistaPersonName = new VistaPersonName(fromDb);
    
    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeGet( )
        throws Exception
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();

        ResultSet resultSet = EasyMock.createMock( ResultSet.class );
        String[] names = { "person" };
        EasyMock.expect( resultSet.getString( names[0] ) ).andReturn( fromDb ).anyTimes();

        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );
        EasyMock.expect( sessionImplementor.getEntityMode() ).andReturn( EntityMode.DOM4J );

        EasyMock.replay( resultSet, sessionImplementor );

        Element element = ( Element )userType.nullSafeGet( resultSet, names, sessionImplementor, null );
        String expected = "<name><given>given</given><middle>middle</middle><family>prefix</family><suffix>suffix</suffix></name>";
        Assert.assertEquals( expected, element.asXML() );
    }


    @Test(expected = UnsupportedOperationException.class)
    @Suite( groups = "checkintest" )    
    public void testNullSafeSet( ) throws Exception
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        userType.nullSafeSet( null, null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testIsMutable( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertFalse( userType.isMutable() );
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testReplace( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertEquals( vistaPersonName,userType.replace( vistaPersonName , null, null, null ));
    }


    @Test(expected = UnsupportedOperationException.class)    
    @Suite( groups = "checkintest" )    
    public void testSetPropertyValue( )throws Exception
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        userType.setPropertyValue( null, 1, null );
    }


    @Test
    public void testAssemble( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertEquals(vistaPersonName, userType.assemble( vistaPersonName, null, null ));
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testDeepCopy( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertEquals(vistaPersonName, userType.deepCopy( vistaPersonName ));
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testDisassemble( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertEquals(vistaPersonName, userType.disassemble( vistaPersonName, null ));
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testNotEqualsObjectObject( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        VistaPersonName vistaPersonName1 = new VistaPersonName("^^^^^^^");       
        Assert.assertFalse( userType.equals( vistaPersonName, vistaPersonName1 ));
    }

    
    @Test
    @Suite( groups = "checkintest" )    
    public void testEqualsObjectObject( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertTrue( userType.equals( vistaPersonName, vistaPersonName ));
    }
    

    @Test
    @Suite( groups = "checkintest" )    
    public void testGetPropertyNames( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertEquals(0, userType.getPropertyNames().length);
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testGetPropertyTypes( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        userType.getPropertyTypes();
    }


    @Test(expected = UnsupportedOperationException.class)    
    @Suite( groups = "checkintest" )    
    public void testGetPropertyValue( ) throws Exception
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        userType.getPropertyValue(null, 1);
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testHashCodeObject( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertNotSame( 0, userType.hashCode( vistaPersonName ) );
    }

    @Test
    @Suite( groups = "checkintest" )    
    public void testHashCodeOfNull( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        Assert.assertEquals( 0, userType.hashCode( null ) );
    }


    @Test
    @Suite( groups = "checkintest" )    
    public void testReturnedClass( )
    {
        VistaReducedReadPersonNameUserType userType = new VistaReducedReadPersonNameUserType();
        
        Assert.assertEquals( vistaPersonName.getClass().getName(), userType.returnedClass().getName());
    }


}
