

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.junit.runners.Suite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

import java.util.Map;

import junit.framework.Assert;


public class VistaGlobalParserTest
{
    private final static Log logger = LogFactory.getLog( VistaGlobalParserTest.class );

    Map<String, LabTestsParsedFromGlobal> labTestsParsedFromGlobalMap;

    VistaGlobalParser vistaGlobalParser = new VistaGlobalParser();


    @Test
    @Suite( groups = { "checkintest" } )
    public void testParseGlobal( )
    {
        //183*122^L^82466.0000!^10958^72!NEG!POS!!!!mg/dL!^^^^500,
        //183*122^L^82466.0000!^10958^72!135!288!!!!mg/dL!^^^^500,
        //205*32^L^81132.0000!^10958^72!36!165!!!!mg/dL!^^^^500,
        //244*12^L^81132.0000!^10958^72!32!72!!!!MG/DL!^^^^500,
        //901*33^^81132.0000!^10958^72!!!!!!MG/DL!^^^^500,
        //489*H^^81004.0000!84930.0000!5767!4344!!!489^65321^71!!!!!!!!!^3130212.165255^^^613^1^^^1,
        //141*S^^81004.0000!81206.0000!5778!4344!!!141^65321^71!!!!!!!!!^3130212.165255^^^613^1
        //1*8.8^H^^755,2*4.57^^^755,
        //489*hazy^^81002.0000!84930.0000!5767!3217!!!489^520651452^71!!!!!!!!!^^^^10895^1^^^1,141*straw^^81002.0000!81206.0000!5778!3217!!!141^520651452^71!!!!!!!!!^^^^10895^1,143*1.013^^81002.0000!81198.0000!5811!3217!!!143^520651452^71!1.005!1.025!!^^^^10895^1,144*0.2^^81002.0000!84305.0000!19161!3217!!!144^520651452^71!.1!1!!!!EU/DL!!!0.2^^^^10895^1,1158*NEG^^81002.0000!81172.0000!33051!3217!!!1158^520651452^71!!"NEG"!!!!!!!NEG^^^^10895^1,146*NEG^^81002.0000!81174.0000!5770!3217!!!146^520651452^71!"Neg."!!!!!!!!NEG^^^^10895^1,147*NEG^^81002.0000!81047.3873!5797!3217!!!147^520651452^71!"Neg."!!!!!MG/DL!!!NEG^^^^10895^1^^^1,148*NEG^^81002.0000!82186.0000!2350!3217!!!148^520651452^71!"Neg."!!!!!MG/DL!!!NEG^^^^10895^1^^^1,149*NEG^^81002.0000!84156.0000!5804!3217!!!149^520651452^71!"Neg."!!!!!MG/DL!!!NEG^^^^10895^1,150*7.2^^81002.0000!81252.0000!5803!3217!!!150^520651452^71!5!9!!^^^^10895^1,1194*1+^^81002.0000!81822.0000!5802!3217!!!1194^520651452^71!"NEG"!!!!!!!!NEG^^^^10895^1,1195*trace^^81002.0000!81269.0000!5799!3217!!!1195^520651452^71!"NEG"!"POS"!!!!!!!NEG^^^^10895^1,1290*NO^^81002.0000!84499.0000!24356!3217!!!1290^520651452^71!!!!!!!42!!NO^^^^10895,

        //String globalTestString = "183*122^L^82466.0000!^10958^72!NEG!POS!!!!mg/dL!^^^^500,183*122^L^82466.0000!1.0!1.0!1.0!!!1.0^10958^72!135!288!!!!mg/dL!^^^^500,205*32^L^81132.0000!^10958^72!36!165!!!!mg/dL!^^^^500,244*12^L^81132.0000!^10958^72!32!72!!!!MG/DL!^^^^500,901*33^^81132.0000!^10958^72!!!!!!MG/DL!^^^^500,489*H^^81004.0000!84930.0000!5767!4344!!!489^65321^71!!!!!!!!!^3130212.165255^^^613^1^^^1,141*S^^81004.0000!81206.0000!5778!4344!!!141^65321^71!!!!!!!!!^3130212.165255^^^613^1,177*3.3^L,1*8.8^H^^755,2*4.57^^^755,";

        //globalTestString = globalTestString
          //              + "489*hazy^^81002.0000!84930.0000!5767!3217!!!489^520651452^71!!!!!!!!!^^^^10895^1^^^1,141*straw^^81002.0000!81206.0000!5778!3217!!!141^520651452^71!!!!!!!!!^^^^10895^1,143*1.013^^81002.0000!81198.0000!5811!3217!!!143^520651452^71!1.005!1.025!!^^^^10895^1,144*0.2^^81002.0000!84305.0000!19161!3217!!!144^520651452^71!.1!1!!!!EU/DL!!!0.2^^^^10895^1,1158*NEG^^81002.0000!81172.0000!33051!3217!!!1158^520651452^71!!\"NEG\"!!!!!!!NEG^^^^10895^1,146*NEG^^81002.0000!81174.0000!5770!3217!!!146^520651452^71!\"Neg.\"!!!!!!!!NEG^^^^10895^1,147*NEG^^81002.0000!81047.3873!5797!3217!!!147^520651452^71!\"Neg.\"!!!!!MG/DL!!!NEG^^^^10895^1^^^1,148*NEG^^81002.0000!82186.0000!2350!3217!!!148^520651452^71!\"Neg.\"!!!!!MG/DL!!!NEG^^^^10895^1^^^1,149*NEG^^81002.0000!84156.0000!5804!3217!!!149^520651452^71!\"Neg.\"!!!!!MG/DL!!!NEG^^^^10895^1,150*7.2^^81002.0000!81252.0000!5803!3217!!!150^520651452^71!5!9!!^^^^10895^1,1194*1+^^81002.0000!81822.0000!5802!3217!!!1194^520651452^71!\"NEG\"!!!!!!!!NEG^^^^10895^1,1195*trace^^81002.0000!81269.0000!5799!3217!!!1195^520651452^71!\"NEG\"!\"POS\"!!!!!!!NEG^^^^10895^1,1290*NO^^81002.0000!84499.0000!24356!3217!!!1290^520651452^71!!!!!!!42!!NO^^^^10895,";

    	String globalTestString = "1738**^^81132.0000!83017.0000!13457!4576!!!1738^10686^72!!130!!!!mg/dL!^^^^6540^1^^^1";

        labTestsParsedFromGlobalMap = vistaGlobalParser.parseGlobal( globalTestString );

        Assert.assertEquals( 1, labTestsParsedFromGlobalMap.keySet().size() );

        if ( logger.isDebugEnabled() )
        {
            logger.debug( "labTestsParsedFromGlobalMap : " + labTestsParsedFromGlobalMap );
        }

    }
}
