package gov.va.med.cds.persistence.hibernate;

import static org.junit.Assert.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class VistaRecordIdentifierQueryParameterTransformerTest
{

    @Before
    public void setUp( )
        throws Exception
    {
    }


    @After
    public void tearDown( )
        throws Exception
    {
    }


    @Test
    public void testTransformAndSetParameter( )
    {
        Map<String, Object> parametersMap = new HashMap<String, Object>();
        List<String> recordIdentifiers = new ArrayList<String>();
        recordIdentifiers.add("1/200");
        recordIdentifiers.add("2/200");
        recordIdentifiers.add("3/200");
        
        VistaRecordIdentifierQueryParameterTransformer transformer = new VistaRecordIdentifierQueryParameterTransformer();
        transformer.transformAndSetParameter( "recordIdentIdentifier", recordIdentifiers,  parametersMap);
        
        List<BigDecimal> vistaRecordIds = (List<BigDecimal>)parametersMap.get( "recordIdentIdentifier" );
        assertNotNull( vistaRecordIds );
        assertTrue( vistaRecordIds.size() == 3 );
        assertTrue( vistaRecordIds.get( 0 ).equals( new BigDecimal(1) ));
        assertTrue( vistaRecordIds.get( 1 ).equals( new BigDecimal(2) ));
        assertTrue( vistaRecordIds.get( 2 ).equals( new BigDecimal(3) ));
        
    }


    @Test(expected=IllegalArgumentException.class)
    public void testTransformAndSetParameterArrayError( )
    {
        Map<String, Object> parametersMap = new HashMap<String, Object>();
        String[] recordIdentifiers = new String[] {"1/200", "2/200", "3/200"};
        
        VistaRecordIdentifierQueryParameterTransformer transformer = new VistaRecordIdentifierQueryParameterTransformer();
        transformer.transformAndSetParameter( "recordIdentIdentifier", recordIdentifiers,  parametersMap);
    }

}
