package gov.va.med.cds.persistence.hibernate;

import static org.easymock.EasyMock.anyObject;
import static org.easymock.EasyMock.eq;
import static org.easymock.EasyMock.expect;
import static org.powermock.api.easymock.PowerMock.createMock;
import static org.powermock.api.easymock.PowerMock.replay;
import static org.powermock.api.easymock.PowerMock.verify;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.persistence.hibernate.common.Dom4jPointInTimeUserType;
import gov.va.med.cds.persistence.hibernate.interceptor.XmlTypeExtractQueryInterceptor;

import java.util.List;
import java.util.Map;

import org.dom4j.DocumentHelper;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PageableQueryWorkTest
{

    @Before
    public void setUp( )
        throws Exception
    {
    }


    @After
    public void tearDown( )
        throws Exception
    {
    }


    @Test
    public void testRunPaging( )
    {
        // set up the mock objects for the test
        Session session = createMock( Session.class );
        QueryAssociationInterface queryAssociation = createMock( QueryAssociationInterface.class );
        EntryFilterInterface entryFilter = createMock( EntryFilterInterface.class );
        QueryNameBuilderInterface queryNameBuilder = createMock( QueryNameBuilderInterface.class );
        FilterParameterExtractorInterface filterParameterExtractor = createMock( FilterParameterExtractorInterface.class );
        Map<String, QueryParameterTransformerInterface> parameterTransformerMap = createMock( Map.class );
        Map<String, Object> filterParameters = createMock( Map.class );
        QueryParameterBinderInterface queryParameterBinder = createMock( QueryParameterBinderInterface.class );
        Map<String, String> templateTimeoutMap = createMock( Map.class );
        List<String> personIdentifiers = createMock( List.class );
        QueryParameterTransformerInterface pidsParameterTransformer = createMock( QueryParameterTransformerInterface.class );
        Query query = createMock( Query.class );
        ScrollableResults scrollableResults = createMock( ScrollableResults.class );
        
        // set the expectations for the request
        expect(queryAssociation.getAssociationName()).andReturn( "association" );
        expect(queryNameBuilder.buildQueryName( entryFilter, "association" )).andReturn( "templateId.clinicalDomainName.association.date" );
        expect(session.getNamedQuery( "templateId.clinicalDomainName.association.date" )).andReturn( query );
        expect(filterParameterExtractor.extractNamedParameters( parameterTransformerMap, entryFilter )).andReturn( filterParameters );
        expect(entryFilter.isPatientCentricFilter()).andReturn( true );
        expect(parameterTransformerMap.get( FilterParameterExtractorInterface.PN_PERSON_IDENTIFIERS )).andReturn( pidsParameterTransformer );
        expect(personIdentifiers.size()).andReturn( 10 );
        pidsParameterTransformer.transformAndSetParameter( eq(FilterParameterExtractorInterface.PN_PERSON_IDENTIFIERS), eq(personIdentifiers), anyObject(Map.class) );
        expect(queryParameterBinder.bindQueryParameters( query, filterParameters, Dom4jPointInTimeUserType.class )).andReturn(query);
        expect(query.setReadOnly( true )).andReturn( query );
        expect(query.scroll()).andReturn(scrollableResults);
        expect(scrollableResults.last()).andReturn( true );
        expect(scrollableResults.getRowNumber()).andReturn( 100 );
        expect(entryFilter.isCountOnly()).andReturn(false);
        expect(entryFilter.isPagingFilter()).andReturn( true ).anyTimes();
        expect(queryAssociation.getFilterModelName()).andReturn( "entryPoint" ).anyTimes();
        expect(entryFilter.getDomainEntryPoint()).andReturn( "entryPoint").anyTimes();
        expect(entryFilter.getPageNumber()).andReturn( 1 );
        expect(entryFilter.getPageSize()).andReturn( 20 ).anyTimes();
        expect(query.setFirstResult( 0 )).andReturn( query );
        expect(query.setMaxResults( 20 )).andReturn( query );
        expect(query.scroll()).andReturn( scrollableResults );
        expect(scrollableResults.first()).andReturn( true );
        expect(scrollableResults.get()).andReturn( new Object[] { DocumentHelper.createElement( "clinicalDocument" ) } );
        expect(scrollableResults.next()).andReturn( false );
        expect(scrollableResults.last()).andReturn( true );
        expect(scrollableResults.getRowNumber()).andReturn( 0 );
        expect(scrollableResults.getRowNumber()).andReturn( 0 );
        
        
        // get the mocks ready to be used in the test
        replay( session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, 
                        queryParameterBinder, personIdentifiers, query, scrollableResults, filterParameters,
                        pidsParameterTransformer);
        
        QueryWorkInterface queryWork = new PageableQueryWork( session, queryAssociation, entryFilter, queryNameBuilder, 
                        filterParameterExtractor, parameterTransformerMap, queryParameterBinder, 
                        personIdentifiers, Dom4jPointInTimeUserType.class, "applicationName", "siteId" );
        
        queryWork.run();
        
        
        // verify the results of the test
        verify( session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, 
                        queryParameterBinder, personIdentifiers, query, scrollableResults, filterParameters,
                        pidsParameterTransformer );
    }
    
    
    @Test
    public void testRunCountOnly( )
    {
        // set up the mock objects for the test
        Session session = createMock( Session.class );
        QueryAssociationInterface queryAssociation = createMock( QueryAssociationInterface.class );
        EntryFilterInterface entryFilter = createMock( EntryFilterInterface.class );
        QueryNameBuilderInterface queryNameBuilder = createMock( QueryNameBuilderInterface.class );
        FilterParameterExtractorInterface filterParameterExtractor = createMock( FilterParameterExtractorInterface.class );
        Map<String, QueryParameterTransformerInterface> parameterTransformerMap = createMock( Map.class );
        Map<String, Object> filterParameters = createMock( Map.class );
        QueryParameterBinderInterface queryParameterBinder = createMock( QueryParameterBinderInterface.class );
        Map<String, String> templateTimeoutMap = createMock( Map.class );
        List<String> personIdentifiers = createMock( List.class );
        QueryParameterTransformerInterface pidsParameterTransformer = createMock( QueryParameterTransformerInterface.class );
        Query query = createMock( Query.class );
        ScrollableResults scrollableResults = createMock( ScrollableResults.class );
        
        // set the expectations for the request
        expect(queryAssociation.getAssociationName()).andReturn( "association" );
        expect(queryNameBuilder.buildQueryName( entryFilter, "association" )).andReturn( "templateId.clinicalDomainName.association.date" );
        expect(session.getNamedQuery( "templateId.clinicalDomainName.association.date" )).andReturn( query );
        expect(filterParameterExtractor.extractNamedParameters( parameterTransformerMap, entryFilter )).andReturn( filterParameters );
        expect(entryFilter.isPatientCentricFilter()).andReturn( true );
        expect(parameterTransformerMap.get( FilterParameterExtractorInterface.PN_PERSON_IDENTIFIERS )).andReturn( pidsParameterTransformer );
        expect(personIdentifiers.size()).andReturn(10);
        pidsParameterTransformer.transformAndSetParameter( eq(FilterParameterExtractorInterface.PN_PERSON_IDENTIFIERS), eq(personIdentifiers), anyObject(Map.class) );
        expect(queryParameterBinder.bindQueryParameters( query, filterParameters, Dom4jPointInTimeUserType.class )).andReturn(query);
        expect(query.setReadOnly( true )).andReturn( query );
        expect(query.scroll()).andReturn(scrollableResults);
        expect(scrollableResults.last()).andReturn( true );
        expect(scrollableResults.getRowNumber()).andReturn( 100 );
        expect(entryFilter.isCountOnly()).andReturn(true);
        expect(queryAssociation.getFilterModelName()).andReturn( "entryPoint" ).anyTimes();
        expect(entryFilter.getDomainEntryPoint()).andReturn( "entryPoint").anyTimes();
        expect(entryFilter.isPagingFilter()).andReturn( false );
        
        // get the mocks ready to be used in the test
        replay( session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, 
                        queryParameterBinder, personIdentifiers, query, scrollableResults, filterParameters,
                        pidsParameterTransformer);
        
        QueryWorkInterface queryWork = new PageableQueryWork( session, queryAssociation, entryFilter, queryNameBuilder, 
                        filterParameterExtractor, parameterTransformerMap, queryParameterBinder, 
                        personIdentifiers, Dom4jPointInTimeUserType.class, "applicationName", "siteId" );
        
        queryWork.run();
        
        
        // verify the results of the test
        verify( session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, 
                        queryParameterBinder, personIdentifiers, query, scrollableResults, filterParameters,
                        pidsParameterTransformer );
    }

}
